/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyMetaExtended;
import org.apache.juneau.html.HtmlRender;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.internal.ClassUtils;

public final class HtmlBeanPropertyMeta
extends BeanPropertyMetaExtended {
    private final boolean asXml;
    private final boolean noTables;
    private final boolean noTableHeaders;
    private final boolean asPlainText;
    private final HtmlRender render;
    private final String link;

    public HtmlBeanPropertyMeta(BeanPropertyMeta bpm) throws Exception {
        super(bpm);
        Builder b = new Builder();
        if (bpm.getField() != null) {
            b.findHtmlInfo(bpm.getField().getAnnotation(Html.class));
        }
        if (bpm.getGetter() != null) {
            b.findHtmlInfo(bpm.getGetter().getAnnotation(Html.class));
        }
        if (bpm.getSetter() != null) {
            b.findHtmlInfo(bpm.getSetter().getAnnotation(Html.class));
        }
        this.asXml = b.asXml;
        this.noTables = b.noTables;
        this.noTableHeaders = b.noTableHeaders;
        this.asPlainText = b.asPlainText;
        this.render = ClassUtils.newInstance(HtmlRender.class, b.render, new Object[0]);
        this.link = b.link;
    }

    protected boolean isAsXml() {
        return this.asXml;
    }

    protected boolean isAsPlainText() {
        return this.asPlainText;
    }

    protected boolean isNoTables() {
        return this.noTables;
    }

    public boolean isNoTableHeaders() {
        return this.noTableHeaders;
    }

    public HtmlRender getRender() {
        return this.render;
    }

    public String getLink() {
        return this.link;
    }

    private static class Builder {
        boolean asXml;
        boolean noTables;
        boolean noTableHeaders;
        boolean asPlainText;
        Class<? extends HtmlRender> render = HtmlRender.class;
        String link;

        private Builder() {
        }

        void findHtmlInfo(Html html) {
            if (html == null) {
                return;
            }
            if (html.asXml()) {
                this.asXml = html.asXml();
            }
            if (html.noTables()) {
                this.noTables = html.noTables();
            }
            if (html.noTableHeaders()) {
                this.noTableHeaders = html.noTableHeaders();
            }
            if (html.asPlainText()) {
                this.asPlainText = html.asPlainText();
            }
            if (html.render() != HtmlRender.class) {
                this.render = html.render();
            }
            if (!html.link().isEmpty()) {
                this.link = html.link();
            }
        }
    }
}

