/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.Session;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.transform.PojoSwap;

public class BeanSession
extends Session {
    private final BeanContext ctx;
    private final Locale locale;
    private final TimeZone timeZone;
    private final MediaType mediaType;
    private final boolean debug;
    private Stack<StringBuilder> sbStack = new Stack();

    protected BeanSession(BeanContext ctx, ObjectMap op, Locale locale, TimeZone timeZone, MediaType mediaType) {
        super(ctx, op);
        this.ctx = ctx;
        Locale _locale = null;
        if (op == null || op.isEmpty()) {
            _locale = locale != null ? locale : ctx.locale;
            this.timeZone = timeZone != null ? timeZone : ctx.timeZone;
            this.debug = ctx.debug;
            this.mediaType = mediaType != null ? mediaType : ctx.mediaType;
        } else {
            _locale = locale == null ? op.get(Locale.class, "BeanContext.locale", ctx.locale) : locale;
            this.timeZone = timeZone == null ? op.get(TimeZone.class, "BeanContext.timeZone", ctx.timeZone) : timeZone;
            this.debug = op.getBoolean("BeanContext.debug", false);
            this.mediaType = mediaType == null ? op.get(MediaType.class, "BeanContext.mediaType", ctx.mediaType) : mediaType;
        }
        this.locale = _locale == null ? Locale.getDefault() : _locale;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final TimeZone getTimeZone() {
        return this.timeZone;
    }

    public final boolean isDebug() {
        return this.debug;
    }

    public final boolean isIgnoreUnknownBeanProperties() {
        return this.ctx.ignoreUnknownBeanProperties;
    }

    public final <T> T convertToType(Object value, Class<T> type) throws InvalidDataConversionException {
        if (value != null && value.getClass() == type) {
            return (T)value;
        }
        return this.convertToType(null, value, this.ctx.getClassMeta(type));
    }

    public final <T> T convertToType(Object outer, Object value, Class<T> type) throws InvalidDataConversionException {
        return this.convertToType(outer, value, this.ctx.getClassMeta(type));
    }

    public final <T> T convertToType(Object value, ClassMeta<T> type) throws InvalidDataConversionException {
        return this.convertToType(null, value, type);
    }

    public final <T> T convertToType(Object outer, Object value, ClassMeta<T> type) throws InvalidDataConversionException {
        if (type == null) {
            type = this.ctx.object();
        }
        try {
            String s;
            Long l;
            Object n;
            ClassMeta<Object> vt;
            if (value == null) {
                if (type.isPrimitive()) {
                    return (T)type.getPrimitiveDefault();
                }
                return null;
            }
            Class<Object> tc = type.getInnerClass();
            if (!(!tc.isInstance(value) || type.isMap() && type.getValueType().isNotObject() || type.isCollection() && type.getElementType().isNotObject())) {
                return (T)value;
            }
            if (tc == Class.class) {
                return (T)this.ctx.classLoader.loadClass(value.toString());
            }
            if (type.getPojoSwap() != null) {
                PojoSwap<Object, Object> f = type.getPojoSwap();
                Class<Object> nc = f.getNormalClass();
                Class<?> fc = f.getSwapClass();
                if (ClassUtils.isParentClass(nc, tc) && ClassUtils.isParentClass(fc, value.getClass())) {
                    return (T)f.unswap(this, value, type);
                }
            }
            if ((vt = this.ctx.getClassMetaForObject(value)).getPojoSwap() != null) {
                PojoSwap<Object, ?> f = vt.getPojoSwap();
                Class<Object> nc = f.getNormalClass();
                Class<?> fc = f.getSwapClass();
                if (ClassUtils.isParentClass(nc, vt.getInnerClass()) && ClassUtils.isParentClass(fc, tc)) {
                    return (T)f.swap(this, value);
                }
            }
            if (type.isPrimitive()) {
                if (value.toString().isEmpty()) {
                    return (T)type.getPrimitiveDefault();
                }
                if (type.isNumber()) {
                    if (value instanceof Number) {
                        n = (Number)value;
                        if (tc == Integer.TYPE) {
                            return (T)Integer.valueOf(((Number)n).intValue());
                        }
                        if (tc == Short.TYPE) {
                            return (T)Short.valueOf(((Number)n).shortValue());
                        }
                        if (tc == Long.TYPE) {
                            return (T)Long.valueOf(((Number)n).longValue());
                        }
                        if (tc == Float.TYPE) {
                            return (T)Float.valueOf(((Number)n).floatValue());
                        }
                        if (tc == Double.TYPE) {
                            return (T)Double.valueOf(((Number)n).doubleValue());
                        }
                        if (tc == Byte.TYPE) {
                            return (T)Byte.valueOf(((Number)n).byteValue());
                        }
                    } else {
                        int multiplier;
                        n = null;
                        n = value instanceof Boolean ? ((Boolean)value != false ? "1" : "0") : value.toString();
                        int n2 = multiplier = tc == Integer.TYPE || tc == Short.TYPE || tc == Long.TYPE ? BeanSession.getMultiplier((String)n) : 1;
                        if (multiplier != 1) {
                            n = ((String)n).substring(0, ((String)n).length() - 1).trim();
                            l = Long.valueOf((String)n) * (long)multiplier;
                            if (tc == Integer.TYPE) {
                                return (T)Integer.valueOf(l.intValue());
                            }
                            if (tc == Short.TYPE) {
                                return (T)Short.valueOf(l.shortValue());
                            }
                            if (tc == Long.TYPE) {
                                return (T)l;
                            }
                        } else {
                            if (tc == Integer.TYPE) {
                                return (T)Integer.valueOf((String)n);
                            }
                            if (tc == Short.TYPE) {
                                return (T)Short.valueOf((String)n);
                            }
                            if (tc == Long.TYPE) {
                                return (T)Long.valueOf((String)n);
                            }
                            if (tc == Float.TYPE) {
                                return (T)new Float((String)n);
                            }
                            if (tc == Double.TYPE) {
                                return (T)new Double((String)n);
                            }
                            if (tc == Byte.TYPE) {
                                return (T)Byte.valueOf((String)n);
                            }
                        }
                    }
                } else {
                    if (type.isChar()) {
                        s = value.toString();
                        return (T)Character.valueOf(s.length() == 0 ? (char)'\u0000' : s.charAt(0));
                    }
                    if (type.isBoolean()) {
                        if (value instanceof Number) {
                            int i = ((Number)value).intValue();
                            return (T)(i == 0 ? Boolean.FALSE : Boolean.TRUE);
                        }
                        return (T)Boolean.valueOf(value.toString());
                    }
                }
            }
            if (type.isNumber()) {
                if (value instanceof Number) {
                    n = (Number)value;
                    if (tc == Integer.class) {
                        return (T)Integer.valueOf(((Number)n).intValue());
                    }
                    if (tc == Short.class) {
                        return (T)Short.valueOf(((Number)n).shortValue());
                    }
                    if (tc == Long.class) {
                        return (T)Long.valueOf(((Number)n).longValue());
                    }
                    if (tc == Float.class) {
                        return (T)Float.valueOf(((Number)n).floatValue());
                    }
                    if (tc == Double.class) {
                        return (T)Double.valueOf(((Number)n).doubleValue());
                    }
                    if (tc == Byte.class) {
                        return (T)Byte.valueOf(((Number)n).byteValue());
                    }
                    if (tc == Byte.class) {
                        return (T)Byte.valueOf(((Number)n).byteValue());
                    }
                    if (tc == AtomicInteger.class) {
                        return (T)new AtomicInteger(((Number)n).intValue());
                    }
                    if (tc == AtomicLong.class) {
                        return (T)new AtomicLong(((Number)n).intValue());
                    }
                } else {
                    int multiplier;
                    if (value.toString().isEmpty()) {
                        return null;
                    }
                    n = null;
                    n = value instanceof Boolean ? ((Boolean)value != false ? "1" : "0") : value.toString();
                    int n3 = multiplier = tc == Integer.class || tc == Short.class || tc == Long.class ? BeanSession.getMultiplier((String)n) : 1;
                    if (multiplier != 1) {
                        n = ((String)n).substring(0, ((String)n).length() - 1).trim();
                        l = Long.valueOf((String)n) * (long)multiplier;
                        if (tc == Integer.TYPE) {
                            return (T)Integer.valueOf(l.intValue());
                        }
                        if (tc == Short.TYPE) {
                            return (T)Short.valueOf(l.shortValue());
                        }
                        if (tc == Long.TYPE) {
                            return (T)l;
                        }
                    } else {
                        if (tc == Integer.class) {
                            return (T)Integer.valueOf((String)n);
                        }
                        if (tc == Short.class) {
                            return (T)Short.valueOf((String)n);
                        }
                        if (tc == Long.class) {
                            return (T)Long.valueOf((String)n);
                        }
                        if (tc == Float.class) {
                            return (T)new Float((String)n);
                        }
                        if (tc == Double.class) {
                            return (T)new Double((String)n);
                        }
                        if (tc == Byte.class) {
                            return (T)Byte.valueOf((String)n);
                        }
                        if (tc == AtomicInteger.class) {
                            return (T)new AtomicInteger(Integer.valueOf((String)n));
                        }
                        if (tc == AtomicLong.class) {
                            return (T)new AtomicLong(Long.valueOf((String)n));
                        }
                    }
                }
            }
            if (type.isChar()) {
                s = value.toString();
                return (T)Character.valueOf(s.length() == 0 ? (char)'\u0000' : s.charAt(0));
            }
            if (type.isArray()) {
                if (vt.isCollection()) {
                    return (T)this.toArray(type, (Collection)value);
                }
                if (vt.isArray()) {
                    return (T)this.toArray(type, Arrays.asList((Object[])value));
                }
                if (StringUtils.startsWith(value.toString(), '[')) {
                    return (T)this.toArray(type, new ObjectList(value.toString()).setBeanSession(this));
                }
                return (T)this.toArray(type, new ObjectList(StringUtils.split(value.toString())).setBeanSession(this));
            }
            if (type.isMap()) {
                try {
                    Map<String, Object> m;
                    if (value instanceof Map) {
                        m = type.canCreateNewInstance(outer) ? (Map)type.newInstance(outer) : new ObjectMap(this);
                        ClassMeta<?> keyType = type.getKeyType();
                        Object[] valueType = type.getValueType();
                        for (Map.Entry e : ((Map)value).entrySet()) {
                            Object k = e.getKey();
                            if (keyType.isNotObject()) {
                                k = keyType.isString() && k.getClass() != Class.class ? k.toString() : this.convertToType((Object)m, k, keyType);
                            }
                            Object v = e.getValue();
                            if (valueType.isNotObject()) {
                                v = this.convertToType((Object)m, v, (ClassMeta<T>)valueType);
                            }
                            m.put((String)k, v);
                        }
                        return (T)m;
                    }
                    if (!type.canCreateNewInstanceFromString(outer)) {
                        m = new ObjectMap(value.toString(), (Parser)this.ctx.defaultParser);
                        return (T)this.convertToType(outer, (Object)m, type);
                    }
                }
                catch (Exception e) {
                    throw new InvalidDataConversionException(value.getClass(), type, e);
                }
            }
            if (type.isCollection()) {
                try {
                    Collection<Object> l2 = type.canCreateNewInstance(outer) ? (Collection)type.newInstance(outer) : new ObjectList(this);
                    ClassMeta<?> elementType = type.getElementType();
                    if (value.getClass().isArray()) {
                        for (Object o : (Object[])value) {
                            l2.add(elementType.isObject() ? o : this.convertToType(l2, o, elementType));
                        }
                    } else if (value instanceof Collection) {
                        for (Object o : (Collection)value) {
                            l2.add(elementType.isObject() ? o : this.convertToType(l2, o, elementType));
                        }
                    } else if (value instanceof Map) {
                        l2.add(elementType.isObject() ? value : this.convertToType(l2, value, elementType));
                    } else if (!value.toString().isEmpty()) {
                        throw new InvalidDataConversionException(value.getClass(), type, null);
                    }
                    return (T)l2;
                }
                catch (InvalidDataConversionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new InvalidDataConversionException(value.getClass(), type, e);
                }
            }
            if (type.isEnum()) {
                if (type.canCreateNewInstanceFromString(outer)) {
                    return (T)type.newInstanceFromString(outer, value.toString());
                }
                return (T)Enum.valueOf(tc, value.toString());
            }
            if (type.isString()) {
                if (vt.isMapOrBean() || vt.isCollectionOrArray()) {
                    if (JsonSerializer.DEFAULT_LAX != null) {
                        return (T)JsonSerializer.DEFAULT_LAX.serialize(value);
                    }
                } else if (vt.isClass()) {
                    return (T)ClassUtils.getReadableClassName((Class)value);
                }
                return (T)value.toString();
            }
            if (type.isCharSequence()) {
                Class<?> c = value.getClass();
                if (c.isArray()) {
                    if (c.getComponentType().isPrimitive()) {
                        ObjectList l3 = new ObjectList(this);
                        int size = Array.getLength(value);
                        for (int i = 0; i < size; ++i) {
                            l3.add(Array.get(value, i));
                        }
                        value = l3;
                    }
                    value = new ObjectList((Object[])value).setBeanSession(this);
                }
                return (T)type.newInstanceFromString(outer, value.toString());
            }
            if (type.isBoolean()) {
                if (value instanceof Number) {
                    return (T)Boolean.valueOf(((Number)value).intValue() != 0);
                }
                return (T)Boolean.valueOf(value.toString());
            }
            if (type.isBean() && value instanceof Map) {
                ClassMeta<?> cm;
                ObjectMap m2;
                String typeName;
                if (value instanceof ObjectMap && (typeName = (m2 = (ObjectMap)value).getString(this.getBeanTypePropertyName(type))) != null && (cm = type.getBeanRegistry().getClassMeta(typeName)) != null && ClassUtils.isParentClass(type.innerClass, cm.innerClass)) {
                    return (T)m2.cast(cm);
                }
                return (T)this.newBeanMap(tc).load((Map)value).getBean();
            }
            if (type.canCreateNewInstanceFromNumber(outer) && value instanceof Number) {
                return (T)type.newInstanceFromNumber(this, outer, (Number)value);
            }
            if (type.canCreateNewInstanceFromString(outer)) {
                return (T)type.newInstanceFromString(outer, value.toString());
            }
            if (type.isBean()) {
                return (T)this.newBeanMap(type.getInnerClass()).load(value.toString()).getBean();
            }
        }
        catch (Exception e) {
            throw new InvalidDataConversionException(value, type, e);
        }
        throw new InvalidDataConversionException(value, type, null);
    }

    private static int getMultiplier(String s) {
        if (s.endsWith("G")) {
            return 0x40000000;
        }
        if (s.endsWith("M")) {
            return 0x100000;
        }
        if (s.endsWith("K")) {
            return 1024;
        }
        return 1;
    }

    public final Object toArray(ClassMeta<?> type, Collection<?> list) {
        if (list == null) {
            return null;
        }
        ClassMeta<Object> componentType = type.isArgs() ? this.object() : type.getElementType();
        Object array = Array.newInstance(componentType.getInnerClass(), list.size());
        int i = 0;
        for (Object o : list) {
            if (!type.getInnerClass().isInstance(o)) {
                o = componentType.isArray() && o instanceof Collection ? this.toArray(componentType, (Collection)o) : (o == null && componentType.isPrimitive() ? componentType.getPrimitiveDefault() : this.convertToType(null, o, componentType));
            }
            try {
                Array.set(array, i++, o);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw e;
            }
        }
        return array;
    }

    public final <T> BeanMap<T> toBeanMap(T o) {
        return this.toBeanMap(o, o.getClass());
    }

    public final boolean isBean(Object o) {
        if (o == null) {
            return false;
        }
        return this.isBean(o.getClass());
    }

    public final boolean isBean(Class<?> c) {
        return this.getBeanMeta(c) != null;
    }

    public final <T> BeanMap<T> toBeanMap(T o, Class<? super T> c) throws BeanRuntimeException {
        ClassMeta<T> cm;
        BeanMeta<? super T> m;
        ThrowableUtils.assertFieldNotNull(o, "o");
        ThrowableUtils.assertFieldNotNull(c, "c");
        if (!c.isInstance(o)) {
            ThrowableUtils.illegalArg("The specified object is not an instance of the specified class.  class=''{0}'', objectClass=''{1}'', object=''{2}''", c.getName(), o.getClass().getName(), 0);
        }
        if ((m = (cm = this.getClassMeta(c)).getBeanMeta()) == null) {
            throw new BeanRuntimeException(c, "Class is not a bean.  Reason=''{0}''", cm.getNotABeanReason());
        }
        return new BeanMap<T>(this, o, m);
    }

    public final <T> BeanMap<T> newBeanMap(Class<T> c) {
        return this.newBeanMap(null, c);
    }

    public final <T> BeanMap<T> newBeanMap(Object outer, Class<T> c) {
        BeanMeta<T> m = this.getBeanMeta(c);
        if (m == null) {
            return null;
        }
        Object bean = null;
        if (m.constructorArgs.length == 0) {
            bean = this.newBean(outer, c);
        }
        return new BeanMap<Object>(this, bean, (BeanMeta<Object>)m);
    }

    public final <T> T newBean(Class<T> c) throws BeanRuntimeException {
        return this.newBean(null, c);
    }

    public final <T> T newBean(Object outer, Class<T> c) throws BeanRuntimeException {
        ClassMeta<T> cm = this.getClassMeta(c);
        BeanMeta<T> m = cm.getBeanMeta();
        if (m == null) {
            return null;
        }
        try {
            T o = m.newBean(outer);
            if (o == null) {
                throw new BeanRuntimeException(c, "Class does not have a no-arg constructor.", new Object[0]);
            }
            return o;
        }
        catch (BeanRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanRuntimeException(e);
        }
    }

    public final <T> BeanMeta<T> getBeanMeta(Class<T> c) {
        if (c == null) {
            return null;
        }
        return this.getClassMeta(c).getBeanMeta();
    }

    public final <T> ClassMeta<T> getClassMeta(Class<T> c) {
        return this.ctx.getClassMeta(c);
    }

    public final <T> ClassMeta<T> getClassMeta(Type type, Type ... args) {
        return this.ctx.getClassMeta(type, args);
    }

    public final ClassMeta<Object[]> getArgsClassMeta(Type[] classes) {
        ThrowableUtils.assertFieldNotNull(classes, "classes");
        ClassMeta[] cm = new ClassMeta[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            cm[i] = this.getClassMeta(classes[i], new Type[0]);
        }
        return new ClassMeta<Object[]>(cm);
    }

    public final <T> ClassMeta<T> getClassMetaForObject(T o) {
        if (o == null) {
            return null;
        }
        return this.getClassMeta(o.getClass());
    }

    public final String getBeanTypePropertyName(ClassMeta cm) {
        String s = cm == null ? null : cm.getBeanTypePropertyName();
        return s == null ? this.ctx.beanTypePropertyName : s;
    }

    public final BeanRegistry getBeanRegistry() {
        return this.ctx.beanRegistry;
    }

    public final StringBuilder getStringBuilder() {
        if (this.sbStack.isEmpty()) {
            return new StringBuilder();
        }
        return this.sbStack.pop();
    }

    public final void returnStringBuilder(StringBuilder sb) {
        if (sb == null) {
            return;
        }
        sb.setLength(0);
        this.sbStack.push(sb);
    }

    public final ClassMeta<Object> object() {
        return this.ctx.cmObject;
    }

    public final ClassMeta<String> string() {
        return this.ctx.cmString;
    }

    public final ClassMeta<Class> _class() {
        return this.ctx.cmClass;
    }

    public final ClassLoader getClassLoader() {
        return this.ctx.classLoader;
    }

    public final MediaType getMediaType() {
        return this.mediaType;
    }

    @Override
    public final ObjectMap asMap() {
        return super.asMap().appendAll(this.ctx.asMap()).append("BeanSession", new ObjectMap().append("locale", this.locale).append("timeZone", this.timeZone));
    }

    @Override
    public boolean close() throws BeanRuntimeException {
        if (super.close()) {
            if (this.debug && this.hasWarnings()) {
                throw new BeanRuntimeException("Warnings occurred in session: \n" + StringUtils.join(this.getWarnings(), "\n"));
            }
            return true;
        }
        return false;
    }
}

