// ***************************************************************************************************************************
// * Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements.  See the NOTICE file *
// * distributed with this work for additional information regarding copyright ownership.  The ASF licenses this file        *
// * to you under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance            *
// * with the License.  You may obtain a copy of the License at                                                              *
// *                                                                                                                         *
// *  http://www.apache.org/licenses/LICENSE-2.0                                                                             *
// *                                                                                                                         *
// * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an  *
// * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the License for the        *
// * specific language governing permissions and limitations under the License.                                              *
// ***************************************************************************************************************************
package org.apache.juneau.encoders;

import org.apache.juneau.*;

/**
 * Represents a encoder and encoding that matches an HTTP <code>Accept-Encoding</code> header value.
 */
public final class EncoderMatch {

	private final MediaType mediaType;
	private final Encoder encoder;

	EncoderMatch(MediaType mediaType, Encoder encoder) {
		this.mediaType = mediaType;
		this.encoder = encoder;
	}

	/**
	 * Returns the encoding of the encoder that matched the HTTP <code>Accept-Encoding</code> header value.
	 *
	 * @return The encoding of the match.
	 */
	public String getEncoding() {
		return mediaType.getType();
	}

	/**
	 * Returns the encoder that matched the HTTP <code>Accept-Encoding</code> header value.
	 *
	 * @return The encoder of the match.
	 */
	public Encoder getEncoder() {
		return encoder;
	}
}
