/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.Resource;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfParserContext;
import org.apache.juneau.parser.ParserContext;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.NamespaceFactory;
import org.apache.juneau.xml.XmlUtils;

public class RdfParserSession
extends ParserSession {
    private final String rdfLanguage;
    private final Namespace juneauNs;
    private final Namespace juneauBpNs;
    private final Property pRoot;
    private final Property pValue;
    private final Property pType;
    private final Property pRdfType;
    private final Model model;
    private final boolean trimWhitespace;
    private final boolean looseCollections;
    private final RDFReader rdfReader;
    private final Set<Resource> urisVisited = new HashSet<Resource>();
    private final RdfCollectionFormat collectionFormat;

    protected RdfParserSession(RdfParserContext ctx, ObjectMap op, Object input, Method javaMethod, Object outer, Locale locale, TimeZone timeZone, MediaType mediaType) {
        super((ParserContext)ctx, op, input, javaMethod, outer, locale, timeZone, mediaType);
        ObjectMap jenaSettings = new ObjectMap();
        jenaSettings.putAll(ctx.jenaSettings);
        if (op == null || op.isEmpty()) {
            this.rdfLanguage = ctx.rdfLanguage;
            this.juneauNs = ctx.juneauNs;
            this.juneauBpNs = ctx.juneauBpNs;
            this.trimWhitespace = ctx.trimWhitespace;
            this.collectionFormat = ctx.collectionFormat;
            this.looseCollections = ctx.looseCollections;
        } else {
            this.rdfLanguage = op.getString("Rdf.language", ctx.rdfLanguage);
            this.juneauNs = op.containsKey((Object)"Rdf.juneauNs") ? NamespaceFactory.parseNamespace((Object)op.get((Object)"Rdf.juneauNs")) : ctx.juneauNs;
            this.juneauBpNs = op.containsKey((Object)"Rdf.juneauBpNs") ? NamespaceFactory.parseNamespace((Object)op.get((Object)"Rdf.juneauBpNs")) : ctx.juneauBpNs;
            this.trimWhitespace = op.getBoolean("RdfParser.trimWhitespace", Boolean.valueOf(ctx.trimWhitespace));
            this.collectionFormat = RdfCollectionFormat.valueOf(op.getString("Rdf.collectionFormat", "DEFAULT"));
            this.looseCollections = op.getBoolean("Rdf.looseCollections", Boolean.valueOf(ctx.looseCollections));
        }
        this.model = ModelFactory.createDefaultModel();
        this.addModelPrefix(this.juneauNs);
        this.addModelPrefix(this.juneauBpNs);
        this.pRoot = this.model.createProperty(this.juneauNs.getUri(), "root");
        this.pValue = this.model.createProperty(this.juneauNs.getUri(), "value");
        this.pType = this.model.createProperty(this.juneauBpNs.getUri(), "_type");
        this.pRdfType = this.model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.rdfReader = this.model.getReader(this.rdfLanguage);
        if (!this.rdfLanguage.equals("N-TRIPLE")) {
            for (Map.Entry e : jenaSettings.entrySet()) {
                this.rdfReader.setProperty((String)e.getKey(), e.getValue());
            }
        }
    }

    public final boolean wasAlreadyProcessed(Resource r) {
        return !this.urisVisited.add(r);
    }

    public final Property getRootProperty() {
        return this.pRoot;
    }

    public final Property getValueProperty() {
        return this.pValue;
    }

    public final Property getTypeProperty() {
        return this.pType;
    }

    public final Property getRdfTypeProperty() {
        return this.pRdfType;
    }

    public final Model getModel() {
        return this.model;
    }

    public final RDFReader getRdfReader() {
        return this.rdfReader;
    }

    public final RdfCollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    public final boolean isLooseCollections() {
        return this.looseCollections;
    }

    public final String getJuneauNsUri() {
        return this.juneauNs.getUri();
    }

    public final void addModelPrefix(Namespace ns) {
        this.model.setNsPrefix(ns.getName(), ns.getUri());
    }

    public final Property getProperty(String name) {
        return this.model.createProperty(this.juneauBpNs.getUri(), name);
    }

    public final String decodeString(Object o) {
        if (o == null) {
            return null;
        }
        String s = o.toString();
        if (s.isEmpty()) {
            return s;
        }
        if (this.trimWhitespace) {
            s = s.trim();
        }
        s = XmlUtils.decode((String)s, null);
        if (this.isTrimStrings()) {
            s = s.trim();
        }
        return s;
    }
}

