/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Date;
import java.util.TreeSet;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.juneau.dto.Link;
import org.apache.juneau.ini.ConfigFile;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.microservice.Resource;
import org.apache.juneau.microservice.resources.LogEntryFormatter;
import org.apache.juneau.microservice.resources.LogParser;
import org.apache.juneau.rest.Redirect;
import org.apache.juneau.rest.RestConfig;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.annotation.PathRemainder;
import org.apache.juneau.rest.annotation.Properties;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.Query;
import org.apache.juneau.rest.annotation.Response;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.converters.Queryable;
import org.apache.juneau.transforms.DateSwap;
import org.apache.juneau.transforms.IteratorSwap;
import org.apache.juneau.utils.StringMessage;

@RestResource(path="/logs", title="Log files", description="Log files from this service", properties={@Property(name="HtmlSerializer.uriAnchorText", value="PROPERTY_NAME"), @Property(name="RestServlet.allowMethodParam", value="true")}, pojoSwaps={IteratorSwap.class, DateSwap.ISO8601DT.class})
public class LogsResource
extends Resource {
    private static final long serialVersionUID = 1L;
    private File logDir;
    private LogEntryFormatter leFormatter;
    private final FileFilter filter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".log");
        }
    };

    @Override
    public synchronized void init(RestConfig config) throws Exception {
        super.init(config);
        ConfigFile cf = config.getConfigFile();
        this.logDir = new File(cf.getString("Logging/logDir", "."));
        this.leFormatter = new LogEntryFormatter(cf.getString("Logging/format", "[{date} {level}] {msg}%n"), cf.getString("Logging/dateFormat", "yyyy.MM.dd hh:mm:ss"), cf.getBoolean("Logging/useStackTraceHashes"));
    }

    @RestMethod(name="GET", path="/*", responses={@Response(value=200), @Response(value=404)})
    public Object getFileOrDirectory(RestRequest req, RestResponse res, @Properties ObjectMap properties, @PathRemainder String path) throws Exception {
        File f = this.getFile(path);
        if (f.isDirectory()) {
            TreeSet<FileResource> l = new TreeSet<FileResource>(new FileResourceComparator());
            File[] files = f.listFiles(this.filter);
            if (files != null) {
                for (File fc : files) {
                    URL fUrl = new URL(req.getTrimmedRequestURL().append('/').append(fc.getName()).toString());
                    l.add(new FileResource(fc, fUrl));
                }
            }
            res.setPageText((Object)new StringMessage("Contents of {0}", new Object[]{f.getAbsolutePath()}));
            properties.put((Object)"HtmlSerializer.description", (Object)("Contents of " + f.getAbsolutePath()));
            return l;
        }
        res.setPageText((Object)new StringMessage("File details on {0}", new Object[]{f.getAbsolutePath()}));
        return new FileResource(f, new URL(req.getTrimmedRequestURL().toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestMethod(name="VIEW", path="/*", responses={@Response(value=200), @Response(value=404)})
    public void viewFile(RestRequest req, RestResponse res, @PathRemainder String path, @Properties ObjectMap properties, @Query(value="highlight") boolean highlight, @Query(value="start") String start, @Query(value="end") String end, @Query(value="thread") String thread, @Query(value="loggers") String[] loggers, @Query(value="severity") String[] severity) throws Exception {
        File f = this.getFile(path);
        if (f.isDirectory()) {
            throw new RestException(405, "View not available on directories", new Object[0]);
        }
        Date startDate = StringUtils.parseISO8601Date((String)start);
        Date endDate = StringUtils.parseISO8601Date((String)end);
        if (!highlight) {
            Object o = this.getReader(f, startDate, endDate, thread, loggers, severity);
            res.setContentType("text/plain");
            if (o instanceof Reader) {
                res.setOutput(o);
            } else {
                LogParser p = (LogParser)o;
                PrintWriter w = res.getNegotiatedWriter();
                try {
                    p.writeTo(w);
                }
                finally {
                    ((Writer)w).flush();
                    ((Writer)w).close();
                }
            }
            return;
        }
        res.setContentType("text/html");
        PrintWriter w = res.getNegotiatedWriter();
        try {
            w.println("<html><body style='font-family:monospace;font-size:8pt;white-space:pre;'>");
            LogParser lp = this.getLogParser(f, startDate, endDate, thread, loggers, severity);
            try {
                if (!lp.hasNext()) {
                    w.append("<span style='color:gray'>[EMPTY]</span>");
                } else {
                    for (LogParser.Entry le : lp) {
                        char s = le.severity.charAt(0);
                        String color = "black";
                        if (s == 'I') {
                            color = "#006400";
                        } else if (s == 'W') {
                            color = "#CC8400";
                        } else if (s == 'E' || s == 'S') {
                            color = "#DD0000";
                        } else if (s == 'D' || s == 'F' || s == 'T') {
                            color = "#000064";
                        }
                        w.append("<span style='color:").append(color).append("'>");
                        le.appendHtml(w).append("</span>");
                    }
                }
                w.append("</body></html>");
            }
            finally {
                lp.close();
            }
        }
        finally {
            w.close();
        }
    }

    @RestMethod(name="PARSE", path="/*", converters={Queryable.class}, responses={@Response(value=200), @Response(value=404)})
    public LogParser viewParsedEntries(RestRequest req, @PathRemainder String path, @Query(value="start") String start, @Query(value="end") String end, @Query(value="thread") String thread, @Query(value="loggers") String[] loggers, @Query(value="severity") String[] severity) throws Exception {
        File f = this.getFile(path);
        Date startDate = StringUtils.parseISO8601Date((String)start);
        Date endDate = StringUtils.parseISO8601Date((String)end);
        if (f.isDirectory()) {
            throw new RestException(405, "View not available on directories", new Object[0]);
        }
        return this.getLogParser(f, startDate, endDate, thread, loggers, severity);
    }

    @RestMethod(name="DOWNLOAD", path="/*", responses={@Response(value=200), @Response(value=404)})
    public Object downloadFile(RestResponse res, @PathRemainder String path) throws Exception {
        File f = this.getFile(path);
        if (f.isDirectory()) {
            throw new RestException(405, "Download not available on directories", new Object[0]);
        }
        res.setContentType("application/octet-stream");
        res.setContentLength((int)f.length());
        return new FileInputStream(f);
    }

    @RestMethod(name="DELETE", path="/*", responses={@Response(value=200), @Response(value=404)})
    public Object deleteFile(@PathRemainder String path) throws Exception {
        File f = this.getFile(path);
        if (f.isDirectory()) {
            throw new RestException(400, "Delete not available on directories.", new Object[0]);
        }
        if (f.canWrite() && !f.delete()) {
            throw new RestException(403, "Could not delete file.", new Object[0]);
        }
        return new Redirect((Object)(path + "/.."));
    }

    private static BufferedReader getReader(File f) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), Charset.defaultCharset()));
    }

    private File getFile(String path) {
        File f;
        if (path != null && path.indexOf("..") != -1) {
            throw new RestException(404, "File not found.", new Object[0]);
        }
        File file = f = path == null ? this.logDir : new File(this.logDir.getAbsolutePath() + '/' + path);
        if (this.filter.accept(f)) {
            return f;
        }
        throw new RestException(404, "File not found.", new Object[0]);
    }

    private Object getReader(File f, Date start, Date end, String thread, String[] loggers, String[] severity) throws IOException {
        if (start == null && end == null && thread == null && loggers == null) {
            return LogsResource.getReader(f);
        }
        return this.getLogParser(f, start, end, thread, loggers, severity);
    }

    private LogParser getLogParser(File f, Date start, Date end, String thread, String[] loggers, String[] severity) throws IOException {
        return new LogParser(this.leFormatter, f, start, end, thread, loggers, severity);
    }

    private static class FileResourceComparator
    implements Comparator<FileResource>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private FileResourceComparator() {
        }

        @Override
        public int compare(FileResource o1, FileResource o2) {
            int c = o1.type.compareTo(o2.type);
            return c != 0 ? c : o1.f.getName().compareTo(o2.f.getName());
        }
    }

    public static class FileResource {
        private File f;
        public String type;
        public Object name;
        public Long size;
        @BeanProperty(swap=DateSwap.DateTimeMedium.class)
        public Date lastModified;
        public URL view;
        public URL highlighted;
        public URL parsed;
        public URL download;
        public URL delete;

        public FileResource(File f, URL url) throws IOException {
            this.f = f;
            this.type = f.isDirectory() ? "dir" : "file";
            this.name = f.isDirectory() ? new Link(f.getName(), url.toString(), new Object[0]) : f.getName();
            this.size = f.isDirectory() ? null : Long.valueOf(f.length());
            this.lastModified = new Date(f.lastModified());
            if (f.canRead() && !f.isDirectory()) {
                this.view = new URL(url + "?method=VIEW");
                this.highlighted = new URL(url + "?method=VIEW&highlight=true");
                this.parsed = new URL(url + "?method=PARSE");
                this.download = new URL(url + "?method=DOWNLOAD");
                this.delete = new URL(url + "?method=DELETE");
            }
        }
    }
}

