/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.io.Reader;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.xml.XmlParserContext;
import org.apache.juneau.xml.XmlUtils;

public class XmlParserSession
extends ParserSession {
    private final boolean validating;
    private final boolean preserveRootElement;
    private final XMLReporter reporter;
    private final XMLResolver resolver;
    private final XMLEventAllocator eventAllocator;
    private XMLStreamReader xmlStreamReader;
    private final StringBuilder sb = new StringBuilder();

    public XmlParserSession(XmlParserContext ctx, ObjectMap op, Object input, Method javaMethod, Object outer, Locale locale, TimeZone timeZone, MediaType mediaType) {
        super(ctx, op, input, javaMethod, outer, locale, timeZone, mediaType);
        if (op == null || op.isEmpty()) {
            this.validating = ctx.validating;
            this.reporter = ctx.reporter;
            this.resolver = ctx.resolver;
            this.eventAllocator = ctx.eventAllocator;
            this.preserveRootElement = ctx.preserveRootElement;
        } else {
            this.validating = op.getBoolean("XmlParser.validating", ctx.validating);
            this.reporter = (XMLReporter)op.get("XmlParser.reporter", ctx.reporter);
            this.resolver = (XMLResolver)op.get("XmlParser.resolver", ctx.resolver);
            this.eventAllocator = (XMLEventAllocator)op.get("XmlParser.eventAllocator", ctx.eventAllocator);
            this.preserveRootElement = op.getBoolean("XmlParser.preserveRootElement", ctx.preserveRootElement);
        }
    }

    public final boolean isPreserveRootElement() {
        return this.preserveRootElement;
    }

    public final XMLStreamReader getXmlStreamReader() throws Exception {
        try {
            Reader r = IOUtils.getBufferedReader(this.getReader());
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isValidating", this.validating);
            factory.setProperty("javax.xml.stream.isCoalescing", true);
            factory.setProperty("javax.xml.stream.isReplacingEntityReferences", true);
            if (factory.isPropertySupported("javax.xml.stream.reporter") && this.reporter != null) {
                factory.setProperty("javax.xml.stream.reporter", this.reporter);
            }
            if (factory.isPropertySupported("javax.xml.stream.resolver") && this.resolver != null) {
                factory.setProperty("javax.xml.stream.resolver", this.resolver);
            }
            if (factory.isPropertySupported("javax.xml.stream.allocator") && this.eventAllocator != null) {
                factory.setProperty("javax.xml.stream.allocator", this.eventAllocator);
            }
            this.xmlStreamReader = factory.createXMLStreamReader(r);
            this.xmlStreamReader.nextTag();
        }
        catch (Error e) {
            this.close();
            throw new ParseException(e.getLocalizedMessage(), new Object[0]);
        }
        catch (XMLStreamException e) {
            this.close();
            throw new ParseException(e);
        }
        return this.xmlStreamReader;
    }

    public final String decodeString(String s) {
        if (s == null) {
            return null;
        }
        this.sb.setLength(0);
        s = XmlUtils.decode(s, this.sb);
        if (this.isTrimStrings()) {
            s = s.trim();
        }
        return s;
    }

    public final String getElementName(XMLStreamReader r) throws XMLStreamException {
        return this.decodeString(r.getLocalName());
    }

    public final String getAttributeName(XMLStreamReader r, int i) throws XMLStreamException {
        return this.decodeString(r.getAttributeLocalName(i));
    }

    public final String getAttributeValue(XMLStreamReader r, int i) throws XMLStreamException {
        return this.decodeString(r.getAttributeValue(i));
    }

    public String getElementText(XMLStreamReader r) throws XMLStreamException {
        String s = r.getElementText().trim();
        return this.decodeString(s);
    }

    public String getText(XMLStreamReader r, boolean trim) throws XMLStreamException {
        String s = r.getText();
        if (trim) {
            s = s.trim();
        }
        if (s.isEmpty()) {
            return null;
        }
        return this.decodeString(s);
    }

    public String getText(XMLStreamReader r) throws XMLStreamException {
        return this.getText(r, true);
    }

    public final String getElementAsString(XMLStreamReader r) {
        int t = r.getEventType();
        if (t > 2) {
            throw new RuntimeException("Invalid event type on stream reader for elementToString() method: " + XmlUtils.toReadableEvent(r));
        }
        this.sb.setLength(0);
        this.sb.append("<").append(t == 1 ? "" : "/").append(r.getLocalName());
        if (t == 1) {
            for (int i = 0; i < r.getAttributeCount(); ++i) {
                this.sb.append(' ').append(r.getAttributeName(i)).append('=').append('\'').append(r.getAttributeValue(i)).append('\'');
            }
        }
        this.sb.append('>');
        return this.sb.toString();
    }

    public String parseText(XMLStreamReader r) throws XMLStreamException {
        StringBuilder sb2 = this.getStringBuilder();
        int depth = 0;
        while (true) {
            int et;
            if ((et = r.getEventType()) == 1) {
                sb2.append(this.getElementAsString(r));
                ++depth;
            } else if (et == 4) {
                sb2.append(this.getText(r));
            } else if (et == 2) {
                sb2.append(this.getElementAsString(r));
                if (--depth <= 0) break;
            }
            et = r.next();
        }
        String s = sb2.toString();
        this.returnStringBuilder(sb2);
        return s;
    }

    public boolean isWhitespaceElement(XMLStreamReader r) {
        return false;
    }

    public String parseWhitespaceElement(XMLStreamReader r) throws XMLStreamException {
        return null;
    }

    @Override
    public boolean close() {
        if (super.close()) {
            try {
                if (this.xmlStreamReader != null) {
                    this.xmlStreamReader.close();
                }
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }
}

