/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.SerializerWriter;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.uon.UonUtils;
import org.apache.juneau.uon.UonWriter;
import org.apache.juneau.urlencoding.UrlEncodingSerializerBuilder;
import org.apache.juneau.urlencoding.UrlEncodingSerializerContext;
import org.apache.juneau.urlencoding.UrlEncodingSerializerSession;

@Produces(value="application/x-www-form-urlencoded")
public class UrlEncodingSerializer
extends UonSerializer {
    public static final UrlEncodingSerializer DEFAULT = new UrlEncodingSerializer(PropertyStore.create());
    public static final UrlEncodingSerializer DEFAULT_EXPANDED = new Expanded(PropertyStore.create());
    public static final UrlEncodingSerializer DEFAULT_READABLE = new Readable(PropertyStore.create());
    private final UrlEncodingSerializerContext ctx = this.createContext(UrlEncodingSerializerContext.class);

    public UrlEncodingSerializer(PropertyStore propertyStore) {
        super(propertyStore);
    }

    @Override
    public UrlEncodingSerializerBuilder builder() {
        return new UrlEncodingSerializerBuilder(this.propertyStore);
    }

    @Override
    protected ObjectMap getOverrideProperties() {
        return super.getOverrideProperties().append("UonSerializer.encodeChars", true);
    }

    private SerializerWriter serializeAnything(UrlEncodingSerializerSession session, UonWriter out, Object o) throws Exception {
        ClassMeta<Object> aType = session.push("root", o, this.object());
        --session.indent;
        if (aType == null) {
            aType = this.object();
        }
        ClassMeta<Object> sType = aType.getSerializedClassMeta();
        String typeName = session.getBeanTypeName(session.object(), aType, null);
        PojoSwap<Object, ?> swap = aType.getPojoSwap();
        if (swap != null) {
            o = swap.swap(session, o);
            if (sType.isObject()) {
                sType = session.getClassMetaForObject(o);
            }
        }
        if (sType.isMap()) {
            if (o instanceof BeanMap) {
                this.serializeBeanMap(session, out, (BeanMap)o, typeName);
            } else {
                this.serializeMap(session, out, (Map)o, sType);
            }
        } else if (sType.isBean()) {
            this.serializeBeanMap(session, out, session.toBeanMap(o), typeName);
        } else if (sType.isCollection() || sType.isArray()) {
            Map<Integer, Object> m = sType.isCollection() ? UrlEncodingSerializer.getCollectionMap((Collection)o) : UrlEncodingSerializer.getCollectionMap(o);
            this.serializeCollectionMap(session, out, m, session.getClassMeta((Type)((Object)Map.class), new Type[]{Integer.class, Object.class}));
        } else {
            out.append("_value=");
            super.serializeAnything(session, out, o, null, null, null, session.plainTextParams());
        }
        session.pop();
        return out;
    }

    private static Map<Integer, Object> getCollectionMap(Collection<?> c) {
        TreeMap<Integer, Object> m = new TreeMap<Integer, Object>();
        int i = 0;
        for (Object o : c) {
            m.put(i++, o);
        }
        return m;
    }

    private static Map<Integer, Object> getCollectionMap(Object array) {
        TreeMap<Integer, Object> m = new TreeMap<Integer, Object>();
        for (int i = 0; i < Array.getLength(array); ++i) {
            m.put(i, Array.get(array, i));
        }
        return m;
    }

    private SerializerWriter serializeMap(UrlEncodingSerializerSession session, UonWriter out, Map m, ClassMeta<?> type) throws Exception {
        boolean plainTextParams = session.plainTextParams();
        m = session.sort(m);
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        int depth = session.getIndent();
        boolean addAmp = false;
        for (Map.Entry e : m.entrySet()) {
            Object key = session.generalize(e.getKey(), keyType);
            Object value = e.getValue();
            if (session.shouldUseExpandedParams(value)) {
                Iterator<Object> i;
                Iterator<Object> iterator = i = value instanceof Collection ? ((Collection)value).iterator() : ArrayUtils.iterator(value);
                while (i.hasNext()) {
                    if (addAmp) {
                        out.cr(depth).append('&');
                    }
                    out.appendObject(key, true, plainTextParams).append('=');
                    super.serializeAnything(session, out, i.next(), null, key == null ? null : key.toString(), null, plainTextParams);
                    addAmp = true;
                }
                continue;
            }
            if (addAmp) {
                out.cr(depth).append('&');
            }
            out.appendObject(key, true, plainTextParams).append('=');
            super.serializeAnything(session, out, value, valueType, key == null ? null : key.toString(), null, plainTextParams);
            addAmp = true;
        }
        return out;
    }

    private SerializerWriter serializeCollectionMap(UrlEncodingSerializerSession session, UonWriter out, Map m, ClassMeta<?> type) throws Exception {
        ClassMeta<?> valueType = type.getValueType();
        int depth = session.getIndent();
        boolean addAmp = false;
        for (Map.Entry e : m.entrySet()) {
            if (addAmp) {
                out.cr(depth).append('&');
            }
            out.append(e.getKey()).append('=');
            super.serializeAnything(session, out, e.getValue(), valueType, null, null, session.plainTextParams());
            addAmp = true;
        }
        return out;
    }

    private SerializerWriter serializeBeanMap(UrlEncodingSerializerSession session, UonWriter out, BeanMap<?> m, String typeName) throws Exception {
        int depth = session.getIndent();
        boolean plainTextParams = session.plainTextParams();
        boolean addAmp = false;
        for (BeanPropertyValue p : m.getValues(session.isTrimNulls(), typeName != null ? session.createBeanTypeNameProperty(m, typeName) : null)) {
            BeanPropertyMeta pMeta = p.getMeta();
            ClassMeta<?> cMeta = p.getClassMeta();
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                session.addBeanGetterWarning(pMeta, t);
            }
            if (session.canIgnoreValue(cMeta, key, value)) continue;
            if (value != null && session.shouldUseExpandedParams(pMeta)) {
                Iterator<Object> i;
                Iterator<Object> iterator = i = cMeta.isCollection() || value instanceof Collection ? ((Collection)value).iterator() : ArrayUtils.iterator(value);
                while (i.hasNext()) {
                    if (addAmp) {
                        out.cr(depth).append('&');
                    }
                    out.appendObject(key, true, plainTextParams).append('=');
                    super.serializeAnything(session, out, i.next(), cMeta.getElementType(), key, pMeta, plainTextParams);
                    addAmp = true;
                }
                continue;
            }
            if (addAmp) {
                out.cr(depth).append('&');
            }
            out.appendObject(key, true, plainTextParams).append('=');
            super.serializeAnything(session, out, value, cMeta, key, pMeta, plainTextParams);
            addAmp = true;
        }
        return out;
    }

    public String serializePart(Object o, Boolean urlEncode, Boolean plainTextParams) {
        try {
            ClassMeta<Object> cm = this.getBeanContext().getClassMetaForObject(o);
            if (cm != null) {
                if (cm.isNumber() || cm.isBoolean()) {
                    return o.toString();
                }
                if (cm.isCharSequence()) {
                    boolean ptt;
                    String s = o.toString();
                    boolean bl = ptt = plainTextParams != null ? plainTextParams : this.ctx.plainTextParams;
                    if (ptt || !UonUtils.needsQuotes(s)) {
                        return urlEncode != false ? StringUtils.urlEncode(s) : s;
                    }
                }
            }
            StringWriter w = new StringWriter();
            UrlEncodingSerializerSession s = new UrlEncodingSerializerSession(this.ctx, urlEncode, null, (Object)w, null, null, null, MediaType.UON);
            super.doSerialize(s, o);
            return w.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public UrlEncodingSerializerSession createSession(Object output, ObjectMap op, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType) {
        return new UrlEncodingSerializerSession(this.ctx, null, op, output, javaMethod, locale, timeZone, mediaType);
    }

    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        UrlEncodingSerializerSession s = (UrlEncodingSerializerSession)session;
        this.serializeAnything(s, s.getWriter(), o);
    }

    public static class Readable
    extends UrlEncodingSerializer {
        public Readable(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("Serializer.useWhitespace", true);
        }
    }

    @Produces(value="application/x-www-form-urlencoded", contentType="application/x-www-form-urlencoded")
    public static class Expanded
    extends UrlEncodingSerializer {
        public Expanded(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("UrlEncoding.expandedParams", true);
        }
    }
}

