/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.uon.UonSerializerContext;
import org.apache.juneau.uon.UonWriter;

public class UonSerializerSession
extends SerializerSession {
    private final boolean encodeChars;
    private final boolean addBeanTypeProperties;

    protected UonSerializerSession(UonSerializerContext ctx, Boolean encode, ObjectMap op, Object output, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType) {
        super(ctx, op, output, javaMethod, locale, timeZone, mediaType);
        if (op == null || op.isEmpty()) {
            this.encodeChars = encode == null ? ctx.encodeChars : encode;
            this.addBeanTypeProperties = ctx.addBeanTypeProperties;
        } else {
            this.encodeChars = encode == null ? op.getBoolean("UonSerializer.encodeChars", ctx.encodeChars) : encode;
            this.addBeanTypeProperties = op.getBoolean("MsgPackSerializer.addBeanTypeProperties", ctx.addBeanTypeProperties);
        }
    }

    public final boolean isEncodeChars() {
        return this.encodeChars;
    }

    @Override
    public final boolean isAddBeanTypeProperties() {
        return this.addBeanTypeProperties;
    }

    @Override
    public final UonWriter getWriter() throws Exception {
        Object output = this.getOutput();
        if (output instanceof UonWriter) {
            return (UonWriter)output;
        }
        return new UonWriter(this, super.getWriter(), this.isUseWhitespace(), this.isEncodeChars(), this.isTrimStrings(), this.getRelativeUriBase(), this.getAbsolutePathUriBase());
    }
}

