/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.SerializerWriter;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.uon.UonSerializerBuilder;
import org.apache.juneau.uon.UonSerializerContext;
import org.apache.juneau.uon.UonSerializerSession;
import org.apache.juneau.uon.UonWriter;

@Produces(value="text/uon")
public class UonSerializer
extends WriterSerializer {
    public static final UonSerializer DEFAULT = new UonSerializer(PropertyStore.create());
    public static final UonSerializer DEFAULT_READABLE = new Readable(PropertyStore.create());
    public static final UonSerializer DEFAULT_ENCODING = new Encoding(PropertyStore.create());
    private final UonSerializerContext ctx = this.createContext(UonSerializerContext.class);

    public UonSerializer(PropertyStore propertyStore) {
        super(propertyStore);
    }

    @Override
    public UonSerializerBuilder builder() {
        return new UonSerializerBuilder(this.propertyStore);
    }

    protected SerializerWriter serializeAnything(UonSerializerSession session, UonWriter out, Object o, ClassMeta<?> eType, String attrName, BeanPropertyMeta pMeta, boolean plainTextParams) throws Exception {
        ClassMeta<Object> aType;
        boolean isRecursion;
        if (o == null) {
            out.appendObject(null, false, plainTextParams);
            return out;
        }
        if (eType == null) {
            eType = this.object();
        }
        boolean bl = isRecursion = (aType = session.push(attrName, o, eType)) == null;
        if (aType == null) {
            o = null;
            aType = this.object();
        }
        ClassMeta<Object> sType = aType.getSerializedClassMeta();
        String typeName = session.getBeanTypeName(eType, aType, pMeta);
        PojoSwap<Object, ?> swap = aType.getPojoSwap();
        if (swap != null) {
            o = swap.swap(session, o);
            if (sType.isObject()) {
                sType = session.getClassMetaForObject(o);
            }
        }
        if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
            out.appendObject(null, false, plainTextParams);
        } else if (sType.isBoolean()) {
            out.appendBoolean(o);
        } else if (sType.isNumber()) {
            out.appendNumber(o);
        } else if (sType.isBean()) {
            this.serializeBeanMap(session, out, session.toBeanMap(o), typeName);
        } else if (sType.isUri() || pMeta != null && pMeta.isUri()) {
            out.appendUri(o);
        } else if (sType.isMap()) {
            if (o instanceof BeanMap) {
                this.serializeBeanMap(session, out, (BeanMap)o, typeName);
            } else {
                this.serializeMap(session, out, (Map)o, eType);
            }
        } else if (sType.isCollection()) {
            this.serializeCollection(session, out, (Collection)o, eType);
        } else if (sType.isArray()) {
            this.serializeCollection(session, out, UonSerializer.toList(sType.getInnerClass(), o), eType);
        } else {
            out.appendObject(o, false, plainTextParams);
        }
        if (!isRecursion) {
            session.pop();
        }
        return out;
    }

    private SerializerWriter serializeMap(UonSerializerSession session, UonWriter out, Map m, ClassMeta<?> type) throws Exception {
        m = session.sort(m);
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        int depth = session.getIndent();
        out.append('(');
        Iterator mapEntries = m.entrySet().iterator();
        while (mapEntries.hasNext()) {
            Map.Entry e = mapEntries.next();
            Object value = e.getValue();
            Object key = session.generalize(e.getKey(), keyType);
            out.cr(depth).appendObject(key, false, false).append('=');
            this.serializeAnything(session, out, value, valueType, key == null ? null : session.toString(key), null, false);
            if (!mapEntries.hasNext()) continue;
            out.append(',');
        }
        if (m.size() > 0) {
            out.cr(depth - 1);
        }
        out.append(')');
        return out;
    }

    private SerializerWriter serializeBeanMap(UonSerializerSession session, UonWriter out, BeanMap<?> m, String typeName) throws Exception {
        int depth = session.getIndent();
        out.append('(');
        boolean addComma = false;
        for (BeanPropertyValue p : m.getValues(session.isTrimNulls(), typeName != null ? session.createBeanTypeNameProperty(m, typeName) : null)) {
            BeanPropertyMeta pMeta = p.getMeta();
            ClassMeta<?> cMeta = p.getClassMeta();
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                session.addBeanGetterWarning(pMeta, t);
            }
            if (session.canIgnoreValue(cMeta, key, value)) continue;
            if (addComma) {
                out.append(',');
            }
            out.cr(depth).appendObject(key, false, false).append('=');
            this.serializeAnything(session, out, value, cMeta, key, pMeta, false);
            addComma = true;
        }
        if (m.size() > 0) {
            out.cr(depth - 1);
        }
        out.append(')');
        return out;
    }

    private SerializerWriter serializeCollection(UonSerializerSession session, UonWriter out, Collection c, ClassMeta<?> type) throws Exception {
        ClassMeta<?> elementType = type.getElementType();
        c = session.sort(c);
        out.append('@').append('(');
        int depth = session.getIndent();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            out.cr(depth);
            this.serializeAnything(session, out, i.next(), elementType, "<iterator>", null, false);
            if (!i.hasNext()) continue;
            out.append(',');
        }
        if (c.size() > 0) {
            out.cr(depth - 1);
        }
        out.append(')');
        return out;
    }

    @Override
    public UonSerializerSession createSession(Object output, ObjectMap op, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType) {
        return new UonSerializerSession(this.ctx, null, op, output, javaMethod, locale, timeZone, mediaType);
    }

    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        UonSerializerSession s = (UonSerializerSession)session;
        this.serializeAnything(s, s.getWriter(), o, s.getExpectedRootType(o), "root", null, false);
    }

    public static class Encoding
    extends UonSerializer {
        public Encoding(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("UonSerializer.encodeChars", true);
        }
    }

    public static class Readable
    extends UonSerializer {
        public Readable(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("Serializer.useWhitespace", true);
        }
    }
}

