/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.transform.StringSwap;

public class CalendarSwap
extends StringSwap<Calendar> {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private final int dateStyle;
    private final int timeStyle;
    private final String pattern;
    private final TimeZone timeZone;

    protected CalendarSwap(String pattern, int dateStyle, int timeStyle, TimeZone timeZone) {
        this.pattern = pattern;
        this.dateStyle = dateStyle;
        this.timeStyle = timeStyle;
        this.timeZone = timeZone;
    }

    protected DateFormat getDateFormat(BeanSession session, Calendar c) {
        DateFormat df = session.getFromCache(DateFormat.class, this.getClass().getName());
        if (df == null) {
            df = this.pattern != null ? new SimpleDateFormat(this.pattern, session.getLocale()) : (this.dateStyle == -1 && this.timeStyle != -1 ? DateFormat.getTimeInstance(this.timeStyle, session.getLocale()) : (this.dateStyle != -1 && this.timeStyle == -1 ? DateFormat.getDateInstance(this.dateStyle, session.getLocale()) : DateFormat.getDateTimeInstance(this.dateStyle, this.timeStyle, session.getLocale())));
            if (this.timeZone != null) {
                df.setTimeZone(this.timeZone);
            } else if (session.getTimeZone() != null) {
                df.setTimeZone(session.getTimeZone());
            } else if (c != null && !c.getTimeZone().equals(df.getTimeZone())) {
                df.setTimeZone(c.getTimeZone());
                return df;
            }
            session.addToCache(this.getClass().getName(), df);
        }
        return df;
    }

    @Override
    public String swap(BeanSession session, Calendar o) {
        return this.getDateFormat(session, o).format(o.getTime());
    }

    @Override
    public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws ParseException {
        try {
            if (StringUtils.isEmpty(o)) {
                return null;
            }
            return CalendarSwap.convert(this.getDateFormat(session, null).parse(o), hint, session);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    private static Calendar convert(Calendar in, ClassMeta<?> hint) throws Exception {
        if (hint.isInstance(in) || !hint.canCreateNewInstance()) {
            return in;
        }
        Calendar c = (Calendar)hint.newInstance();
        c.setTime(in.getTime());
        c.setTimeZone(in.getTimeZone());
        return c;
    }

    private static Calendar convert(Date in, ClassMeta<?> hint, BeanSession session) throws Exception {
        if (hint == null || !hint.canCreateNewInstance()) {
            hint = session.getClassMeta(GregorianCalendar.class);
        }
        Calendar c = (Calendar)hint.newInstance();
        c.setTime(in);
        return c;
    }

    private static Calendar setTimeZone(BeanSession session, Calendar c) {
        TimeZone tz = session.getTimeZone();
        if (tz != null && !tz.equals(c.getTimeZone())) {
            c = (Calendar)c.clone();
            c.setTimeZone(tz);
        }
        return c;
    }

    public static class DateTimeShort
    extends CalendarSwap {
        public DateTimeShort() {
            super(null, 3, 3, null);
        }
    }

    public static class DateTimeMedium
    extends CalendarSwap {
        public DateTimeMedium() {
            super(null, 2, 2, null);
        }
    }

    public static class DateTimeLong
    extends CalendarSwap {
        public DateTimeLong() {
            super(null, 1, 1, null);
        }
    }

    public static class DateTimeFull
    extends CalendarSwap {
        public DateTimeFull() {
            super(null, 0, 0, null);
        }
    }

    public static class TimeShort
    extends CalendarSwap {
        public TimeShort() {
            super(null, -1, 3, null);
        }
    }

    public static class TimeMedium
    extends CalendarSwap {
        public TimeMedium() {
            super(null, -1, 2, null);
        }
    }

    public static class TimeLong
    extends CalendarSwap {
        public TimeLong() {
            super(null, -1, 1, null);
        }
    }

    public static class TimeFull
    extends CalendarSwap {
        public TimeFull() {
            super(null, -1, 0, null);
        }
    }

    public static class DateShort
    extends CalendarSwap {
        public DateShort() {
            super(null, 3, -1, null);
        }
    }

    public static class DateMedium
    extends CalendarSwap {
        public DateMedium() {
            super(null, 2, -1, null);
        }
    }

    public static class DateLong
    extends CalendarSwap {
        public DateLong() {
            super(null, 1, -1, null);
        }
    }

    public static class DateFull
    extends CalendarSwap {
        public DateFull() {
            super(null, 0, -1, null);
        }
    }

    public static class TimeSimple
    extends CalendarSwap {
        public TimeSimple() {
            super("HH:mm:ss", -1, -1, null);
        }
    }

    public static class DateSimple
    extends CalendarSwap {
        public DateSimple() {
            super("yyyy/MM/dd", -1, -1, null);
        }
    }

    public static class DateTimeSimple
    extends CalendarSwap {
        public DateTimeSimple() {
            super("yyyy/MM/dd HH:mm:ss", -1, -1, null);
        }
    }

    public static class RFC2822D
    extends CalendarSwap {
        public RFC2822D() {
            super("dd MMM yyyy", -1, -1, null);
        }
    }

    public static class RFC2822DTZ
    extends CalendarSwap {
        public RFC2822DTZ() {
            super("EEE, dd MMM yyyy HH:mm:ss 'GMT'", -1, -1, GMT);
        }
    }

    public static class RFC2822DT
    extends CalendarSwap {
        public RFC2822DT() {
            super("EEE, dd MMM yyyy HH:mm:ss Z", -1, -1, null);
        }
    }

    public static class ISO8601DTPZ
    extends ISO8601DTZ {
        @Override
        public String swap(BeanSession session, Calendar o) {
            String s = super.swap(session, o);
            return String.format("%s.%03d%s", s.substring(0, 19), o.get(14), s.substring(19));
        }
    }

    public static class ISO8601DTP
    extends ISO8601DT {
        @Override
        public String swap(BeanSession session, Calendar o) {
            String s = super.swap(session, o);
            return String.format("%s.%03d%s", s.substring(0, 19), o.get(14), s.substring(19));
        }
    }

    public static class ISO8601DTZ
    extends CalendarSwap {
        public ISO8601DTZ() {
            super(null, -1, -1, null);
        }

        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws ParseException {
            try {
                if (StringUtils.isEmpty(o)) {
                    return null;
                }
                return CalendarSwap.convert(DatatypeConverter.parseDateTime((String)o), hint);
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }

        @Override
        public String swap(BeanSession session, Calendar o) {
            if (o.getTimeZone().getRawOffset() != 0) {
                Calendar c = Calendar.getInstance(GMT);
                c.setTime(o.getTime());
                o = c;
            }
            return DatatypeConverter.printDateTime((Calendar)o);
        }
    }

    public static class ISO8601DT
    extends CalendarSwap {
        public ISO8601DT() {
            super(null, -1, -1, null);
        }

        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws ParseException {
            try {
                if (StringUtils.isEmpty(o)) {
                    return null;
                }
                return CalendarSwap.convert(DatatypeConverter.parseDateTime((String)o), hint);
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }

        @Override
        public String swap(BeanSession session, Calendar o) {
            o = CalendarSwap.setTimeZone(session, o);
            return DatatypeConverter.printDateTime((Calendar)o);
        }
    }

    public static class ToString
    extends CalendarSwap {
        public ToString() {
            super("EEE MMM dd HH:mm:ss zzz yyyy", -1, -1, null);
        }
    }
}

