/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.converters;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.rest.RestConverter;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.utils.PojoQuery;

public final class Queryable
implements RestConverter {
    public Object convert(RestRequest req, Object o, ClassMeta cm) {
        if (o == null) {
            return null;
        }
        try {
            if (req.hasAnyQueryParameters("q", "v", "s", "g", "i", "p", "l")) {
                BeanSession session = req.getBeanSession();
                if (cm.getPojoSwap() != null) {
                    o = cm.getPojoSwap().swap(session, o);
                }
                PojoQuery f = new PojoQuery(o, session);
                if (o instanceof Collection || o.getClass().isArray()) {
                    ObjectMap query = req.getQueryParameter("q", ObjectMap.class);
                    List view = (List)req.getQueryParameter("v", (Type)((Object)List.class), new Type[]{String.class});
                    List sort = (List)req.getQueryParameter("s", (Type)((Object)List.class), new Type[]{String.class});
                    boolean ignoreCase = req.getQueryParameter("i", Boolean.valueOf(false), Boolean.class);
                    int pos = req.getQueryParameter("p", Integer.valueOf(0), Integer.class);
                    int limit = req.getQueryParameter("l", Integer.valueOf(0), Integer.class);
                    o = f.filterCollection(query, view, sort, pos, limit, ignoreCase);
                } else {
                    List view = (List)req.getQueryParameter("v", (Type)((Object)List.class), new Type[]{String.class});
                    o = f.filterMap(view);
                }
            }
            return o;
        }
        catch (SerializeException e) {
            throw new RestException(400, (Throwable)e);
        }
        catch (ParseException e) {
            throw new RestException(400, (Throwable)e);
        }
    }
}

