/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import org.apache.juneau.internal.StringUtils;

public class SSLOpts {
    private String protocols = this.getDefaultProtocols();
    private CertValidate certValidate = CertValidate.DEFAULT;
    private HostVerify hostVerify = HostVerify.DEFAULT;
    public static final SSLOpts LAX = new SSLOpts(null, CertValidate.LAX, HostVerify.LAX);
    public static final SSLOpts DEFAULT = new SSLOpts(null, CertValidate.DEFAULT, HostVerify.DEFAULT);

    public SSLOpts() {
    }

    public SSLOpts(String protocols, CertValidate certValidate, HostVerify hostVerify) {
        if (protocols != null) {
            this.protocols = protocols;
        }
        this.certValidate = certValidate;
        this.hostVerify = hostVerify;
    }

    protected String getDefaultProtocols() {
        String sp = System.getProperty("transport.client.protocol");
        if (StringUtils.isEmpty(sp)) {
            sp = "SSL_TLS,TLS,SSL";
        }
        return sp;
    }

    public String getProtocols() {
        return this.protocols;
    }

    public SSLOpts setProtocols(String protocols) {
        this.protocols = protocols;
        return this;
    }

    public CertValidate getCertValidate() {
        return this.certValidate;
    }

    public SSLOpts setCertValidate(CertValidate certValidate) {
        this.certValidate = certValidate;
        return this;
    }

    public HostVerify getHostVerify() {
        return this.hostVerify;
    }

    public SSLOpts setHostVerify(HostVerify hostVerify) {
        this.hostVerify = hostVerify;
        return this;
    }

    public static enum HostVerify {
        LAX,
        DEFAULT;

    }

    public static enum CertValidate {
        LAX,
        DEFAULT;

    }
}

