/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaRange;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderGroup;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.ini.ConfigFile;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.CharSequenceReader;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.InputStreamParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.parser.ParserMatch;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.rest.ReaderResource;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestUtils;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.utils.MessageBundle;

public final class RestRequest
extends HttpServletRequestWrapper {
    private final RestContext context;
    private final String method;
    private String pathRemainder;
    private byte[] body;
    private Method javaMethod;
    private ObjectMap properties;
    private SerializerGroup serializerGroup;
    private ParserGroup parserGroup;
    private EncoderGroup encoders;
    private Encoder encoder;
    private int contentLength;
    private final boolean debug;
    private UrlEncodingParser urlEncodingParser;
    private BeanSession beanSession;
    private VarResolverSession varSession;
    private final Map<String, String[]> queryParams;
    private Map<String, String> formData;
    private final Map<String, String> defaultServletHeaders;
    private Map<String, String> defaultMethodHeaders;
    private Map<String, String> overriddenHeaders;
    private Map<String, String> overriddenQueryParams;
    private Map<String, String> overriddenFormDataParams;
    private Map<String, String> pathParameters;
    private boolean isPost;
    private String servletURI;
    private String relativeServletURI;
    private String charset;
    private String defaultCharset;
    private ObjectMap headers;
    private ConfigFile cf;
    private Swagger swagger;
    private Swagger fileSwagger;
    private String pageTitle;
    private String pageText;
    private String pageLinks;

    RestRequest(RestContext context, HttpServletRequest req) throws ServletException {
        super(req);
        this.context = context;
        try {
            String b;
            this.isPost = req.getMethod().equalsIgnoreCase("POST");
            this.queryParams = this.isPost ? context.getUrlEncodingParser().parseIntoSimpleMap(this.getQueryString()) : req.getParameterMap();
            String _method = super.getMethod();
            String m = this.getQueryParameter("method");
            if (context.allowMethodParam(m)) {
                _method = m;
            }
            this.method = _method;
            if (context.isAllowBodyParam() && (b = this.getQueryParameter("body")) != null) {
                this.setHeader("Content-Type", UonSerializer.DEFAULT.getResponseContentType());
                this.body = b.getBytes(IOUtils.UTF8);
            }
            this.defaultServletHeaders = context.getDefaultRequestHeaders();
            this.debug = "true".equals(this.getQueryParameter("debug", "false")) || "true".equals(this.getHeader("Debug", "false"));
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    final void init(Method javaMethod, String pathRemainder, ObjectMap properties, Map<String, String> mDefaultRequestHeaders, String defaultCharset, SerializerGroup mSerializers, ParserGroup mParsers, UrlEncodingParser mUrlEncodingParser, EncoderGroup encoders, String pageTitle, String pageText, String pageLinks) {
        this.javaMethod = javaMethod;
        this.pathRemainder = pathRemainder;
        this.properties = properties;
        this.defaultMethodHeaders = mDefaultRequestHeaders;
        this.serializerGroup = mSerializers;
        this.parserGroup = mParsers;
        this.urlEncodingParser = mUrlEncodingParser;
        this.beanSession = this.urlEncodingParser.getBeanContext().createSession();
        this.defaultCharset = defaultCharset;
        this.encoders = encoders;
        this.pageTitle = pageTitle;
        this.pageText = pageText;
        this.pageLinks = pageLinks;
        if (this.debug) {
            String msg = "\n=== HTTP Request (incoming) ====================================================" + this.toString() + "\n=== END ========================================================================";
            this.context.getLogger().log(Level.WARNING, msg, new Object[0]);
        }
    }

    public String getDescription() {
        String qs = this.getQueryString();
        return "HTTP " + this.getMethod() + " " + this.getRequestURI() + (qs == null ? "" : "?" + qs);
    }

    RestRequest setProperties(ObjectMap properties) {
        this.properties = properties;
        return this;
    }

    public ObjectMap getProperties() {
        return this.properties;
    }

    public void setHeader(String name, Object value) {
        if (this.overriddenHeaders == null) {
            this.overriddenHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.overriddenHeaders.put(name, StringUtils.toString(value));
    }

    public String getHeader(String name) {
        return this.getHeader(name, (String)null);
    }

    public String getHeader(String name, String def) {
        String h = this.getOverriddenHeader(name);
        if (h != null) {
            return h;
        }
        h = super.getHeader(name);
        if (h != null && !h.isEmpty()) {
            return h;
        }
        if (this.defaultMethodHeaders != null && (h = this.defaultMethodHeaders.get(name)) != null) {
            return h;
        }
        h = this.defaultServletHeaders.get(name);
        if (h != null) {
            return h;
        }
        return def;
    }

    public <T> T getHeader(String name, Class<T> type) {
        String h = this.getHeader(name);
        return this.beanSession.convertToType((Object)h, type);
    }

    public <T> T getHeader(String name, T def, Class<T> type) {
        String h = this.getHeader(name);
        if (h == null) {
            return def;
        }
        return this.beanSession.convertToType((Object)h, type);
    }

    public <T> T getHeader(String name, Type type, Type ... args) throws ParseException {
        String h = this.getHeader(name);
        return this.urlEncodingParser.parsePart(h, type, args);
    }

    public ObjectMap getHeaders() {
        if (this.headers == null) {
            this.headers = new ObjectMap();
            Enumeration e = this.getHeaderNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.headers.put(key, this.getHeader(key));
            }
        }
        return this.headers;
    }

    public Enumeration<String> getHeaders(String name) {
        String h = this.getOverriddenHeader(name);
        if (h != null) {
            return Collections.enumeration(Collections.singleton(h));
        }
        return super.getHeaders(name);
    }

    public MediaType getMediaType() {
        String cm = this.getHeader("Content-Type");
        if (cm == null) {
            if (this.body != null) {
                return MediaType.UON;
            }
            return MediaType.JSON;
        }
        return MediaType.forString(cm);
    }

    public TimeZone getTimeZone() {
        String tz = this.getHeader("Time-Zone");
        if (tz != null) {
            return TimeZone.getTimeZone(tz);
        }
        return null;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.parserGroup.getSupportedMediaTypes();
    }

    public void setCharacterEncoding(String charset) {
        this.charset = charset;
    }

    public String getCharacterEncoding() {
        if (this.charset == null) {
            int i;
            String h = this.getHeader("Content-Type");
            if (h != null && (i = h.indexOf(";charset=")) > 0) {
                this.charset = h.substring(i + 9).trim();
            }
            if (this.charset == null) {
                this.charset = this.defaultCharset;
            }
            if (!Charset.isSupported(this.charset)) {
                throw new RestException(415, "Unsupported charset in header ''Content-Type'': ''{0}''", h);
            }
        }
        return this.charset;
    }

    public Locale getLocale() {
        MediaRange[] mr;
        String h = this.getOverriddenHeader("Accept-Language");
        if (h != null && (mr = MediaRange.parse(h)).length > 0) {
            return RestRequest.toLocale(mr[0].getMediaType().getType());
        }
        return super.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        MediaRange[] mr;
        String h = this.getOverriddenHeader("Accept-Language");
        if (h != null && (mr = MediaRange.parse(h)).length > 0) {
            ArrayList<Locale> l = new ArrayList<Locale>(mr.length);
            for (MediaRange r : mr) {
                l.add(RestRequest.toLocale(r.getMediaType().getType()));
            }
            return Collections.enumeration(l);
        }
        return super.getLocales();
    }

    public void setQueryParameter(String name, Object value) {
        if (this.overriddenQueryParams == null) {
            this.overriddenQueryParams = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.overriddenQueryParams.put(name, value == null ? null : value.toString());
    }

    public String getQueryParameter(String name) {
        String s = null;
        if (this.overriddenQueryParams != null) {
            s = this.overriddenQueryParams.get(name);
        }
        if (s != null) {
            return s;
        }
        String[] v = this.queryParams.get(name);
        if (v == null || v.length == 0) {
            return null;
        }
        if (v.length == 1 && v[0] != null && v[0].isEmpty() && this.queryParams.containsKey(name)) {
            return null;
        }
        return v[0];
    }

    public String getQueryParameter(String name, String def) {
        String s = this.getQueryParameter(name);
        return s == null ? def : s;
    }

    public <T> T getQueryParameter(String name, Class<T> type) throws ParseException {
        return this.getQueryParameter(name, this.beanSession.getClassMeta(type));
    }

    public <T> T getQueryParameter(String name, T def, Class<T> type) throws ParseException {
        return this.getQueryParameter(name, def, this.beanSession.getClassMeta(type));
    }

    public <T> T getQueryParameter(String name, Type type, Type ... args) throws ParseException {
        return this.getQueryParameter(name, this.beanSession.getClassMeta(type, args));
    }

    public <T> T getQueryParameter(String name, Object def, Type type, Type ... args) throws ParseException {
        return (T)this.getQueryParameter(name, def, this.getBeanSession().getClassMeta(type, args));
    }

    public <T> T getQueryParameters(String name, Class<T> c) throws ParseException {
        return this.getQueryParameters(name, this.beanSession.getClassMeta(c));
    }

    public <T> T getQueryParameters(String name, Type type, Type ... args) throws ParseException {
        return this.getQueryParameters(name, this.getBeanSession().getClassMeta(type, args));
    }

    public String[] getQueryParameters(String name) {
        return this.queryParams.get(name);
    }

    public boolean hasQueryParameter(String name) {
        return this.queryParams.containsKey(name);
    }

    public boolean hasAnyQueryParameters(String ... params) {
        for (String p : params) {
            if (!this.hasQueryParameter(p)) continue;
            return true;
        }
        return false;
    }

    public Map<String, String[]> getQueryParameterMap() {
        return this.queryParams;
    }

    public Iterator<String> getQueryParameterNames() {
        return this.queryParams.keySet().iterator();
    }

    <T> T getQueryParameter(String name, T def, ClassMeta<T> cm) throws ParseException {
        String val = this.getQueryParameter(name);
        if (val == null) {
            return def;
        }
        return this.parseParameter(val, cm);
    }

    <T> T getQueryParameter(String name, ClassMeta<T> cm) throws ParseException {
        String val = this.getQueryParameter(name);
        if (cm.isPrimitive() && (val == null || val.isEmpty())) {
            return cm.getPrimitiveDefault();
        }
        return this.parseParameter(val, cm);
    }

    <T> T getQueryParameters(String name, ClassMeta<T> cm) throws ParseException {
        String[] p = this.getQueryParameters(name);
        if (p == null) {
            return null;
        }
        if (cm.isArray()) {
            ArrayList c = new ArrayList();
            for (int i = 0; i < p.length; ++i) {
                c.add(this.parseParameter(p[i], cm.getElementType()));
            }
            return (T)ArrayUtils.toArray(c, cm.getElementType().getInnerClass());
        }
        if (cm.isCollection()) {
            try {
                Collection c = (Collection)(cm.canCreateNewInstance() ? cm.newInstance() : new ObjectList());
                for (int i = 0; i < p.length; ++i) {
                    c.add(this.parseParameter(p[i], cm.getElementType()));
                }
                return (T)c;
            }
            catch (ParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
        throw new ParseException("Invalid call to getQueryParameters(String, ClassMeta).  Class type must be a Collection or array.", new Object[0]);
    }

    public void setFormDataParameter(String name, Object value) {
        if (this.overriddenFormDataParams == null) {
            this.overriddenFormDataParams = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.overriddenFormDataParams.put(name, value == null ? null : value.toString());
    }

    public String getFormDataParameter(String name) {
        String s = null;
        if (this.overriddenFormDataParams != null) {
            s = this.overriddenFormDataParams.get(name);
        }
        if (s != null) {
            return s;
        }
        return this.getFormParameterInner(name);
    }

    public String getFormDataParameter(String name, String def) {
        String val = this.getFormParameterInner(name);
        if (val == null || val.isEmpty()) {
            return def;
        }
        return val;
    }

    public <T> T getFormDataParameter(String name, Class<T> type) throws ParseException {
        return this.getFormDataParameter(name, this.beanSession.getClassMeta(type));
    }

    public <T> T getFormDataParameter(String name, T def, Class<T> type) throws ParseException {
        return this.getFormDataParameter(name, def, this.beanSession.getClassMeta(type));
    }

    public <T> T getFormDataParameters(String name, Class<T> type) throws ParseException {
        return this.getFormDataParameters(name, this.beanSession.getClassMeta(type));
    }

    public <T> T getFormDataParameter(String name, Type type, Type ... args) throws ParseException {
        return this.getFormDataParameter(name, this.beanSession.getClassMeta(type, args));
    }

    public <T> T getFormDataParameters(String name, Type type, Type ... args) throws ParseException {
        return this.getFormDataParameters(name, this.beanSession.getClassMeta(type, args));
    }

    public boolean hasFormDataParameter(String name) {
        return this.getParameterMap().containsKey(name);
    }

    private Map<String, String> getFormData() {
        try {
            if (this.formData == null) {
                this.formData = (Map)this.urlEncodingParser.parse(this.body, (Type)((Object)Map.class), new Type[]{String.class, String.class});
            }
            return this.formData;
        }
        catch (ParseException e) {
            throw new RestException(500, (Throwable)e);
        }
    }

    <T> T getFormDataParameter(String name, T def, ClassMeta<T> cm) throws ParseException {
        String val = this.getFormParameterInner(name);
        if (val == null) {
            return def;
        }
        return this.parseParameter(val, cm);
    }

    <T> T getFormDataParameter(String name, ClassMeta<T> cm) throws ParseException {
        String val = this.getFormParameterInner(name);
        if (cm.isPrimitive() && (val == null || val.isEmpty())) {
            return cm.getPrimitiveDefault();
        }
        return this.parseParameter(val, cm);
    }

    private String getFormParameterInner(String name) {
        return this.body == null ? super.getParameter(name) : this.getFormData().get(name);
    }

    <T> T getFormDataParameters(String name, ClassMeta<T> cm) throws ParseException {
        String[] p = this.getParameterValues(name);
        if (p == null) {
            return null;
        }
        if (cm.isArray()) {
            ArrayList c = new ArrayList();
            for (int i = 0; i < p.length; ++i) {
                c.add(this.parseParameter(p[i], cm.getElementType()));
            }
            return (T)ArrayUtils.toArray(c, cm.getElementType().getInnerClass());
        }
        if (cm.isCollection()) {
            try {
                Collection c = (Collection)(cm.canCreateNewInstance() ? cm.newInstance() : new ObjectList());
                for (int i = 0; i < p.length; ++i) {
                    c.add(this.parseParameter(p[i], cm.getElementType()));
                }
                return (T)c;
            }
            catch (ParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
        throw new ParseException("Invalid call to getParameters(String, ClassMeta).  Class type must be a Collection or array.", new Object[0]);
    }

    public void setPathParameter(String name, String value) {
        if (this.pathParameters == null) {
            this.pathParameters = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.pathParameters.put(name, value == null ? null : value.toString());
    }

    public String getPathParameter(String name) {
        return this.pathParameters == null ? null : this.pathParameters.get(name);
    }

    public <T> T getPathParameter(String name, Class<T> type) throws ParseException {
        return this.getPathParameter(name, this.beanSession.getClassMeta(type));
    }

    public <T> T getPathParameter(String name, Type type, Type ... args) throws ParseException {
        return this.getPathParameter(name, this.beanSession.getClassMeta(type, args));
    }

    <T> T getPathParameter(String name, ClassMeta<T> cm) throws ParseException {
        String attr = this.getPathParameter(name);
        T t = null;
        if (attr != null) {
            t = this.urlEncodingParser.parsePart(attr.toString(), cm);
        }
        if (t == null && cm.isPrimitive()) {
            return cm.getPrimitiveDefault();
        }
        return t;
    }

    public <T> T getBody(Class<T> type) throws IOException, ParseException {
        return this.getBody(this.beanSession.getClassMeta(type));
    }

    public <T> T getBody(Type type, Type ... args) {
        return this.getBody(this.beanSession.getClassMeta(type, args));
    }

    public String getBodyAsString() throws IOException {
        if (this.body == null) {
            this.body = IOUtils.readBytes((InputStream)this.getInputStream(), 1024);
        }
        return new String(this.body, IOUtils.UTF8);
    }

    public BufferedReader getReader() throws IOException {
        Reader r = this.getUnbufferedReader();
        if (r instanceof BufferedReader) {
            return (BufferedReader)r;
        }
        int len = this.getContentLength();
        int buffSize = len <= 0 ? 8192 : Math.max(len, 8192);
        return new BufferedReader(r, buffSize);
    }

    protected Reader getUnbufferedReader() throws IOException {
        if (this.body != null) {
            return new CharSequenceReader(new String(this.body, IOUtils.UTF8));
        }
        return new InputStreamReader((InputStream)this.getInputStream(), this.getCharacterEncoding());
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.body != null) {
            return new ServletInputStream2(this.body);
        }
        Encoder enc = this.getEncoder();
        ServletInputStream is = super.getInputStream();
        if (enc != null) {
            InputStream is2 = enc.getInputStream((InputStream)is);
            return new ServletInputStream2(is2);
        }
        return is;
    }

    <T> T getBody(ClassMeta<T> cm) throws RestException {
        try {
            if (cm.isReader()) {
                return (T)this.getReader();
            }
            if (cm.isInputStream()) {
                return (T)this.getInputStream();
            }
            TimeZone timeZone = this.getTimeZone();
            Locale locale = this.getLocale();
            ParserMatch pm = this.getParserMatch();
            if (pm != null) {
                Parser p = pm.getParser();
                MediaType mediaType = pm.getMediaType();
                try {
                    this.properties.append("mediaType", mediaType).append("characterEncoding", this.getCharacterEncoding());
                    if (!p.isReaderParser()) {
                        InputStreamParser p2 = (InputStreamParser)p;
                        ParserSession session = p2.createSession(this.getInputStream(), this.properties, this.getJavaMethod(), this.context.getResource(), locale, timeZone, mediaType);
                        return p2.parseSession(session, cm);
                    }
                    ReaderParser p2 = (ReaderParser)p;
                    ParserSession session = p2.createSession(this.getUnbufferedReader(), this.properties, this.getJavaMethod(), this.context.getResource(), locale, timeZone, mediaType);
                    return p2.parseSession(session, cm);
                }
                catch (ParseException e) {
                    throw new RestException(400, "Could not convert request body content to class type ''{0}'' using parser ''{1}''.", cm, p.getClass().getName()).initCause(e);
                }
            }
            throw new RestException(415, "Unsupported media-type in request header ''Content-Type'': ''{0}''\n\tSupported media-types: {1}", this.getHeader("Content-Type"), this.parserGroup.getSupportedMediaTypes());
        }
        catch (IOException e) {
            throw new RestException(500, "I/O exception occurred while attempting to handle request ''{0}''.", this.getDescription()).initCause(e);
        }
    }

    public String getPathInfoUndecoded() {
        return RestUtils.getPathInfoUndecoded((HttpServletRequest)this);
    }

    public String[] getPathInfoParts() {
        String s = this.getPathInfoUndecoded();
        if (s == null || s.isEmpty() || s.equals("/")) {
            return new String[0];
        }
        if ((s = s.substring(1)).endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        boolean needsDecode = s.indexOf(37) != -1 || s.indexOf(43) != -1;
        String[] l = s.split("/", Integer.MAX_VALUE);
        try {
            if (needsDecode) {
                for (int i = 0; i < l.length; ++i) {
                    l[i] = URLDecoder.decode(l[i], "UTF-8");
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return l;
    }

    public URL getURL(String path) throws MalformedURLException {
        if (path.startsWith("http://") || path.startsWith("https://")) {
            return new URL(path);
        }
        if (StringUtils.startsWith(path, '/')) {
            return new URL(this.getScheme(), this.getLocalName(), this.getLocalPort(), path);
        }
        return new URL(this.getScheme(), this.getLocalName(), this.getLocalPort(), this.getContextPath() + this.getServletPath() + (StringUtils.isEmpty(path) ? "" : '/' + path));
    }

    public String getServletParentURI() {
        String s = this.getServletURI();
        return s.substring(0, s.lastIndexOf(47));
    }

    public String getPathRemainder() {
        return StringUtils.urlDecode(this.pathRemainder);
    }

    public String getPathRemainderUndecoded() {
        return this.pathRemainder;
    }

    public String getRequestParentURI() {
        String uri = this.getRequestURI();
        while (StringUtils.endsWith(uri, '/')) {
            uri = uri.substring(0, uri.length() - 1);
        }
        int i = uri.lastIndexOf(47);
        if (i <= 0) {
            return "/";
        }
        return uri.substring(0, i);
    }

    public String getTrimmedRequestURI() {
        return StringUtils.trimTrailingSlashes(this.getRequestURI());
    }

    public StringBuffer getTrimmedRequestURL() {
        return StringUtils.trimTrailingSlashes(this.getRequestURL());
    }

    public String getServletURI() {
        if (this.servletURI == null) {
            this.servletURI = this.getServletURIBuilder().toString();
        }
        return this.servletURI;
    }

    public String getRelativeServletURI() {
        if (this.relativeServletURI == null) {
            this.relativeServletURI = this.getContextPath() + this.getServletPath();
        }
        return this.relativeServletURI;
    }

    public StringBuffer getServletURIBuilder() {
        return RestUtils.trimPathInfo(this.getRequestURL(), this.getContextPath(), this.getServletPath());
    }

    public String getServletTitle() {
        return this.context.getInfoProvider().getTitle(this);
    }

    public String getServletDescription() {
        return this.context.getInfoProvider().getDescription(this);
    }

    public String getMethodSummary() {
        return this.context.getInfoProvider().getMethodSummary(this.javaMethod.getName(), this);
    }

    public String getMethodDescription() {
        return this.context.getInfoProvider().getMethodDescription(this.javaMethod.getName(), this);
    }

    protected String getPageTitle() {
        String s = this.pageTitle;
        if (StringUtils.isEmpty(s)) {
            s = this.context.getMessages().findFirstString(this.getLocale(), this.javaMethod.getName() + ".pageTitle");
        }
        if (StringUtils.isEmpty(s)) {
            s = this.context.getMessages().findFirstString(this.getLocale(), "pageTitle");
        }
        if (!StringUtils.isEmpty(s)) {
            return this.resolveVars(s);
        }
        s = this.getServletTitle();
        return s;
    }

    protected String getPageText() {
        String s = this.pageText;
        if (StringUtils.isEmpty(s)) {
            s = this.context.getMessages().findFirstString(this.getLocale(), this.javaMethod.getName() + ".pageText");
        }
        if (StringUtils.isEmpty(s)) {
            s = this.context.getMessages().findFirstString(this.getLocale(), "pageText");
        }
        if (!StringUtils.isEmpty(s)) {
            return this.resolveVars(s);
        }
        s = this.getMethodSummary();
        if (StringUtils.isEmpty(s)) {
            s = this.getServletDescription();
        }
        return s;
    }

    protected String getPageLinks() {
        String s = this.pageLinks;
        if (StringUtils.isEmpty(s)) {
            s = this.context.getMessages().findFirstString(this.getLocale(), this.javaMethod.getName() + ".pageLinks");
        }
        if (StringUtils.isEmpty(s)) {
            s = this.context.getMessages().findFirstString(this.getLocale(), "pageLinks");
        }
        return this.resolveVars(s);
    }

    public SerializerGroup getSerializerGroup() {
        return this.serializerGroup;
    }

    public ParserGroup getParserGroup() {
        return this.parserGroup;
    }

    public ParserMatch getParserMatch() {
        MediaType mediaType = this.getMediaType();
        ParserMatch pm = this.parserGroup.getParserMatch(mediaType);
        if (pm == null && mediaType.equals(MediaType.URLENCODING)) {
            pm = new ParserMatch(MediaType.URLENCODING, this.urlEncodingParser);
        }
        return pm;
    }

    public Parser getParser() {
        ParserMatch pm = this.getParserMatch();
        return pm == null ? null : pm.getParser();
    }

    public ReaderParser getReaderParser() {
        Parser p = this.getParser();
        if (p != null && p.isReaderParser()) {
            return (ReaderParser)p;
        }
        return null;
    }

    public String getMethod() {
        return this.method;
    }

    public int getContentLength() {
        return this.contentLength == 0 ? super.getContentLength() : this.contentLength;
    }

    public boolean isPlainText() {
        return "true".equals(this.getQueryParameter("plainText", "false"));
    }

    public String getMessage(String key, Object ... args) {
        return this.context.getMessages().getString(this.getLocale(), key, args);
    }

    public MessageBundle getResourceBundle() {
        return this.context.getMessages().getBundle(this.getLocale());
    }

    public RestContext getContext() {
        return this.context;
    }

    public Method getJavaMethod() {
        return this.javaMethod;
    }

    public BeanSession getBeanSession() {
        return this.beanSession;
    }

    public VarResolverSession getVarResolverSession() {
        if (this.varSession == null) {
            this.varSession = this.context.getVarResolver().createSession(this.context.getCallHandler().getSessionObjects(this));
        }
        return this.varSession;
    }

    public String resolveVars(String input) {
        return this.getVarResolverSession().resolve(input);
    }

    public ReaderResource getReaderResource(String name, boolean resolveVars, MediaType mediaType) throws IOException {
        String s = this.context.getResourceAsString(name, this.getLocale());
        if (s == null) {
            return null;
        }
        ReaderResource.Builder b = new ReaderResource.Builder().mediaType(mediaType).contents(s);
        if (resolveVars) {
            b.varResolver(this.getVarResolverSession());
        }
        return b.build();
    }

    public ReaderResource getReaderResource(String name, boolean resolveVars) throws IOException {
        return this.getReaderResource(name, resolveVars, MediaType.forString(this.context.getMediaTypeForName(name)));
    }

    public ReaderResource getReaderResource(String name) throws IOException {
        return this.getReaderResource(name, false, MediaType.forString(this.context.getMediaTypeForName(name)));
    }

    public ConfigFile getConfigFile() {
        if (this.cf == null) {
            this.cf = this.context.getConfigFile().getResolving(this.getVarResolverSession());
        }
        return this.cf;
    }

    public Swagger getSwagger() {
        if (this.swagger == null) {
            this.swagger = this.context.getInfoProvider().getSwagger(this);
        }
        return this.swagger;
    }

    protected Swagger getSwaggerFromFile() {
        if (this.fileSwagger == null) {
            this.fileSwagger = this.context.getInfoProvider().getSwaggerFromFile(this.getLocale());
        }
        if (this.fileSwagger == null) {
            this.fileSwagger = Swagger.NULL;
        }
        return this.fileSwagger == Swagger.NULL ? null : this.fileSwagger;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\n").append(this.getDescription()).append("\n");
        sb.append("---Headers---\n");
        Enumeration e = this.getHeaderNames();
        while (e.hasMoreElements()) {
            String string = (String)e.nextElement();
            sb.append("\t").append(string).append(": ").append(this.getHeader(string)).append("\n");
        }
        sb.append("---Default Servlet Headers---\n");
        for (Map.Entry entry : this.defaultServletHeaders.entrySet()) {
            sb.append("\t").append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append("\n");
        }
        if (this.javaMethod == null) {
            sb.append("***init() not called yet!***\n");
        } else if (this.method.equals("PUT") || this.method.equals("POST")) {
            try {
                this.body = IOUtils.readBytes((InputStream)this.getInputStream(), 1024);
                sb.append("---Body UTF-8---\n");
                sb.append(new String(this.body, "UTF-8")).append("\n");
                sb.append("---Body Hex---\n");
                sb.append(StringUtils.toHex(this.body)).append("\n");
            }
            catch (Exception e1) {
                sb.append(e1.getLocalizedMessage());
                this.context.getLogger().log(Level.WARNING, e1, "Error occurred while trying to read debug input.", new Object[0]);
            }
        }
        return sb.toString();
    }

    private <T> T parseParameter(String val, ClassMeta<T> c) throws ParseException {
        return this.urlEncodingParser.parsePart(val, c);
    }

    private static Locale toLocale(String lang) {
        String country = "";
        int i = lang.indexOf(45);
        if (i > -1) {
            country = lang.substring(i + 1).trim();
            lang = lang.substring(0, i).trim();
        }
        return new Locale(lang, country);
    }

    private Encoder getEncoder() {
        if (this.encoder == null) {
            String ce = this.getHeader("content-encoding");
            if (ce != null && !ce.isEmpty()) {
                ce = ce.trim();
                this.encoder = this.encoders.getEncoder(ce);
                if (this.encoder == null) {
                    throw new RestException(415, "Unsupported encoding in request header ''Content-Encoding'': ''{0}''\n\tSupported codings: {1}", this.getHeader("content-encoding"), this.encoders.getSupportedEncodings());
                }
            }
            if (this.encoder != null) {
                this.contentLength = -1;
            }
        }
        if (this.encoder == IdentityEncoder.INSTANCE) {
            return null;
        }
        return this.encoder;
    }

    private String getOverriddenHeader(String name) {
        String h = null;
        if (this.context.isAllowHeaderParams()) {
            h = this.getQueryParameter(name);
        }
        if (h != null) {
            return h;
        }
        if (this.overriddenHeaders != null && (h = this.overriddenHeaders.get(name)) != null) {
            return h;
        }
        return h;
    }

    void setJavaMethod(Method method) {
        this.javaMethod = method;
    }

    private static class ServletInputStream2
    extends ServletInputStream {
        private final InputStream is;

        private ServletInputStream2(InputStream is) {
            this.is = is;
        }

        private ServletInputStream2(byte[] b) {
            this(new ByteArrayInputStream(b));
        }

        public final int read() throws IOException {
            return this.is.read();
        }

        public final void close() throws IOException {
            this.is.close();
        }
    }
}

