/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;

public class RestException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final int status;
    private int occurrence;

    public RestException(int status, String msg, Object ... args) {
        super(args.length == 0 ? msg : MessageFormat.format(msg, args));
        this.status = status;
    }

    public RestException(int status, Throwable cause) {
        this(status, cause.getLocalizedMessage(), new Object[0]);
        this.initCause(cause);
    }

    @Override
    public synchronized RestException initCause(Throwable cause) {
        super.initCause(cause);
        return this;
    }

    public Throwable getRootCause() {
        Throwable t = this;
        while (t != null) {
            if ((t = t.getCause()) instanceof RestException || t instanceof InvocationTargetException) continue;
            return t;
        }
        return null;
    }

    public String getFullStackMessage(boolean scrubForXssVulnerabilities) {
        String msg = this.getMessage();
        StringBuilder sb = new StringBuilder();
        if (msg != null) {
            if (scrubForXssVulnerabilities) {
                msg = msg.replace('<', ' ').replace('>', ' ').replace('&', ' ');
            }
            sb.append(msg);
        }
        for (Throwable e = this.getCause(); e != null; e = e.getCause()) {
            msg = e.getMessage();
            if (msg != null && scrubForXssVulnerabilities) {
                msg = msg.replace('<', ' ').replace('>', ' ').replace('&', ' ');
            }
            String cls = e.getClass().getSimpleName();
            if (msg == null) {
                sb.append(MessageFormat.format("\nCaused by ({0})", cls));
                continue;
            }
            sb.append(MessageFormat.format("\nCaused by ({0}): {1}", cls, msg));
        }
        return sb.toString();
    }

    public int hashCode() {
        int i = 0;
        for (Throwable t = this; t != null; t = t.getCause()) {
            for (StackTraceElement e : t.getStackTrace()) {
                i ^= e.hashCode();
            }
        }
        return i;
    }

    void setOccurrence(int occurrence) {
        this.occurrence = occurrence;
    }

    public int getOccurrence() {
        return this.occurrence;
    }

    public int getStatus() {
        return this.status;
    }
}

