/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderGroupBuilder;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.ini.ConfigFile;
import org.apache.juneau.ini.ConfigFileBuilder;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.Pair;
import org.apache.juneau.internal.ReflectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroupBuilder;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestCallHandler;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestConverter;
import org.apache.juneau.rest.RestGuard;
import org.apache.juneau.rest.RestInfoProvider;
import org.apache.juneau.rest.RestLogger;
import org.apache.juneau.rest.RestResourceResolver;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.RestUtils;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.response.DefaultHandler;
import org.apache.juneau.rest.response.InputStreamHandler;
import org.apache.juneau.rest.response.ReaderHandler;
import org.apache.juneau.rest.response.RedirectHandler;
import org.apache.juneau.rest.response.StreamableHandler;
import org.apache.juneau.rest.response.WritableHandler;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerGroupBuilder;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverBuilder;
import org.apache.juneau.svl.vars.ConfigFileVar;
import org.apache.juneau.svl.vars.EnvVariablesVar;
import org.apache.juneau.svl.vars.IfVar;
import org.apache.juneau.svl.vars.SwitchVar;
import org.apache.juneau.svl.vars.SystemPropertiesVar;

public class RestConfig
implements ServletConfig {
    final ServletConfig inner;
    ObjectMap properties;
    ConfigFile configFile;
    VarResolverBuilder varResolverBuilder;
    List<Class<?>> beanFilters = new ArrayList();
    List<Class<?>> pojoSwaps = new ArrayList();
    SerializerGroupBuilder serializers = new SerializerGroupBuilder();
    ParserGroupBuilder parsers = new ParserGroupBuilder();
    EncoderGroupBuilder encoders = new EncoderGroupBuilder().append(IdentityEncoder.INSTANCE);
    List<Object> converters = new ArrayList<Object>();
    List<Object> guards = new ArrayList<Object>();
    MimetypesFileTypeMap mimeTypes = new MimetypesFileTypeMap();
    Map<String, String> defaultRequestHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    Map<String, Object> defaultResponseHeaders = new LinkedHashMap<String, Object>();
    List<Object> responseHandlers = new ArrayList<Object>();
    List<Object> childResources = new ArrayList<Object>();
    List<MediaType> supportedContentTypes;
    List<MediaType> supportedAcceptTypes;
    List<Object> styleSheets;
    Object favIcon;
    List<Object> staticFiles;
    RestContext parentContext;
    String path;
    String pageTitle;
    String pageText;
    String pageLinks;
    String clientVersionHeader = "X-Client-Version";
    Object resourceResolver = RestResourceResolver.class;
    Object logger = RestLogger.Normal.class;
    Object callHandler = RestCallHandler.class;
    Object infoProvider = RestInfoProvider.class;

    RestConfig(ServletConfig config, Class<?> resourceClass, RestContext parentContext) throws ServletException {
        this.inner = config;
        this.parentContext = parentContext;
        try {
            ConfigFileBuilder cfb = new ConfigFileBuilder();
            this.properties = new ObjectMap();
            this.configFile = cfb.build();
            this.varResolverBuilder = new VarResolverBuilder().vars(SystemPropertiesVar.class, EnvVariablesVar.class, ConfigFileVar.class, IfVar.class, SwitchVar.class);
            VarResolver vr = this.varResolverBuilder.build();
            LinkedHashMap<Class<?>, RestResource> restResourceAnnotationsParentFirst = ReflectionUtils.findAnnotationsMapParentFirst(RestResource.class, resourceClass);
            String configPath = "";
            for (RestResource r : restResourceAnnotationsParentFirst.values()) {
                if (r.config().isEmpty()) continue;
                configPath = r.config();
            }
            String cf = vr.resolve(configPath);
            if (!cf.isEmpty()) {
                this.configFile = cfb.build(cf);
            }
            this.configFile = this.configFile.getResolving(vr);
            this.varResolverBuilder.contextObject("config", this.configFile);
            vr = this.varResolverBuilder.build();
            ServletContext ctx = config.getServletContext();
            String ctxPath = ctx.getContextPath();
            if (ctxPath.endsWith("null")) {
                ctxPath = ctxPath.substring(0, ctxPath.length() - 4);
            }
            this.properties.put("Serializer.relativeUriBase", ctxPath);
            Enumeration ep = config.getInitParameterNames();
            while (ep.hasMoreElements()) {
                String p = (String)ep.nextElement();
                String initParam = config.getInitParameter(p);
                this.properties.put(vr.resolve(p), vr.resolve(initParam));
            }
            for (Map.Entry e : restResourceAnnotationsParentFirst.entrySet()) {
                Class c = (Class)e.getKey();
                RestResource r = (RestResource)e.getValue();
                for (Property p : r.properties()) {
                    this.properties.append(vr.resolve(p.name()), vr.resolve(p.value()));
                }
                this.addSerializers(ArrayUtils.reverse(r.serializers()));
                this.addParsers(ArrayUtils.reverse(r.parsers()));
                this.addEncoders(ArrayUtils.reverse(r.encoders()));
                this.addDefaultRequestHeaders(r.defaultRequestHeaders());
                this.addDefaultResponseHeaders(r.defaultResponseHeaders());
                this.addResponseHandlers(r.responseHandlers());
                this.addConverters(r.converters());
                this.addGuards(ArrayUtils.reverse(r.guards()));
                this.addChildResources(r.children());
                this.addBeanFilters(r.beanFilters());
                this.addPojoSwaps(r.pojoSwaps());
                if (!r.stylesheet().isEmpty()) {
                    this.setStyleSheet(c, r.stylesheet());
                }
                if (!r.favicon().isEmpty()) {
                    this.setFavIcon(c, r.favicon());
                }
                if (!r.staticFiles().isEmpty()) {
                    this.addStaticFiles(c, r.staticFiles());
                }
                if (!r.path().isEmpty()) {
                    this.setPath(r.path());
                }
                if (!r.clientVersionHeader().isEmpty()) {
                    this.setClientVersionHeader(r.clientVersionHeader());
                }
                if (!r.pageTitle().isEmpty()) {
                    this.setPageTitle(r.pageTitle());
                }
                if (!r.pageText().isEmpty()) {
                    this.setPageText(r.pageText());
                }
                if (!r.pageLinks().isEmpty()) {
                    this.setPageLinks(r.pageLinks());
                }
                if (r.resourceResolver() != RestResourceResolver.class) {
                    this.setResourceResolver(r.resourceResolver());
                }
                if (r.logger() != RestLogger.Normal.class) {
                    this.setLogger(r.logger());
                }
                if (r.callHandler() != RestCallHandler.class) {
                    this.setCallHandler(r.callHandler());
                }
                if (r.infoProvider() == RestInfoProvider.class) continue;
                this.setInfoProvider(r.infoProvider());
            }
            this.addResponseHandlers(StreamableHandler.class, WritableHandler.class, ReaderHandler.class, InputStreamHandler.class, RedirectHandler.class, DefaultHandler.class);
            this.addMimeTypes("text/css css CSS", "text/html html htm HTML", "text/plain txt text TXT", "application/javascript js", "image/png png", "image/gif gif", "application/xml xml XML", "application/json json JSON");
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public RestConfig addVars(Class<?> ... vars) {
        this.varResolverBuilder.vars(vars);
        return this;
    }

    public RestConfig addVarContextObject(String name, Object object) {
        this.varResolverBuilder.contextObject(name, object);
        return this;
    }

    public RestConfig setConfigFile(ConfigFile configFile) {
        this.configFile = configFile;
        return this;
    }

    public RestConfig setProperty(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public RestConfig setProperties(Map<String, Object> properties) {
        this.properties.putAll(properties);
        return this;
    }

    public RestConfig addBeanFilters(Class<?> ... beanFilters) {
        this.beanFilters.addAll(Arrays.asList(beanFilters));
        return this;
    }

    public RestConfig addPojoSwaps(Class<?> ... pojoSwaps) {
        this.pojoSwaps.addAll(Arrays.asList(pojoSwaps));
        return this;
    }

    public RestConfig addSerializers(Class<?> ... serializers) {
        this.serializers.append(serializers);
        return this;
    }

    public RestConfig addSerializers(Serializer ... serializers) {
        this.serializers.append(serializers);
        return this;
    }

    public RestConfig addParsers(Class<?> ... parsers) {
        this.parsers.append(parsers);
        return this;
    }

    public RestConfig addParsers(Parser ... parsers) {
        this.parsers.append(parsers);
        return this;
    }

    public RestConfig addEncoders(Class<?> ... encoders) {
        this.encoders.append(encoders);
        return this;
    }

    public RestConfig addEncoders(Encoder ... encoders) {
        this.encoders.append(encoders);
        return this;
    }

    public RestConfig addConverters(Class<?> ... converters) {
        this.converters.addAll(Arrays.asList(converters));
        return this;
    }

    public RestConfig addConverters(RestConverter ... converters) {
        this.converters.addAll(Arrays.asList(converters));
        return this;
    }

    public RestConfig addGuards(Class<?> ... guards) {
        this.guards.addAll(Arrays.asList(guards));
        return this;
    }

    public RestConfig addGuards(RestGuard ... guards) {
        this.guards.addAll(Arrays.asList(guards));
        return this;
    }

    public RestConfig addMimeTypes(String ... mimeTypes) {
        for (String mimeType : mimeTypes) {
            this.mimeTypes.addMimeTypes(mimeType);
        }
        return this;
    }

    public RestConfig addDefaultRequestHeader(String name, Object value) {
        this.defaultRequestHeaders.put(name, StringUtils.toString(value));
        return this;
    }

    public RestConfig addDefaultRequestHeaders(String ... headers) throws RestServletException {
        for (String header : headers) {
            String[] h = RestUtils.parseHeader(header);
            if (h == null) {
                throw new RestServletException("Invalid default request header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", header);
            }
            this.addDefaultRequestHeader(h[0], h[1]);
        }
        return this;
    }

    public RestConfig addDefaultResponseHeader(String name, Object value) {
        this.defaultResponseHeaders.put(name, value);
        return this;
    }

    public RestConfig addDefaultResponseHeaders(String ... headers) throws RestServletException {
        for (String header : headers) {
            String[] h = RestUtils.parseHeader(header);
            if (h == null) {
                throw new RestServletException("Invalid default response header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", header);
            }
            this.addDefaultResponseHeader(h[0], h[1]);
        }
        return this;
    }

    public RestConfig addResponseHandlers(Class<?> ... responseHandlers) {
        this.responseHandlers.addAll(Arrays.asList(responseHandlers));
        return this;
    }

    public RestConfig addResponseHandlers(ResponseHandler ... responseHandlers) {
        this.responseHandlers.addAll(Arrays.asList(responseHandlers));
        return this;
    }

    public RestConfig addChildResource(String path, Object child) {
        this.childResources.add(new Pair<String, Object>(path, child));
        return this;
    }

    public RestConfig addChildResources(Object ... children) {
        this.childResources.addAll(Arrays.asList(children));
        return this;
    }

    public RestConfig addChildResources(Class<?> ... children) {
        this.childResources.addAll(Arrays.asList(children));
        return this;
    }

    public RestConfig setSupportedAcceptTypes(String ... mediaTypes) {
        this.supportedAcceptTypes = new ArrayList<MediaType>();
        for (String mediaType : mediaTypes) {
            this.supportedAcceptTypes.add(MediaType.forString(mediaType));
        }
        return this;
    }

    public RestConfig setSupportedAcceptTypes(MediaType ... mediaTypes) {
        this.supportedAcceptTypes = Arrays.asList(mediaTypes);
        return this;
    }

    public RestConfig setSupportedContentTypes(String ... mediaTypes) {
        this.supportedContentTypes = new ArrayList<MediaType>();
        for (String mediaType : mediaTypes) {
            this.supportedContentTypes.add(MediaType.forString(mediaType));
        }
        return this;
    }

    public RestConfig setSupportedContentTypes(MediaType ... mediaTypes) {
        this.supportedContentTypes = Arrays.asList(mediaTypes);
        return this;
    }

    public RestConfig setStyleSheet(Object ... styleSheets) {
        this.styleSheets = new ArrayList<Object>(Arrays.asList(styleSheets));
        return this;
    }

    public RestConfig setStyleSheet(Class<?> resourceClass, String resourcePath) {
        this.styleSheets = new ArrayList<Object>();
        this.styleSheets.add(new Pair(resourceClass, resourcePath));
        return this;
    }

    public RestConfig addStyleSheet(Object ... styleSheets) {
        if (this.styleSheets == null) {
            this.styleSheets = new ArrayList<Object>();
        }
        this.styleSheets.addAll(Arrays.asList(styleSheets));
        return this;
    }

    public RestConfig addStyleSheet(Class<?> resourceClass, String resourcePath) {
        if (this.styleSheets == null) {
            this.styleSheets = new ArrayList<Object>();
        }
        this.styleSheets.add(new Pair(resourceClass, resourcePath));
        return this;
    }

    public RestConfig setFavIcon(Object favIcon) {
        this.favIcon = favIcon;
        return this;
    }

    public RestConfig setFavIcon(Class<?> resourceClass, String resourcePath) {
        this.favIcon = new Pair(resourceClass, resourcePath);
        return this;
    }

    public RestConfig addStaticFiles(Class<?> resourceClass, String staticFilesString) {
        if (this.staticFiles == null) {
            this.staticFiles = new ArrayList<Object>();
        }
        this.staticFiles.add(new Pair(resourceClass, staticFilesString));
        return this;
    }

    public RestConfig setResourceResolver(Class<? extends RestResourceResolver> resourceResolver) {
        this.resourceResolver = resourceResolver;
        return this;
    }

    public RestConfig setResourceResolver(RestResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
        return this;
    }

    public RestConfig setPath(String path) {
        if (StringUtils.startsWith(path, '/')) {
            path = path.substring(1);
        }
        this.path = path;
        return this;
    }

    public RestConfig setClientVersionHeader(String clientVersionHeader) {
        this.clientVersionHeader = clientVersionHeader;
        return this;
    }

    public RestConfig setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
        return this;
    }

    public RestConfig setPageText(String pageText) {
        this.pageText = pageText;
        return this;
    }

    public RestConfig setPageLinks(String pageLinks) {
        this.pageLinks = pageLinks;
        return this;
    }

    public RestConfig setLogger(Class<? extends RestLogger> logger) {
        this.logger = logger;
        return this;
    }

    public RestConfig setLogger(RestLogger logger) {
        this.logger = logger;
        return this;
    }

    public RestConfig setCallHandler(Class<? extends RestCallHandler> restHandler) {
        this.callHandler = restHandler;
        return this;
    }

    public RestConfig setCallHandler(RestCallHandler restHandler) {
        this.callHandler = restHandler;
        return this;
    }

    public RestConfig setInfoProvider(Class<? extends RestInfoProvider> infoProvider) {
        this.infoProvider = infoProvider;
        return this;
    }

    public RestConfig setInfoProvider(RestInfoProvider infoProvider) {
        this.infoProvider = infoProvider;
        return this;
    }

    protected PropertyStore createPropertyStore() {
        return PropertyStore.create().addProperties(this.properties);
    }

    public ConfigFile getConfigFile() {
        return this.configFile;
    }

    public ObjectMap getProperties() {
        return this.properties;
    }

    public VarResolverBuilder getVarResolverBuilder() {
        return this.varResolverBuilder;
    }

    public String getInitParameter(String name) {
        return this.inner.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.inner.getInitParameterNames();
    }

    public ServletContext getServletContext() {
        return this.inner.getServletContext();
    }

    public String getServletName() {
        return this.inner.getServletName();
    }
}

