/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.text.MessageFormat;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;

public final class Redirect {
    private final int httpResponseCode;
    private final String url;
    private final Object[] args;

    public Redirect(Object url, Object ... args) {
        this(0, url, args);
    }

    public Redirect(Object url) {
        this(0, url, (Object[])null);
    }

    public Redirect(int httpResponseCode, Object url, Object ... args) {
        this.httpResponseCode = httpResponseCode;
        this.url = url == null ? null : url.toString();
        this.args = args;
    }

    public Redirect() {
        this(0, (Object)null, (Object[])null);
    }

    public String toUrl(UrlEncodingSerializer s) {
        if (this.url != null && this.args != null && this.args.length > 0) {
            for (int i = 0; i < this.args.length; ++i) {
                this.args[i] = s.serializePart(this.args[i], null, true);
            }
            return MessageFormat.format(this.url, this.args);
        }
        return this.url;
    }

    public int getHttpResponseCode() {
        return this.httpResponseCode;
    }
}

