/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserContext;
import org.apache.juneau.parser.ParserReader;

public class ParserSession
extends BeanSession {
    private final boolean trimStrings;
    private final boolean strict;
    private final String inputStreamCharset;
    private final String fileCharset;
    private final Method javaMethod;
    private final Object outer;
    private final Object input;
    private InputStream inputStream;
    private Reader reader;
    private Reader noCloseReader;
    private BeanPropertyMeta currentProperty;
    private ClassMeta<?> currentClass;

    public ParserSession(ParserContext ctx, ObjectMap op, Object input, Method javaMethod, Object outer, Locale locale, TimeZone timeZone, MediaType mediaType) {
        super(ctx, op, locale, timeZone, mediaType);
        if (op == null || op.isEmpty()) {
            this.trimStrings = ctx.trimStrings;
            this.strict = ctx.strict;
            this.inputStreamCharset = ctx.inputStreamCharset;
            this.fileCharset = ctx.fileCharset;
        } else {
            this.trimStrings = op.getBoolean("Parser.trimStrings", ctx.trimStrings);
            this.strict = op.getBoolean("Parser.strict", ctx.strict);
            this.inputStreamCharset = op.getString("Parser.inputStreamCharset", ctx.inputStreamCharset);
            this.fileCharset = op.getString("Parser.fileCharset", ctx.fileCharset);
        }
        this.input = input;
        this.javaMethod = javaMethod;
        this.outer = outer;
    }

    public InputStream getInputStream() throws ParseException {
        if (this.input == null) {
            return null;
        }
        if (this.input instanceof InputStream) {
            return (InputStream)this.input;
        }
        if (this.input instanceof byte[]) {
            return new ByteArrayInputStream((byte[])this.input);
        }
        if (this.input instanceof String) {
            return new ByteArrayInputStream(StringUtils.fromHex((String)this.input));
        }
        if (this.input instanceof File) {
            try {
                this.inputStream = new FileInputStream((File)this.input);
                return this.inputStream;
            }
            catch (FileNotFoundException e) {
                throw new ParseException(e);
            }
        }
        throw new ParseException("Cannot convert object of type {0} to an InputStream.", this.input.getClass().getName());
    }

    public Reader getReader() throws Exception {
        if (this.input == null) {
            return null;
        }
        if (this.input instanceof Reader) {
            return (Reader)this.input;
        }
        if (this.input instanceof CharSequence) {
            if (this.reader == null) {
                this.reader = new ParserReader((CharSequence)this.input);
            }
            return this.reader;
        }
        if (this.input instanceof InputStream || this.input instanceof byte[]) {
            InputStream is;
            InputStream inputStream = is = this.input instanceof InputStream ? (InputStream)this.input : new ByteArrayInputStream((byte[])this.input);
            if (this.noCloseReader == null) {
                CharsetDecoder cd = ("default".equalsIgnoreCase(this.inputStreamCharset) ? Charset.defaultCharset() : Charset.forName(this.inputStreamCharset)).newDecoder();
                if (this.strict) {
                    cd.onMalformedInput(CodingErrorAction.REPORT);
                    cd.onUnmappableCharacter(CodingErrorAction.REPORT);
                } else {
                    cd.onMalformedInput(CodingErrorAction.REPLACE);
                    cd.onUnmappableCharacter(CodingErrorAction.REPLACE);
                }
                this.noCloseReader = new InputStreamReader(is, cd);
            }
            return this.noCloseReader;
        }
        if (this.input instanceof File) {
            if (this.reader == null) {
                CharsetDecoder cd = ("default".equalsIgnoreCase(this.fileCharset) ? Charset.defaultCharset() : Charset.forName(this.fileCharset)).newDecoder();
                if (this.strict) {
                    cd.onMalformedInput(CodingErrorAction.REPORT);
                    cd.onUnmappableCharacter(CodingErrorAction.REPORT);
                } else {
                    cd.onMalformedInput(CodingErrorAction.REPLACE);
                    cd.onUnmappableCharacter(CodingErrorAction.REPLACE);
                }
                this.reader = new InputStreamReader((InputStream)new FileInputStream((File)this.input), cd);
            }
            return this.reader;
        }
        throw new ParseException("Cannot convert object of type {0} to a Reader.", this.input.getClass().getName());
    }

    public Map<String, Object> getLastLocation() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        if (this.currentClass != null) {
            m.put("currentClass", this.currentClass.toString(true));
        }
        if (this.currentProperty != null) {
            m.put("currentProperty", this.currentProperty);
        }
        return m;
    }

    protected Object getInput() {
        return this.input;
    }

    public final Method getJavaMethod() {
        return this.javaMethod;
    }

    public final Object getOuter() {
        return this.outer;
    }

    public void setCurrentProperty(BeanPropertyMeta currentProperty) {
        this.currentProperty = currentProperty;
    }

    public void setCurrentClass(ClassMeta<?> currentClass) {
        this.currentClass = currentClass;
    }

    public final boolean isTrimStrings() {
        return this.trimStrings;
    }

    public final boolean isStrict() {
        return this.strict;
    }

    public final <K> K trim(K o) {
        if (this.trimStrings && o instanceof String) {
            return (K)o.toString().trim();
        }
        return o;
    }

    public final String trim(String s) {
        if (this.trimStrings && s != null) {
            return s.trim();
        }
        return s;
    }

    public final Object cast(ObjectMap m, BeanPropertyMeta pMeta, ClassMeta<?> eType) {
        String btpn = this.getBeanTypePropertyName(eType);
        Object o = m.get(btpn);
        if (o == null) {
            return m;
        }
        String typeName = o.toString();
        ClassMeta<?> cm = this.getClassMeta(typeName, pMeta, eType);
        if (cm != null) {
            BeanMap<?> bm = m.getBeanSession().newBeanMap(cm.getInnerClass());
            for (Map.Entry<String, Object> e : m.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                if (k.equals(btpn)) continue;
                if (v instanceof ObjectMap) {
                    v = this.cast((ObjectMap)v, pMeta, eType);
                }
                bm.put(k, v);
            }
            return bm.getBean();
        }
        return m;
    }

    public final ClassMeta<?> getClassMeta(String typeName, BeanPropertyMeta pMeta, ClassMeta<?> eType) {
        BeanRegistry br = null;
        if (pMeta != null && (br = pMeta.getBeanRegistry()) != null && br.hasName(typeName)) {
            return br.getClassMeta(typeName);
        }
        if (eType != null && (br = eType.getBeanRegistry()) != null && br.hasName(typeName)) {
            return br.getClassMeta(typeName);
        }
        return this.getBeanRegistry().getClassMeta(typeName);
    }

    @Override
    public boolean close() {
        if (super.close()) {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
                if (this.reader != null) {
                    this.reader.close();
                }
            }
            catch (IOException e) {
                throw new BeanRuntimeException(e);
            }
            return true;
        }
        return false;
    }
}

