/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserMatch;

public final class ParserGroup {
    private final Map<String, ParserMatch> cache = new ConcurrentHashMap<String, ParserMatch>();
    final Parser[] parsers;
    private final PropertyStore propertyStore;

    public ParserGroup(PropertyStore propertyStore, Parser[] parsers) {
        this.propertyStore = PropertyStore.create(propertyStore);
        this.parsers = ArrayUtils.reverse(parsers);
    }

    public ParserMatch getParserMatch(String contentTypeHeader) {
        ParserMatch pm = this.cache.get(contentTypeHeader);
        if (pm != null) {
            return pm;
        }
        MediaType mt = MediaType.forString(contentTypeHeader);
        return this.getParserMatch(mt);
    }

    public ParserMatch getParserMatch(MediaType mediaType) {
        ParserMatch pm = this.cache.get(mediaType.toString());
        if (pm != null) {
            return pm;
        }
        for (Parser p : this.parsers) {
            for (MediaType a2 : p.getMediaTypes()) {
                if (!mediaType.matches(a2)) continue;
                pm = new ParserMatch(a2, p);
                this.cache.put(mediaType.toString(), pm);
                return pm;
            }
        }
        return null;
    }

    public Parser getParser(String contentTypeHeader) {
        ParserMatch pm = this.getParserMatch(contentTypeHeader);
        return pm == null ? null : pm.getParser();
    }

    public Parser getParser(MediaType mediaType) {
        ParserMatch pm = this.getParserMatch(mediaType);
        return pm == null ? null : pm.getParser();
    }

    public List<MediaType> getSupportedMediaTypes() {
        ArrayList<MediaType> l = new ArrayList<MediaType>();
        for (Parser p : this.parsers) {
            for (MediaType mt : p.getMediaTypes()) {
                if (l.contains(mt)) continue;
                l.add(mt);
            }
        }
        return l;
    }

    public PropertyStore createPropertyStore() {
        return PropertyStore.create(this.propertyStore);
    }

    public Parser[] getParsers() {
        return ArrayUtils.reverse(this.parsers);
    }
}

