/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.text.MessageFormat;
import java.util.Map;
import org.apache.juneau.FormattedException;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParserSession;

public final class ParseException
extends FormattedException {
    private static final long serialVersionUID = 1L;

    public ParseException(ParserSession session, String message, Object ... args) {
        super(ParseException.getMessage(session, message, args), new Object[0]);
    }

    public ParseException(String message, Object ... args) {
        super(ParseException.getMessage(null, message, args), new Object[0]);
    }

    public ParseException(ParserSession session, Exception causedBy) {
        super(causedBy, ParseException.getMessage(session, causedBy.getMessage(), new Object[0]), new Object[0]);
    }

    public ParseException(Exception causedBy) {
        super(causedBy, ParseException.getMessage(null, causedBy.getMessage(), new Object[0]), new Object[0]);
    }

    private static String getMessage(ParserSession session, String msg, Object ... args) {
        Map<String, Object> m;
        if (args.length != 0) {
            msg = MessageFormat.format(msg, args);
        }
        if (session != null && (m = session.getLastLocation()) != null && !m.isEmpty()) {
            msg = "Parse exception occurred at " + JsonSerializer.DEFAULT_LAX.toString(m) + ".  " + msg;
        }
        return msg;
    }

    public ParseException getRootCause() {
        ParseException t = this;
        while (t.getCause() != null && t.getCause() instanceof ParseException) {
            t = (ParseException)t.getCause();
        }
        return t;
    }

    @Override
    public synchronized ParseException initCause(Throwable cause) {
        super.initCause(cause);
        return this;
    }
}

