/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ObjectList;
import org.apache.juneau.Visibility;
import org.apache.juneau.internal.StringUtils;

public final class ClassUtils {
    private static final Map<Class<?>, Class<?>> pmap1 = new HashMap();
    private static final Map<Class<?>, Class<?>> pmap2 = new HashMap();

    public static ObjectList getReadableClassNames(Object[] o) {
        ObjectList l = new ObjectList();
        for (int i = 0; i < o.length; ++i) {
            l.add(o[i] == null ? "null" : ClassUtils.getReadableClassName(o[i].getClass()));
        }
        return l;
    }

    public static String getReadableClassName(Class<?> c) {
        if (c == null) {
            return null;
        }
        return ClassUtils.getReadableClassName(c.getName());
    }

    public static String getReadableClassNameForObject(Object o) {
        if (o == null) {
            return null;
        }
        return ClassUtils.getReadableClassName(o.getClass().getName());
    }

    public static String getReadableClassName(String className) {
        String c;
        if (className == null) {
            return null;
        }
        if (!StringUtils.startsWith(className, '[')) {
            return className;
        }
        int depth = 0;
        for (int i = 0; i < className.length() && className.charAt(i) == '['; ++i) {
            ++depth;
        }
        char type = className.charAt(depth);
        switch (type) {
            case 'Z': {
                c = "boolean";
                break;
            }
            case 'B': {
                c = "byte";
                break;
            }
            case 'C': {
                c = "char";
                break;
            }
            case 'D': {
                c = "double";
                break;
            }
            case 'F': {
                c = "float";
                break;
            }
            case 'I': {
                c = "int";
                break;
            }
            case 'J': {
                c = "long";
                break;
            }
            case 'S': {
                c = "short";
                break;
            }
            default: {
                c = className.substring(depth + 1, className.length() - 1);
            }
        }
        StringBuilder sb = new StringBuilder(c.length() + 2 * depth).append(c);
        for (int i = 0; i < depth; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public static Class<?> getClassFromReadableName(ClassLoader cl, String name) throws ClassNotFoundException {
        return cl.loadClass(name);
    }

    public static boolean isParentClass(Class<?> parent, Class<?> child, boolean strict) {
        return parent.isAssignableFrom(child) && (!strict || !parent.equals(child));
    }

    public static boolean isParentClass(Class<?> parent, Class<?> child) {
        return ClassUtils.isParentClass(parent, child, false);
    }

    public static String getMethodSignature(Method m) {
        StringBuilder sb = new StringBuilder(m.getName());
        Class<?>[] pt = m.getParameterTypes();
        if (pt.length > 0) {
            sb.append('(');
            for (int i = 0; i < pt.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(ClassUtils.getReadableClassName(pt[i]));
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public static Class<?> getPrimitiveWrapper(Class<?> c) {
        return pmap1.get(c);
    }

    public static Class<?> getPrimitiveForWrapper(Class<?> c) {
        return pmap2.get(c);
    }

    public static Class<?> getWrapperIfPrimitive(Class<?> c) {
        if (!c.isPrimitive()) {
            return c;
        }
        return pmap1.get(c);
    }

    public static boolean isNotDeprecated(Class<?> c) {
        return !c.isAnnotationPresent(Deprecated.class);
    }

    public static boolean isNotDeprecated(Method m) {
        return !m.isAnnotationPresent(Deprecated.class);
    }

    public static boolean isNotDeprecated(Constructor<?> c) {
        return !c.isAnnotationPresent(Deprecated.class);
    }

    public static boolean isPublic(Class<?> c) {
        return Modifier.isPublic(c.getModifiers());
    }

    public static boolean isStatic(Class<?> c) {
        return Modifier.isStatic(c.getModifiers());
    }

    public static boolean isPublic(Method m) {
        return Modifier.isPublic(m.getModifiers());
    }

    public static boolean isStatic(Method m) {
        return Modifier.isStatic(m.getModifiers());
    }

    public static boolean isPublic(Constructor<?> c) {
        return Modifier.isPublic(c.getModifiers());
    }

    public static final <T> Constructor<T> findNoArgConstructor(Class<T> c, Visibility v) {
        int mod = c.getModifiers();
        if (Modifier.isAbstract(mod)) {
            return null;
        }
        boolean isMemberClass = c.isMemberClass() && !ClassUtils.isStatic(c);
        for (Constructor<?> cc : c.getConstructors()) {
            mod = cc.getModifiers();
            if (cc.getParameterTypes().length != (isMemberClass ? 1 : 0) || !v.isVisible(mod) || !ClassUtils.isNotDeprecated(cc)) continue;
            return v.transform(cc);
        }
        return null;
    }

    public static Class<?> resolveParameterType(Class<?> c, int index, Class<?> oc) {
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        while (c != oc.getSuperclass()) {
            ClassUtils.extractTypes(typeMap, oc);
            oc = oc.getSuperclass();
        }
        ParameterizedType opt = (ParameterizedType)oc.getGenericSuperclass();
        Type actualType = opt.getActualTypeArguments()[index];
        if (typeMap.containsKey(actualType)) {
            actualType = (Type)typeMap.get(actualType);
        }
        if (actualType instanceof Class) {
            return (Class)actualType;
        }
        if (actualType instanceof GenericArrayType) {
            Class cmpntType = (Class)((GenericArrayType)actualType).getGenericComponentType();
            return Array.newInstance(cmpntType, 0).getClass();
        }
        if (actualType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)actualType;
            LinkedList nestedOuterTypes = new LinkedList();
            for (Class<?> ec = oc.getEnclosingClass(); ec != null; ec = ec.getEnclosingClass()) {
                try {
                    Class<?> outerClass = oc.getClass();
                    nestedOuterTypes.add(outerClass);
                    HashMap<Type, Type> outerTypeMap = new HashMap<Type, Type>();
                    ClassUtils.extractTypes(outerTypeMap, outerClass);
                    for (Map.Entry entry : outerTypeMap.entrySet()) {
                        TypeVariable keyType;
                        Type key = (Type)entry.getKey();
                        Type value = (Type)entry.getValue();
                        if (!(key instanceof TypeVariable) || !(keyType = (TypeVariable)key).getName().equals(typeVariable.getName()) || !ClassUtils.isInnerClass(keyType.getGenericDeclaration(), typeVariable.getGenericDeclaration())) continue;
                        if (value instanceof Class) {
                            return (Class)value;
                        }
                        typeVariable = (TypeVariable)entry.getValue();
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException("Could not resolve type: " + actualType);
        }
        throw new RuntimeException("Invalid type found in resolveParameterType: " + actualType);
    }

    private static boolean isInnerClass(GenericDeclaration od, GenericDeclaration id) {
        if (od instanceof Class && id instanceof Class) {
            Class oc = (Class)od;
            Class<?> ic = (Class<?>)id;
            while ((ic = ic.getEnclosingClass()) != null) {
                if (ic != oc) continue;
                return true;
            }
        }
        return false;
    }

    private static void extractTypes(Map<Type, Type> typeMap, Class<?> c) {
        Type gs = c.getGenericSuperclass();
        if (gs instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)gs;
            TypeVariable<Class<T>>[] typeParameters = ((Class)pt.getRawType()).getTypeParameters();
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                if (typeMap.containsKey(actualTypeArguments[i])) {
                    actualTypeArguments[i] = typeMap.get(actualTypeArguments[i]);
                }
                typeMap.put(typeParameters[i], actualTypeArguments[i]);
            }
        }
    }

    public static Method findPublicMethod(Class<?> c, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        for (Method m : c.getMethods()) {
            Class<?>[] pt;
            Class<?> rt;
            if (!ClassUtils.isPublic(m) || !m.getName().equals(name) || !ClassUtils.isParentClass(returnType, rt = m.getReturnType()) || (pt = m.getParameterTypes()).length != parameterTypes.length) continue;
            boolean matches = true;
            for (int i = 0; i < pt.length; ++i) {
                if (ClassUtils.isParentClass(pt[i], parameterTypes[i])) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return m;
        }
        return null;
    }

    public static <T> Constructor<T> findPublicConstructor(Class<T> c, Class<?> ... parameterTypes) {
        for (Constructor<?> n : c.getConstructors()) {
            Class<?>[] pt;
            if (!ClassUtils.isPublic(n) || (pt = n.getParameterTypes()).length != parameterTypes.length) continue;
            boolean matches = true;
            for (int i = 0; i < pt.length; ++i) {
                if (ClassUtils.isParentClass(pt[i], parameterTypes[i])) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return n;
        }
        return null;
    }

    public static <T> Constructor<T> findPublicConstructor(Class<T> c, Object ... args) {
        return ClassUtils.findPublicConstructor(c, ClassUtils.getClasses(args));
    }

    public static Class<?>[] getClasses(Object ... args) {
        Class[] pt = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            pt[i] = args[i] == null ? null : args[i].getClass();
        }
        return pt;
    }

    public static MethodInfo getMethodInfo(Method m) {
        return new MethodInfo(m);
    }

    public static MethodInfo[] getMethodInfo(Collection<Method> m) {
        MethodInfo[] mi = new MethodInfo[m.size()];
        int i = 0;
        for (Method mm : m) {
            mi[i++] = ClassUtils.getMethodInfo(mm);
        }
        return mi;
    }

    static {
        pmap1.put(Boolean.TYPE, Boolean.class);
        pmap1.put(Byte.TYPE, Byte.class);
        pmap1.put(Short.TYPE, Short.class);
        pmap1.put(Character.TYPE, Character.class);
        pmap1.put(Integer.TYPE, Integer.class);
        pmap1.put(Long.TYPE, Long.class);
        pmap1.put(Float.TYPE, Float.class);
        pmap1.put(Double.TYPE, Double.class);
        pmap2.put(Boolean.class, Boolean.TYPE);
        pmap2.put(Byte.class, Byte.TYPE);
        pmap2.put(Short.class, Short.TYPE);
        pmap2.put(Character.class, Character.TYPE);
        pmap2.put(Integer.class, Integer.TYPE);
        pmap2.put(Long.class, Long.TYPE);
        pmap2.put(Float.class, Float.TYPE);
        pmap2.put(Double.class, Double.TYPE);
    }

    public static class MethodInfo {
        public final String methodName;
        public final String[] parameterTypes;
        public final String returnType;

        MethodInfo(Method m) {
            this.methodName = m.getName();
            Type[] pt = m.getGenericParameterTypes();
            this.parameterTypes = new String[pt.length];
            for (int i = 0; i < pt.length; ++i) {
                this.parameterTypes[i] = BeanContext.DEFAULT.getClassMeta(pt[i], new Type[0]).toString();
            }
            this.returnType = BeanContext.DEFAULT.getClassMeta(m.getGenericReturnType(), new Type[0]).toString();
        }
    }

    public static final class ClassComparator
    implements Comparator<Class<?>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(Class<?> object1, Class<?> object2) {
            return object1.getName().compareTo(object2.getName());
        }
    }
}

