/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.ini;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.ini.ConfigFile;
import org.apache.juneau.ini.ConfigFileFormat;
import org.apache.juneau.ini.ConfigFileImpl;
import org.apache.juneau.ini.Encoder;
import org.apache.juneau.ini.XorEncoder;
import org.apache.juneau.internal.FileUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.Args;

public class ConfigFileBuilder {
    private WriterSerializer serializer = JsonSerializer.DEFAULT_LAX;
    private ReaderParser parser = JsonParser.DEFAULT;
    private Encoder encoder = new XorEncoder();
    private boolean readOnly = false;
    private boolean createIfNotExists = false;
    private Charset charset = Charset.defaultCharset();
    private List<File> searchPaths = new AList<File>().append(new File("."));

    public ConfigFileBuilder encoder(Encoder encoder) {
        this.encoder = encoder;
        return this;
    }

    public ConfigFileBuilder serializer(WriterSerializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public ConfigFileBuilder parser(ReaderParser parser) {
        this.parser = parser;
        return this;
    }

    public ConfigFileBuilder charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public ConfigFileBuilder paths(String ... searchPaths) {
        this.searchPaths = new LinkedList<File>();
        for (String p : searchPaths) {
            this.searchPaths.add(new File(p));
        }
        return this;
    }

    public ConfigFileBuilder readOnly() {
        this.readOnly = true;
        return this;
    }

    public ConfigFileBuilder createIfNotExists() {
        this.createIfNotExists = true;
        return this;
    }

    public ConfigFile build(String path) throws IOException {
        return new ConfigFileImpl(this.resolve(path), this.readOnly, this.encoder, this.serializer, this.parser, this.charset);
    }

    public ConfigFile build() throws IOException {
        return new ConfigFileImpl(null, false, this.encoder, this.serializer, this.parser, this.charset);
    }

    public ConfigFile build(File f) throws IOException {
        return new ConfigFileImpl(f, false, this.encoder, this.serializer, this.parser, this.charset);
    }

    public ConfigFile build(Reader r) throws IOException {
        return new ConfigFileImpl(null, false, this.encoder, this.serializer, this.parser, this.charset).load(r);
    }

    private File resolve(String path) throws IOException {
        File f = new File(path);
        if (f.isAbsolute()) {
            if (this.createIfNotExists) {
                FileUtils.create(f);
            }
            if (f.exists()) {
                return f;
            }
            throw new FileNotFoundException("Could not find config file '" + path + "'");
        }
        if (this.searchPaths.isEmpty()) {
            throw new FileNotFoundException("No search paths specified in ConfigFileBuilder.");
        }
        for (File sf : this.searchPaths) {
            f = new File(sf.getAbsolutePath() + "/" + path);
            if (!f.exists()) continue;
            return f;
        }
        if (this.createIfNotExists) {
            f = new File(this.searchPaths.get(0).getAbsolutePath() + "/" + path);
            FileUtils.create(f);
            return f;
        }
        throw new FileNotFoundException("Could not find config file '" + path + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block21: {
            Args a = new Args(args);
            String command = a.getArg(0);
            String configFile = a.getArg("configFile");
            String envFile = a.getArg("envFile");
            List<String> vals = a.getArgs("vals");
            if (command == null || !command.equals("createBatchEnvFile") && !command.equals("createShellEnvFile") && !command.equals("setVals")) {
                ConfigFileBuilder.printUsageAndExit();
            } else if (configFile.isEmpty()) {
                ConfigFileBuilder.printUsageAndExit();
            } else if (command.equals("setVals") && vals.isEmpty()) {
                ConfigFileBuilder.printUsageAndExit();
            } else if ((command.equals("createBatchEnvFile") || command.equals("createShellEnvFile")) && envFile.isEmpty()) {
                ConfigFileBuilder.printUsageAndExit();
            } else {
                try {
                    ConfigFile cf = new ConfigFileBuilder().build(configFile);
                    if (command.equalsIgnoreCase("setVals")) {
                        for (String val : vals) {
                            String[] x = val.split("\\=");
                            if (x.length != 2) {
                                throw new RuntimeException("Invalid format for value: '" + val + "'.  Must be in the format 'key=value'");
                            }
                            cf.put(x[0], x[1]);
                        }
                        cf.save();
                        return;
                    }
                    if (command.equalsIgnoreCase("createBatchEnvFile")) {
                        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(envFile), Charset.defaultCharset());
                        try {
                            cf.serializeTo(fw, ConfigFileFormat.BATCH);
                        }
                        finally {
                            ((Writer)fw).close();
                        }
                        return;
                    }
                    if (!command.equalsIgnoreCase("createShellEnvFile")) break block21;
                    OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(envFile), Charset.defaultCharset());
                    try {
                        cf.serializeTo(fw, ConfigFileFormat.SHELL);
                    }
                    finally {
                        ((Writer)fw).close();
                    }
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void printUsageAndExit() {
        System.err.println("---Usage---");
        System.err.println("java -cp juneau.jar org.apache.juneau.ini.ConfigFile createBatchEnvFile -configFile <configFile> -envFile <envFile> [-verbose]");
        System.err.println("java -cp juneau.jar org.apache.juneau.ini.ConfigFile createShellEnvFile -configFile <configFile> -envFile <envFile> [-verbose]");
        System.err.println("java -cp juneau.jar org.apache.juneau.ini.ConfigFile setVals -configFile <configFile> -vals [var1 val1 [var2 val2...]] [-verbose]");
        int rc = Integer.getInteger("exit.2", 2);
        if (rc != 0) {
            System.exit(rc);
        }
    }
}

