/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.html.HtmlSerializerContext;
import org.apache.juneau.html.HtmlWriter;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.xml.XmlSerializerSession;

public class HtmlSerializerSession
extends XmlSerializerSession {
    private final AnchorText anchorText;
    private final boolean detectLinksInStrings;
    private final boolean lookForLabelParameters;
    private final boolean addKeyValueTableHeaders;
    private final boolean addBeanTypeProperties;
    private final Pattern urlPattern = Pattern.compile("http[s]?\\:\\/\\/.*");
    private final Pattern labelPattern;
    private final String absolutePathUriBase;
    private final String relativeUriBase;

    protected HtmlSerializerSession(HtmlSerializerContext ctx, ObjectMap op, Object output, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType) {
        super(ctx, op, output, javaMethod, locale, timeZone, mediaType);
        String labelParameter;
        if (op == null || op.isEmpty()) {
            this.anchorText = Enum.valueOf(AnchorText.class, ctx.uriAnchorText);
            this.detectLinksInStrings = ctx.detectLinksInStrings;
            this.lookForLabelParameters = ctx.lookForLabelParameters;
            labelParameter = ctx.labelParameter;
            this.addKeyValueTableHeaders = ctx.addKeyValueTableHeaders;
            this.addBeanTypeProperties = ctx.addBeanTypeProperties;
        } else {
            this.anchorText = Enum.valueOf(AnchorText.class, op.getString("HtmlSerializer.uriAnchorText", ctx.uriAnchorText));
            this.detectLinksInStrings = op.getBoolean("HtmlSerializer.detectLinksInStrings", ctx.detectLinksInStrings);
            this.lookForLabelParameters = op.getBoolean("HtmlSerializer.lookForLabelParameters", ctx.lookForLabelParameters);
            labelParameter = op.getString("HtmlSerializer.labelParameter", ctx.labelParameter);
            this.addKeyValueTableHeaders = op.getBoolean("HtmlSerializer.addKeyValueTableHeaders", ctx.addKeyValueTableHeaders);
            this.addBeanTypeProperties = op.getBoolean("MsgPackSerializer.addBeanTypeProperties", ctx.addBeanTypeProperties);
        }
        this.labelPattern = Pattern.compile("[\\?\\&]" + Pattern.quote(labelParameter) + "=([^\\&]*)");
        this.absolutePathUriBase = this.getAbsolutePathUriBase();
        this.relativeUriBase = this.getRelativeUriBase();
    }

    @Override
    public HtmlWriter getWriter() throws Exception {
        Object output = this.getOutput();
        if (output instanceof HtmlWriter) {
            return (HtmlWriter)output;
        }
        return new HtmlWriter(super.getWriter(), this.isUseWhitespace(), this.isTrimStrings(), this.getQuoteChar(), this.getRelativeUriBase(), this.getAbsolutePathUriBase());
    }

    public boolean isUri(ClassMeta<?> cm, BeanPropertyMeta pMeta, Object o) {
        if (cm.isUri()) {
            return true;
        }
        if (pMeta != null && pMeta.isUri()) {
            return true;
        }
        return this.detectLinksInStrings && o instanceof CharSequence && this.urlPattern.matcher(o.toString()).matches();
    }

    public String getAnchorText(BeanPropertyMeta pMeta, Object o) {
        String s;
        Matcher m;
        if (this.lookForLabelParameters && (m = this.labelPattern.matcher(s = o.toString())).find()) {
            return m.group(1);
        }
        switch (this.anchorText) {
            case LAST_TOKEN: {
                s = o.toString();
                if (s.indexOf(47) != -1) {
                    s = s.substring(s.lastIndexOf(47) + 1);
                }
                if (s.indexOf(63) != -1) {
                    s = s.substring(0, s.indexOf(63));
                }
                if (s.indexOf(35) != -1) {
                    s = s.substring(0, s.indexOf(35));
                }
                return s;
            }
            case URI_ANCHOR: {
                s = o.toString();
                if (s.indexOf(35) != -1) {
                    s = s.substring(s.lastIndexOf(35) + 1);
                }
                return s;
            }
            case PROPERTY_NAME: {
                return pMeta == null ? o.toString() : pMeta.getName();
            }
            case URI: {
                s = o.toString();
                if (s.indexOf("://") == -1) {
                    if (StringUtils.startsWith(s, '/')) {
                        s = this.absolutePathUriBase + s;
                    } else if (this.relativeUriBase != null) {
                        s = !this.relativeUriBase.equals("/") ? this.relativeUriBase + "/" + s : "/" + s;
                    }
                }
                return s;
            }
        }
        return o.toString();
    }

    public final boolean isAddKeyValueTableHeaders() {
        return this.addKeyValueTableHeaders;
    }

    @Override
    public final boolean isAddBeanTypeProperties() {
        return this.addBeanTypeProperties;
    }

    @Override
    public boolean isHtmlMode() {
        return true;
    }

    static enum AnchorText {
        PROPERTY_NAME,
        TO_STRING,
        URI,
        LAST_TOKEN,
        URI_ANCHOR;

    }
}

