/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.util.Collections;
import java.util.Map;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.html.HtmlSerializerContext;

public final class HtmlDocSerializerContext
extends HtmlSerializerContext {
    public static final String HTMLDOC_title = "HtmlSerializer.title";
    public static final String HTMLDOC_text = "HtmlSerializer.description";
    public static final String HTMLDOC_links = "HtmlDocSerializer.links.map";
    public static final String HTMLDOC_links_put = "HtmlDocSerializer.links.map.put";
    public static final String HTMLDOC_cssUrl = "HtmlDocSerializer.cssUrl";
    public static final String HTMLDOC_cssImports = "HtmlDocSerializer.cssImports.list";
    public static final String HTMLDOC_cssImports_add = "HtmlDocSerializer.cssImports.list.add";
    public static final String HTMLDOC_nowrap = "HtmlDocSerializer.nowrap";
    final String[] cssImports;
    final Map<String, String> links;
    final String title;
    final String text;
    final String cssUrl;
    final boolean nowrap;

    public HtmlDocSerializerContext(PropertyStore ps) {
        super(ps);
        this.cssImports = ps.getProperty(HTMLDOC_cssImports, String[].class, new String[0]);
        this.title = ps.getProperty(HTMLDOC_title, String.class, null);
        this.text = ps.getProperty(HTMLDOC_text, String.class, null);
        this.cssUrl = ps.getProperty(HTMLDOC_cssUrl, String.class, null);
        this.nowrap = ps.getProperty(HTMLDOC_nowrap, Boolean.TYPE, false);
        this.links = ps.getMap(HTMLDOC_links, String.class, String.class, Collections.emptyMap());
    }

    @Override
    public ObjectMap asMap() {
        return super.asMap().append("HtmlDocSerializerContext", new ObjectMap().append("cssImports", this.cssImports).append("title", this.title).append("text", this.text).append("cssUrl", this.cssUrl).append("nowrap", this.nowrap).append("links", this.links));
    }
}

