/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.dto.Link;
import org.apache.juneau.html.HtmlDocSerializerContext;
import org.apache.juneau.html.HtmlDocSerializerSession;
import org.apache.juneau.html.HtmlStrippedDocSerializer;
import org.apache.juneau.html.HtmlWriter;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.SerializerSession;

@Produces(value="text/html")
public class HtmlDocSerializer
extends HtmlStrippedDocSerializer {
    private static final String REST_method = "RestServlet.method";
    private static final String REST_relativeServletURI = "RestServlet.relativeServletURI";
    public static final HtmlDocSerializer DEFAULT = new HtmlDocSerializer(PropertyStore.create());
    final HtmlDocSerializerContext ctx = this.createContext(HtmlDocSerializerContext.class);

    public HtmlDocSerializer(PropertyStore propertyStore) {
        super(propertyStore);
    }

    @Override
    public HtmlDocSerializerSession createSession(Object output, ObjectMap op, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType) {
        return new HtmlDocSerializerSession(this.ctx, op, output, javaMethod, locale, timeZone, mediaType);
    }

    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        Map<String, String> htmlLinks;
        HtmlDocSerializerSession s = (HtmlDocSerializerSession)session;
        HtmlWriter w = s.getWriter();
        ObjectMap op = s.getProperties();
        boolean isOptionsPage = op.containsKey(REST_method) && op.getString(REST_method).equalsIgnoreCase("OPTIONS");
        w.sTag("html").nl();
        w.sTag("head").nl();
        String cssUrl = s.getCssUrl();
        if (cssUrl == null) {
            cssUrl = op.getString(REST_relativeServletURI) + "/style.css";
        }
        w.oTag(1, "style").attr("type", "text/css").appendln(">").append(2, "@import ").q().append(cssUrl).q().appendln(";");
        if (s.isNoWrap()) {
            w.appendln("\n* {white-space:nowrap;}");
        }
        if (s.getCssImports() != null) {
            for (String cssImport : s.getCssImports()) {
                w.append(2, "@import ").q().append(cssImport).q().appendln(";");
            }
        }
        w.eTag(1, "style").nl();
        w.eTag("head").nl();
        w.sTag("body").nl();
        String title = s.getTitle();
        if (title == null && isOptionsPage) {
            title = "Options";
        }
        String description = s.getText();
        if (title != null) {
            w.oTag(1, "h3").attr("class", "title").append('>').text(title).eTag("h3").nl();
        }
        if (description != null) {
            w.oTag(1, "h5").attr("class", "description").append('>').text(description).eTag("h5").nl();
        }
        LinkedList<Link> actions = new LinkedList<Link>();
        if (!isOptionsPage && (htmlLinks = s.getLinks()) != null) {
            for (Map.Entry<String, String> e : htmlLinks.entrySet()) {
                String uri = e.getValue();
                if (uri.indexOf("://") == -1 && !StringUtils.startsWith(uri, '/')) {
                    StringBuilder sb = new StringBuilder(op.getString(REST_relativeServletURI));
                    if (!uri.isEmpty() && uri.charAt(0) != '?' && uri.charAt(0) != '/') {
                        sb.append('/');
                    }
                    sb.append(uri);
                    uri = sb.toString();
                }
                actions.add(new Link(e.getKey(), uri, new Object[0]));
            }
        }
        if (actions.size() > 0) {
            w.oTag(1, "p").attr("class", "links").append('>').nl();
            Iterator i = actions.iterator();
            while (i.hasNext()) {
                Link h = (Link)i.next();
                w.oTag(2, "a").attr("class", "link").attr("href", (Object)h.getHref(), true).append('>').append(h.getName()).eTag("a").nl();
                if (!i.hasNext()) continue;
                w.append(3, " - ").nl();
            }
            w.eTag(1, "p").nl();
        }
        s.indent = 3;
        w.oTag(1, "div").attr("class", "outerdata").append('>').nl();
        w.oTag(2, "div").attr("class", "data").attr("id", "data").append('>').nl();
        if (HtmlDocSerializer.isEmptyList(o)) {
            w.oTag(3, "p").append('>').append("no results").eTag("p");
        } else {
            super.doSerialize(s, o);
        }
        w.eTag(2, "div").nl();
        w.eTag(1, "div").nl();
        w.eTag("body").nl().eTag("html").nl();
    }

    private static boolean isEmptyList(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Collection && ((Collection)o).size() == 0) {
            return true;
        }
        return o.getClass().isArray() && Array.getLength(o) == 0;
    }
}

