/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyMetaExtended;
import org.apache.juneau.html.annotation.Html;

public class HtmlBeanPropertyMeta
extends BeanPropertyMetaExtended {
    private boolean asXml;
    private boolean noTables;
    private boolean noTableHeaders;
    private boolean asPlainText;

    public HtmlBeanPropertyMeta(BeanPropertyMeta bpm) {
        super(bpm);
        if (bpm.getField() != null) {
            this.findHtmlInfo(bpm.getField().getAnnotation(Html.class));
        }
        if (bpm.getGetter() != null) {
            this.findHtmlInfo(bpm.getGetter().getAnnotation(Html.class));
        }
        if (bpm.getSetter() != null) {
            this.findHtmlInfo(bpm.getSetter().getAnnotation(Html.class));
        }
    }

    private void findHtmlInfo(Html html) {
        if (html == null) {
            return;
        }
        if (html.asXml()) {
            this.asXml = html.asXml();
        }
        if (html.noTables()) {
            this.noTables = html.noTables();
        }
        if (html.noTableHeaders()) {
            this.noTableHeaders = html.noTableHeaders();
        }
        if (html.asPlainText()) {
            this.asPlainText = html.asPlainText();
        }
    }

    protected boolean isAsXml() {
        return this.asXml;
    }

    protected boolean isAsPlainText() {
        return this.asPlainText;
    }

    protected boolean isNoTables() {
        return this.noTables;
    }

    public boolean isNoTableHeaders() {
        return this.noTableHeaders;
    }
}

