/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.encoders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.MediaRange;
import org.apache.juneau.MediaType;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderMatch;

public final class EncoderGroup {
    private final Map<String, EncoderMatch> cache = new ConcurrentHashMap<String, EncoderMatch>();
    final Encoder[] encoders;

    public EncoderGroup(Encoder[] encoders) {
        this.encoders = Arrays.copyOf(encoders, encoders.length);
    }

    public EncoderMatch getEncoderMatch(String acceptEncoding) {
        if (this.encoders.length == 0) {
            return null;
        }
        EncoderMatch em = this.cache.get(acceptEncoding);
        if (em != null) {
            return em;
        }
        MediaRange[] ae = MediaRange.parse(acceptEncoding);
        if (ae.length == 0) {
            ae = MediaRange.parse("*/*");
        }
        TreeMap m = null;
        for (MediaRange a : ae) {
            for (Encoder e : this.encoders) {
                for (String c : e.getCodings()) {
                    MediaType mt = MediaType.forString(c);
                    float q = a.matches(mt);
                    if (q == 1.0f) {
                        em = new EncoderMatch(mt, e);
                        this.cache.put(acceptEncoding, em);
                        return em;
                    }
                    if (!(q > 0.0f)) continue;
                    if (m == null) {
                        m = new TreeMap(Collections.reverseOrder());
                    }
                    m.put(Float.valueOf(q), new EncoderMatch(mt, e));
                }
            }
        }
        return m == null ? null : (EncoderMatch)m.values().iterator().next();
    }

    public Encoder getEncoder(String coding) {
        EncoderMatch em = this.getEncoderMatch(coding);
        return em == null ? null : em.getEncoder();
    }

    public List<String> getSupportedEncodings() {
        ArrayList<String> l = new ArrayList<String>();
        for (Encoder e : this.encoders) {
            for (String enc : e.getCodings()) {
                if (l.contains(enc)) continue;
                l.add(enc);
            }
        }
        return l;
    }
}

