/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.MediaType;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.Info;
import org.apache.juneau.dto.swagger.Operation;
import org.apache.juneau.dto.swagger.ParameterInfo;
import org.apache.juneau.dto.swagger.ResponseInfo;
import org.apache.juneau.dto.swagger.SchemaInfo;
import org.apache.juneau.dto.swagger.SecurityScheme;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.dto.swagger.Tag;
import org.apache.juneau.utils.AMap;

@Bean(properties="swagger,info,tags,externalDocs,basePath,schemes,consumes,produces,paths,definitions,parameters,responses,securityDefinitions,security")
public class Swagger
extends SwaggerElement {
    public static final Swagger NULL = new Swagger();
    private String swagger = "2.0";
    private Info info;
    private String host;
    private String basePath;
    private List<String> schemes;
    private List<MediaType> consumes;
    private List<MediaType> produces;
    private Map<String, Map<String, Operation>> paths;
    private Map<String, SchemaInfo> definitions;
    private Map<String, ParameterInfo> parameters;
    private Map<String, ResponseInfo> responses;
    private Map<String, SecurityScheme> securityDefinitions;
    private List<Map<String, List<String>>> security;
    private List<Tag> tags;
    private ExternalDocumentation externalDocs;

    public String getSwagger() {
        return this.swagger;
    }

    public Swagger setSwagger(String swagger) {
        this.swagger = swagger;
        return this;
    }

    public Swagger swagger(String swagger) {
        return this.setSwagger(swagger);
    }

    public Info getInfo() {
        return this.info;
    }

    public Swagger setInfo(Info info) {
        this.info = info;
        return this;
    }

    public Swagger info(Info info) {
        return this.setInfo(info);
    }

    public String getHost() {
        return this.host;
    }

    public Swagger setHost(String host) {
        this.host = host;
        return this;
    }

    public Swagger host(String host) {
        return this.setHost(host);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public Swagger setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public Swagger basePath(String basePath) {
        return this.setBasePath(basePath);
    }

    public List<String> getSchemes() {
        return this.schemes;
    }

    public Swagger setSchemes(List<String> schemes) {
        this.schemes = schemes;
        return this;
    }

    public Swagger addSchemes(String ... schemes) {
        return this.addSchemes(Arrays.asList(schemes));
    }

    public Swagger addSchemes(Collection<String> schemes) {
        if (schemes != null) {
            if (this.schemes == null) {
                this.schemes = new LinkedList<String>();
            }
            this.schemes.addAll(schemes);
        }
        return this;
    }

    public Swagger schemes(String ... schemes) {
        return this.addSchemes(schemes);
    }

    public List<MediaType> getConsumes() {
        return this.consumes;
    }

    public Swagger setConsumes(List<MediaType> consumes) {
        this.consumes = consumes;
        return this;
    }

    public Swagger addConsumes(MediaType ... consumes) {
        return this.addConsumes(Arrays.asList(consumes));
    }

    public Swagger addConsumes(Collection<MediaType> consumes) {
        if (consumes != null) {
            if (this.consumes == null) {
                this.consumes = new LinkedList<MediaType>();
            }
            this.consumes.addAll(consumes);
        }
        return this;
    }

    public Swagger consumes(MediaType ... consumes) {
        return this.addConsumes(consumes);
    }

    public Swagger consumes(Collection<MediaType> consumes) {
        return this.addConsumes(consumes);
    }

    public List<MediaType> getProduces() {
        return this.produces;
    }

    public Swagger setProduces(List<MediaType> produces) {
        this.produces = produces;
        return this;
    }

    public Swagger addProduces(MediaType ... produces) {
        return this.addProduces(Arrays.asList(produces));
    }

    public Swagger addProduces(Collection<MediaType> produces) {
        if (produces != null) {
            if (this.produces == null) {
                this.produces = new LinkedList<MediaType>();
            }
            this.produces.addAll(produces);
        }
        return this;
    }

    public Swagger produces(MediaType ... produces) {
        return this.addProduces(produces);
    }

    public Swagger produces(Collection<MediaType> produces) {
        return this.addProduces(produces);
    }

    public Map<String, Map<String, Operation>> getPaths() {
        return this.paths;
    }

    public Swagger setPaths(Map<String, Map<String, Operation>> paths) {
        this.paths = paths;
        return this;
    }

    public Swagger addPath(String path, String methodName, Operation operation) {
        Map<String, Operation> p;
        if (this.paths == null) {
            this.paths = new TreeMap<String, Map<String, Operation>>();
        }
        if ((p = this.paths.get(path)) == null) {
            p = new TreeMap<String, Operation>(new MethodSorter());
            this.paths.put(path, p);
        }
        p.put(methodName, operation);
        return this;
    }

    public Swagger path(String path, String methodName, Operation operation) {
        return this.addPath(path, methodName, operation);
    }

    public Map<String, SchemaInfo> getDefinitions() {
        return this.definitions;
    }

    public Swagger setDefinitions(Map<String, SchemaInfo> definitions) {
        this.definitions = definitions;
        return this;
    }

    public Swagger addDefinition(String name, SchemaInfo schema) {
        if (this.definitions == null) {
            this.definitions = new TreeMap<String, SchemaInfo>();
        }
        this.definitions.put(name, schema);
        return this;
    }

    public Swagger xxx(String name, SchemaInfo schema) {
        return this.addDefinition(name, schema);
    }

    public Map<String, ParameterInfo> getParameters() {
        return this.parameters;
    }

    public Swagger setParameters(Map<String, ParameterInfo> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Swagger addParameter(String name, ParameterInfo parameter) {
        if (this.parameters == null) {
            this.parameters = new TreeMap<String, ParameterInfo>();
        }
        this.parameters.put(name, parameter);
        return this;
    }

    public Swagger parameter(String name, ParameterInfo parameter) {
        return this.addParameter(name, parameter);
    }

    public Map<String, ResponseInfo> getResponses() {
        return this.responses;
    }

    public Swagger setResponses(Map<String, ResponseInfo> responses) {
        this.responses = responses;
        return this;
    }

    public Swagger addResponse(String name, ResponseInfo response) {
        if (this.responses == null) {
            this.responses = new TreeMap<String, ResponseInfo>();
        }
        this.responses.put(name, response);
        return this;
    }

    public Swagger response(String name, ResponseInfo response) {
        return this.addResponse(name, response);
    }

    public Map<String, SecurityScheme> getSecurityDefinitions() {
        return this.securityDefinitions;
    }

    public Swagger setSecurityDefinitions(Map<String, SecurityScheme> securityDefinitions) {
        this.securityDefinitions = securityDefinitions;
        return this;
    }

    public Swagger addSecurityDefinition(String name, SecurityScheme securityScheme) {
        if (this.securityDefinitions == null) {
            this.securityDefinitions = new TreeMap<String, SecurityScheme>();
        }
        this.securityDefinitions.put(name, securityScheme);
        return this;
    }

    public Swagger securityDefinition(String name, SecurityScheme securityScheme) {
        return this.addSecurityDefinition(name, securityScheme);
    }

    public List<Map<String, List<String>>> getSecurity() {
        return this.security;
    }

    public Swagger setSecurity(List<Map<String, List<String>>> security) {
        this.security = security;
        return this;
    }

    public Swagger addSecurity(Map<String, List<String>> security) {
        if (this.security == null) {
            this.security = new LinkedList<Map<String, List<String>>>();
        }
        this.security.add(security);
        return this;
    }

    public Swagger security(String scheme, String ... alternatives) {
        LinkedHashMap<String, List<String>> m = new LinkedHashMap<String, List<String>>();
        m.put(scheme, Arrays.asList(alternatives));
        return this.addSecurity(m);
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public Swagger setTags(List<Tag> tags) {
        this.tags = tags;
        return this;
    }

    public Swagger addTags(Tag ... tags) {
        if (this.tags == null) {
            this.tags = new LinkedList<Tag>();
        }
        this.tags.addAll(Arrays.asList(tags));
        return this;
    }

    public Swagger tags(Tag ... tags) {
        return this.addTags(tags);
    }

    public Swagger tags(List<Tag> tags) {
        return this.setTags(tags);
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public Swagger setExternalDocs(ExternalDocumentation externalDocs) {
        this.externalDocs = externalDocs;
        return this;
    }

    public Swagger externalDocs(ExternalDocumentation externalDocs) {
        return this.setExternalDocs(externalDocs);
    }

    private static class MethodSorter
    implements Comparator<String> {
        private final Map<String, Integer> methods = new AMap<String, Integer>().append("get", 7).append("put", 6).append("post", 5).append("delete", 4).append("options", 3).append("head", 2).append("patch", 1);

        private MethodSorter() {
        }

        @Override
        public int compare(String o1, String o2) {
            Integer i1 = this.methods.get(o1);
            Integer i2 = this.methods.get(o2);
            if (i1 == null) {
                i1 = 0;
            }
            if (i2 == null) {
                i2 = 0;
            }
            return i2.compareTo(i1);
        }
    }
}

