/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.json.JsonSerializer;

@Bean(properties="type,description,name,in,flow,authorizationUrl,tokenUrl,scopes")
public class SecurityScheme
extends SwaggerElement {
    private static final String[] VALID_TYPES = new String[]{"basic", "apiKey", "oauth2"};
    private String type;
    private String description;
    private String name;
    private String in;
    private String flow;
    private String authorizationUrl;
    private String tokenUrl;
    private Map<String, String> scopes;

    @Override
    protected SecurityScheme strict() {
        super.strict();
        return this;
    }

    public String getType() {
        return this.type;
    }

    public SecurityScheme setType(String type) {
        if (this.isStrict() && !ArrayUtils.contains(type, VALID_TYPES)) {
            throw new RuntimeException("Invalid value passed in to setType(String).  Value='" + type + "', valid values=" + JsonSerializer.DEFAULT_LAX.toString(VALID_TYPES));
        }
        this.type = type;
        return this;
    }

    public SecurityScheme type(String type) {
        return this.setType(type);
    }

    public String getDescription() {
        return this.description;
    }

    public SecurityScheme setDescription(String description) {
        this.description = description;
        return this;
    }

    public SecurityScheme description(String description) {
        return this.setDescription(description);
    }

    public String getName() {
        return this.name;
    }

    public SecurityScheme setName(String name) {
        this.name = name;
        return this;
    }

    public SecurityScheme name(String name) {
        return this.setName(name);
    }

    public String getIn() {
        return this.in;
    }

    public SecurityScheme setIn(String in) {
        this.in = in;
        return this;
    }

    public SecurityScheme in(String in) {
        return this.setIn(in);
    }

    public String getFlow() {
        return this.flow;
    }

    public SecurityScheme setFlow(String flow) {
        this.flow = flow;
        return this;
    }

    public SecurityScheme flow(String flow) {
        return this.setFlow(flow);
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public SecurityScheme setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
        return this;
    }

    public SecurityScheme authorizationUrl(String authorizationUrl) {
        return this.setAuthorizationUrl(authorizationUrl);
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public SecurityScheme setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
        return this;
    }

    public SecurityScheme tokenUrl(String tokenUrl) {
        return this.setTokenUrl(tokenUrl);
    }

    public Map<String, String> getScopes() {
        return this.scopes;
    }

    public SecurityScheme setScopes(Map<String, String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public SecurityScheme addScope(String name, String description) {
        if (this.scopes == null) {
            this.scopes = new TreeMap<String, String>();
        }
        this.scopes.put(name, description);
        return this;
    }

    public SecurityScheme scope(String name, String description) {
        return this.addScope(name, description);
    }
}

