/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.atom;

import java.util.Calendar;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.juneau.dto.atom.Category;
import org.apache.juneau.dto.atom.Common;
import org.apache.juneau.dto.atom.Id;
import org.apache.juneau.dto.atom.Link;
import org.apache.juneau.dto.atom.Person;
import org.apache.juneau.dto.atom.Text;
import org.apache.juneau.dto.atom.Utils;
import org.apache.juneau.transforms.CalendarSwap;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;

public class CommonEntry
extends Common {
    private Person[] authors;
    private Category[] categories;
    private Person[] contributors;
    private Id id;
    private Link[] links;
    private Text rights;
    private Text title;
    private Calendar updated;

    public CommonEntry(Id id, Text title, Calendar updated) {
        this.id(id).title(title).updated(updated);
    }

    public CommonEntry(String id, String title, String updated) {
        this.id(id).title(title).updated(updated);
    }

    public CommonEntry() {
    }

    @Xml(format=XmlFormat.COLLAPSED, childName="author")
    public Person[] getAuthors() {
        return this.authors;
    }

    @BeanProperty(name="authors")
    public CommonEntry authors(Person ... authors) {
        this.authors = authors;
        return this;
    }

    @Xml(format=XmlFormat.COLLAPSED, childName="category")
    public Category[] getCatetories() {
        return this.categories;
    }

    @BeanProperty(name="categories")
    public CommonEntry categories(Category ... categories) {
        this.categories = categories;
        return this;
    }

    @Xml(format=XmlFormat.COLLAPSED, childName="contributor")
    public Person[] getContributors() {
        return this.contributors;
    }

    @BeanProperty(name="contributors")
    public CommonEntry contributors(Person ... contributors) {
        this.contributors = contributors;
        return this;
    }

    public Id getId() {
        return this.id;
    }

    @BeanProperty(name="id")
    public CommonEntry id(Id id) {
        this.id = id;
        return this;
    }

    public CommonEntry id(String id) {
        this.id = new Id(id);
        return this;
    }

    @Xml(format=XmlFormat.COLLAPSED)
    public Link[] getLinks() {
        return this.links;
    }

    @BeanProperty(name="links")
    public CommonEntry links(Link ... links) {
        this.links = links;
        return this;
    }

    public Text getRights() {
        return this.rights;
    }

    @BeanProperty(name="rights")
    public CommonEntry rights(Text rights) {
        this.rights = rights;
        return this;
    }

    public CommonEntry rights(String rights) {
        this.rights = new Text().text(rights);
        return this;
    }

    public Text getTitle() {
        return this.title;
    }

    @BeanProperty(name="title")
    public CommonEntry title(Text title) {
        this.title = title;
        return this;
    }

    public CommonEntry title(String title) {
        this.title = new Text().text(title);
        return this;
    }

    @BeanProperty(swap=CalendarSwap.ISO8601DT.class)
    public Calendar getUpdated() {
        return this.updated;
    }

    @BeanProperty(name="updated")
    public CommonEntry updated(Calendar updated) {
        this.updated = updated;
        return this;
    }

    @BeanProperty(name="updated")
    public CommonEntry updated(String updated) {
        this.updated = Utils.parseDateTime(updated);
        return this;
    }
}

