/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.annotation.BeanIgnore;

@BeanIgnore
public final class MediaType {
    private static final ConcurrentHashMap<String, MediaType> cache = new ConcurrentHashMap();
    public static final MediaType CSV = MediaType.forString("text/csv");
    public static final MediaType HTML = MediaType.forString("text/html");
    public static final MediaType JSON = MediaType.forString("application/json");
    public static final MediaType MSGPACK = MediaType.forString("octal/msgpack");
    public static final MediaType PLAIN = MediaType.forString("text/plain");
    public static final MediaType UON = MediaType.forString("text/uon");
    public static final MediaType URLENCODING = MediaType.forString("application/x-www-form-urlencoded");
    public static final MediaType XML = MediaType.forString("text/xml");
    public static final MediaType XMLSOAP = MediaType.forString("text/xml+soap");
    public static final MediaType RDF = MediaType.forString("text/xml+rdf");
    public static final MediaType RDFABBREV = MediaType.forString("text/xml+rdf+abbrev");
    public static final MediaType NTRIPLE = MediaType.forString("text/n-triple");
    public static final MediaType TURTLE = MediaType.forString("text/turtle");
    public static final MediaType N3 = MediaType.forString("text/n3");
    private final String mediaType;
    private final String type;
    private final String subType;

    public static MediaType forString(String s) {
        if (s == null) {
            return null;
        }
        MediaType mt = cache.get(s);
        if (mt == null) {
            mt = new MediaType(s);
            cache.putIfAbsent(s, mt);
        }
        return cache.get(s);
    }

    private MediaType(String mt) {
        int i = mt.indexOf(59);
        if (i != -1) {
            mt = mt.substring(0, i);
        }
        this.mediaType = mt = mt.toLowerCase(Locale.ENGLISH);
        String _type = null;
        String _subType = null;
        if (mt != null) {
            i = (mt = mt.replace(' ', '+')).indexOf(47);
            _type = i == -1 ? mt : mt.substring(0, i);
            _subType = i == -1 ? "*" : mt.substring(i + 1);
        }
        this.type = _type;
        this.subType = _subType;
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public final boolean matches(MediaType o) {
        if (this == o) {
            return true;
        }
        return !(!this.type.equals(o.type) && !this.type.equals("*") && !o.type.equals("*") || !this.subType.equals(o.subType) && !this.subType.equals("*") && !o.subType.equals("*"));
    }

    public String toString() {
        return this.mediaType;
    }

    public int hashCode() {
        return this.mediaType.hashCode();
    }

    public boolean equals(Object o) {
        return this == o;
    }
}

