/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.text.MessageFormat;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.json.JsonSerializer;

public final class InvalidDataConversionException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public InvalidDataConversionException(Object value, Class<?> toType, Exception cause) {
        super(MessageFormat.format("Invalid data conversion from type ''{0}'' to type ''{1}''.  Value={2}.", ClassUtils.getReadableClassNameForObject(value), ClassUtils.getReadableClassName(toType), InvalidDataConversionException.getValue(value)), cause);
    }

    public InvalidDataConversionException(Object value, ClassMeta<?> toType, Exception cause) {
        super(MessageFormat.format("Invalid data conversion from type ''{0}'' to type ''{1}''.  Value={2}.", ClassUtils.getReadableClassNameForObject(value), toType.toString(), InvalidDataConversionException.getValue(value)), cause);
    }

    private static String getValue(Object o) {
        if (o instanceof Class) {
            return "'" + ClassUtils.getReadableClassName((Class)o) + "'";
        }
        return JsonSerializer.DEFAULT_LAX == null ? "'" + o.toString() + "'" : JsonSerializer.DEFAULT_LAX.toString(o);
    }
}

