/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanMetaFiltered;
import org.apache.juneau.BeanPropertyMetaExtended;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.juneau.annotation.Null;
import org.apache.juneau.annotation.URI;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.DelegateList;
import org.apache.juneau.internal.FilteredMap;
import org.apache.juneau.internal.ReflectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.utils.MetadataMap;

public class BeanPropertyMeta {
    final BeanMeta<?> beanMeta;
    private final BeanContext beanContext;
    private final String name;
    private final Field field;
    private final Method getter;
    private final Method setter;
    private final boolean isUri;
    private final ClassMeta<?> rawTypeMeta;
    private final ClassMeta<?> typeMeta;
    private final String[] properties;
    private final PojoSwap swap;
    private final MetadataMap extMeta = new MetadataMap();
    private final BeanRegistry beanRegistry;
    private final Object overrideValue;
    private final BeanPropertyMeta delegateFor;

    protected BeanPropertyMeta(Builder b) {
        this.field = b.field;
        this.getter = b.getter;
        this.setter = b.setter;
        this.isUri = b.isUri;
        this.beanMeta = b.beanMeta;
        this.beanContext = b.beanContext;
        this.name = b.name;
        this.rawTypeMeta = b.rawTypeMeta;
        this.typeMeta = b.typeMeta;
        this.properties = b.properties;
        this.swap = b.swap;
        this.beanRegistry = b.beanRegistry;
        this.overrideValue = b.overrideValue;
        this.delegateFor = b.delegateFor;
    }

    public String getName() {
        return this.name;
    }

    @BeanIgnore
    public BeanMeta<?> getBeanMeta() {
        return this.beanMeta;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public Field getField() {
        return this.field;
    }

    public ClassMeta<?> getClassMeta() {
        return this.typeMeta;
    }

    public BeanRegistry getBeanRegistry() {
        return this.beanRegistry;
    }

    public boolean isUri() {
        return this.isUri;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public <M extends BeanPropertyMetaExtended> M getExtendedMeta(Class<M> c) {
        if (this.delegateFor != null) {
            return this.delegateFor.getExtendedMeta(c);
        }
        return (M)((BeanPropertyMetaExtended)this.extMeta.get(c, this));
    }

    public Object get(BeanMap<?> m) {
        try {
            if (this.overrideValue != null) {
                return this.overrideValue;
            }
            Object bean = m.bean;
            if (bean == null) {
                return m.propertyCache.get(this.name);
            }
            Object o = null;
            if (this.getter == null && this.field == null) {
                throw new BeanRuntimeException(this.beanMeta.c, "Getter or public field not defined on property ''{0}''", this.name);
            }
            if (this.getter != null) {
                o = this.getter.invoke(bean, (Object[])null);
            } else if (this.field != null) {
                o = this.field.get(bean);
            }
            return this.toSerializedForm(m.getBeanSession(), o);
        }
        catch (Throwable e) {
            if (this.beanContext.ignoreInvocationExceptionsOnGetters) {
                if (this.rawTypeMeta.isPrimitive()) {
                    return this.rawTypeMeta.getPrimitiveDefault();
                }
                return null;
            }
            throw new BeanRuntimeException(this.beanMeta.c, "Exception occurred while getting property ''{0}''", this.name).initCause(e);
        }
    }

    final Object toSerializedForm(BeanSession session, Object o) {
        try {
            o = this.transform(session, o);
            if (o == null) {
                return null;
            }
            if (this.properties != null) {
                if (this.rawTypeMeta.isArray()) {
                    Object[] a = (Object[])o;
                    DelegateList l = new DelegateList(this.rawTypeMeta);
                    ClassMeta<?> childType = this.rawTypeMeta.getElementType();
                    for (Object c : a) {
                        l.add(this.applyChildPropertiesFilter(session, childType, c));
                    }
                    return l;
                }
                if (this.rawTypeMeta.isCollection()) {
                    Collection c = (Collection)o;
                    ArrayList<Object> l = new ArrayList<Object>(c.size());
                    ClassMeta<?> childType = this.rawTypeMeta.getElementType();
                    for (Object cc : c) {
                        l.add(this.applyChildPropertiesFilter(session, childType, cc));
                    }
                    return l;
                }
                return this.applyChildPropertiesFilter(session, this.rawTypeMeta, o);
            }
            return o;
        }
        catch (SerializeException e) {
            throw new BeanRuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object set(BeanMap<?> m, Object value) throws BeanRuntimeException {
        try {
            BeanSession session = m.getBeanSession();
            value = this.unswap(session, value);
            if (m.bean == null) {
                if (m.propertyCache == null) throw new BeanRuntimeException("Non-existent bean instance on bean.");
                return m.propertyCache.put(this.name, value);
            }
            boolean isMap = this.rawTypeMeta.isMap();
            boolean isCollection = this.rawTypeMeta.isCollection();
            if (this.field == null && this.setter == null && !isMap && !isCollection) {
                if ((value != null || !this.beanContext.ignoreUnknownNullBeanProperties) && !this.beanContext.ignorePropertiesWithoutSetters) throw new BeanRuntimeException(this.beanMeta.c, "Setter or public field not defined on property ''{0}''", this.name);
                return null;
            }
            Object bean = m.getBean(true);
            try {
                Object r = this.beanContext.beanMapPutReturnsOldValue || isMap || isCollection ? this.get(m) : null;
                Class<?> propertyClass = this.rawTypeMeta.getInnerClass();
                if (value == null && (isMap || isCollection)) {
                    if (this.setter != null) {
                        this.setter.invoke(bean, new Object[]{null});
                        return r;
                    }
                    if (this.field == null) throw new BeanRuntimeException(this.beanMeta.c, "Cannot set property ''{0}'' to null because no setter or public field is defined", this.name);
                    this.field.set(bean, null);
                    return r;
                }
                if (isMap) {
                    if (!(value instanceof Map)) {
                        if (!(value instanceof CharSequence)) throw new BeanRuntimeException(this.beanMeta.c, "Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}''", this.name, propertyClass.getName(), BeanPropertyMeta.findClassName(value));
                        value = new ObjectMap((CharSequence)value).setBeanSession(session);
                    }
                    Map valueMap = (Map)value;
                    Map propMap = (Map)r;
                    ClassMeta<?> valueType = this.rawTypeMeta.getValueType();
                    if (!this.rawTypeMeta.canCreateNewInstance()) {
                        if (propMap == null) {
                            if (this.setter == null && this.field == null) {
                                throw new BeanRuntimeException(this.beanMeta.c, "Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}'' because no setter or public field is defined, and the current value is null", this.name, propertyClass.getName(), BeanPropertyMeta.findClassName(value));
                            }
                            if (!propertyClass.isInstance(valueMap)) throw new BeanRuntimeException(this.beanMeta.c, "Cannot set property ''{0}'' of type ''{2}'' to object of type ''{2}'' because the assigned map cannot be converted to the specified type because the property type is abstract, and the property value is currently null", this.name, propertyClass.getName(), BeanPropertyMeta.findClassName(value));
                            if (!valueType.isObject()) {
                                for (Map.Entry entry : valueMap.entrySet()) {
                                    Object v = entry.getValue();
                                    if (v == null || valueType.getInnerClass().isInstance(v)) continue;
                                    throw new BeanRuntimeException(this.beanMeta.c, "Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}'' because the value types in the assigned map do not match the specified ''elementClass'' attribute on the property, and the property value is currently null", this.name, propertyClass.getName(), BeanPropertyMeta.findClassName(value));
                                }
                            }
                            if (this.setter != null) {
                                this.setter.invoke(bean, valueMap);
                                return r;
                            } else {
                                this.field.set(bean, valueMap);
                            }
                            return r;
                        }
                    } else if (propMap == null) {
                        propMap = (Map)propertyClass.newInstance();
                        if (this.setter != null) {
                            this.setter.invoke(bean, propMap);
                        } else {
                            if (this.field == null) throw new BeanRuntimeException(this.beanMeta.c, "Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}'' because no setter or public field is defined on this property, and the existing property value is null", this.name, propertyClass.getName(), BeanPropertyMeta.findClassName(value));
                            this.field.set(bean, propMap);
                        }
                    } else {
                        propMap.clear();
                    }
                    for (Map.Entry entry : valueMap.entrySet()) {
                        void var15_31;
                        Object k = entry.getKey();
                        Object v = entry.getValue();
                        if (!valueType.isObject()) {
                            Object obj = session.convertToType(v, valueType);
                        }
                        propMap.put(k, var15_31);
                    }
                    return r;
                } else if (isCollection) {
                    if (!(value instanceof Collection)) {
                        if (!(value instanceof CharSequence)) throw new BeanRuntimeException(this.beanMeta.c, "Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}''", this.name, propertyClass.getName(), BeanPropertyMeta.findClassName(value));
                        value = new ObjectList((CharSequence)value).setBeanSession(session);
                    }
                    Collection valueList = (Collection)value;
                    Collection propList = (Collection)r;
                    ClassMeta<?> elementType = this.rawTypeMeta.getElementType();
                    if (!this.rawTypeMeta.canCreateNewInstance()) {
                        if (propList == null) {
                            if (this.setter == null && this.field == null) {
                                throw new BeanRuntimeException(this.beanMeta.c, "Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}'' because no setter or public field is defined, and the current value is null", this.name, propertyClass.getName(), BeanPropertyMeta.findClassName(value));
                            }
                            if (!propertyClass.isInstance(valueList)) throw new BeanRuntimeException(this.beanMeta.c, "Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}'' because the assigned map cannot be converted to the specified type because the property type is abstract, and the property value is currently null", this.name, propertyClass.getName(), BeanPropertyMeta.findClassName(value));
                            if (!elementType.isObject()) {
                                ObjectList l = new ObjectList((Collection<?>)valueList);
                                ListIterator<?> listIterator = l.listIterator();
                                while (listIterator.hasNext()) {
                                    Object v = listIterator.next();
                                    if (v == null || elementType.getInnerClass().isInstance(v)) continue;
                                    listIterator.set(session.convertToType(v, elementType));
                                }
                                valueList = l;
                            }
                            if (this.setter != null) {
                                this.setter.invoke(bean, valueList);
                                return r;
                            } else {
                                this.field.set(bean, valueList);
                            }
                            return r;
                        }
                        propList.clear();
                    } else if (propList == null) {
                        propList = (Collection)propertyClass.newInstance();
                        if (this.setter != null) {
                            this.setter.invoke(bean, propList);
                        } else {
                            if (this.field == null) throw new BeanRuntimeException(this.beanMeta.c, "Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}'' because no setter is defined on this property, and the existing property value is null", this.name, propertyClass.getName(), BeanPropertyMeta.findClassName(value));
                            this.field.set(bean, propList);
                        }
                    } else {
                        propList.clear();
                    }
                    for (Object e : valueList) {
                        void var13_25;
                        if (!elementType.isObject()) {
                            Object obj = session.convertToType(e, elementType);
                        }
                        propList.add(var13_25);
                    }
                    return r;
                } else {
                    value = this.swap != null && value != null && ClassUtils.isParentClass(this.swap.getSwapClass(), value.getClass()) ? this.swap.unswap(session, value, this.rawTypeMeta) : session.convertToType(value, this.rawTypeMeta);
                    if (this.setter != null) {
                        this.setter.invoke(bean, value);
                        return r;
                    } else {
                        if (this.field == null) return r;
                        this.field.set(bean, value);
                    }
                }
                return r;
            }
            catch (BeanRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!this.beanContext.ignoreInvocationExceptionsOnSetters) throw new BeanRuntimeException(this.beanMeta.c, "Error occurred trying to set property ''{0}''", this.name).initCause(e);
                if (!this.rawTypeMeta.isPrimitive()) return null;
                return this.rawTypeMeta.getPrimitiveDefault();
            }
        }
        catch (ParseException e) {
            throw new BeanRuntimeException(e);
        }
    }

    protected void setArray(Object bean, List l) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object array = ArrayUtils.toArray(l, this.rawTypeMeta.getElementType().getInnerClass());
        if (this.setter != null) {
            this.setter.invoke(bean, array);
        } else if (this.field != null) {
            this.field.set(bean, array);
        } else {
            throw new BeanRuntimeException(this.beanMeta.c, "Attempt to initialize array property ''{0}'', but no setter or field defined.", this.name);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(BeanMap<?> m, Object value) throws BeanRuntimeException {
        if (m.bean == null) {
            if (!m.propertyCache.containsKey(this.name)) {
                m.propertyCache.put(this.name, new ObjectList(m.getBeanSession()));
            }
            ((ObjectList)m.propertyCache.get(this.name)).add(value);
            return;
        }
        BeanSession session = m.getBeanSession();
        boolean isCollection = this.rawTypeMeta.isCollection();
        boolean isArray = this.rawTypeMeta.isArray();
        if (!isCollection && !isArray) {
            throw new BeanRuntimeException(this.beanMeta.c, "Attempt to add element to property ''{0}'' which is not a collection or array", this.name);
        }
        Object bean = m.getBean(true);
        ClassMeta<?> elementType = this.rawTypeMeta.getElementType();
        try {
            Object v = session.convertToType(value, elementType);
            if (isCollection) {
                Collection c = null;
                if (this.getter != null) {
                    c = (Collection)this.getter.invoke(bean, (Object[])null);
                } else {
                    if (this.field == null) throw new BeanRuntimeException(this.beanMeta.c, "Attempt to append to collection property ''{0}'', but no getter or field defined.", this.name);
                    c = (Collection)this.field.get(bean);
                }
                if (c != null) {
                    c.add(v);
                    return;
                }
                c = this.rawTypeMeta.canCreateNewInstance() ? (Collection)this.rawTypeMeta.newInstance() : new ObjectList(session);
                c.add(v);
                if (this.setter != null) {
                    this.setter.invoke(bean, c);
                    return;
                } else {
                    if (this.field == null) throw new BeanRuntimeException(this.beanMeta.c, "Attempt to initialize collection property ''{0}'', but no setter or field defined.", this.name);
                    this.field.set(bean, c);
                }
                return;
            } else {
                List<?> l;
                if (m.arrayPropertyCache == null) {
                    m.arrayPropertyCache = new TreeMap();
                }
                if ((l = m.arrayPropertyCache.get(this.name)) == null) {
                    Object oldArray;
                    l = new LinkedList();
                    m.arrayPropertyCache.put(this.name, l);
                    if (this.getter != null) {
                        oldArray = this.getter.invoke(bean, (Object[])null);
                    } else {
                        if (this.field == null) throw new BeanRuntimeException(this.beanMeta.c, "Attempt to append to array property ''{0}'', but no getter or field defined.", this.name);
                        oldArray = this.field.get(bean);
                    }
                    ArrayUtils.copyToList(oldArray, l);
                }
                l.add(v);
            }
            return;
        }
        catch (BeanRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanRuntimeException(e);
        }
    }

    public void add(BeanMap<?> m, String key, Object value) throws BeanRuntimeException {
        block22: {
            if (m.bean == null) {
                if (!m.propertyCache.containsKey(this.name)) {
                    m.propertyCache.put(this.name, new ObjectMap(m.getBeanSession()));
                }
                ((ObjectMap)m.propertyCache.get(this.name)).append(key.toString(), value);
                return;
            }
            BeanSession session = m.getBeanSession();
            boolean isMap = this.rawTypeMeta.isMap();
            boolean isBean = this.rawTypeMeta.isBean();
            if (!isBean && !isMap) {
                throw new BeanRuntimeException(this.beanMeta.c, "Attempt to add key/value to property ''{0}'' which is not a map or bean", this.name);
            }
            Object bean = m.getBean(true);
            ClassMeta<?> elementType = this.rawTypeMeta.getElementType();
            try {
                Object v = session.convertToType(value, elementType);
                if (isMap) {
                    Map map = null;
                    if (this.getter != null) {
                        map = (Map)this.getter.invoke(bean, (Object[])null);
                    } else if (this.field != null) {
                        map = (Map)this.field.get(bean);
                    } else {
                        throw new BeanRuntimeException(this.beanMeta.c, "Attempt to append to map property ''{0}'', but no getter or field defined.", this.name);
                    }
                    if (map != null) {
                        map.put(key, v);
                        return;
                    }
                    map = this.rawTypeMeta.canCreateNewInstance() ? (Map)this.rawTypeMeta.newInstance() : new ObjectMap(session);
                    map.put(key, v);
                    if (this.setter != null) {
                        this.setter.invoke(bean, map);
                        break block22;
                    }
                    if (this.field != null) {
                        this.field.set(bean, map);
                        break block22;
                    }
                    throw new BeanRuntimeException(this.beanMeta.c, "Attempt to initialize map property ''{0}'', but no setter or field defined.", this.name);
                }
                Object b = null;
                if (this.getter != null) {
                    b = this.getter.invoke(bean, (Object[])null);
                } else if (this.field != null) {
                    b = this.field.get(bean);
                } else {
                    throw new BeanRuntimeException(this.beanMeta.c, "Attempt to append to bean property ''{0}'', but no getter or field defined.", this.name);
                }
                if (b != null) {
                    BeanMap<Object> bm = session.toBeanMap(b);
                    bm.put(key, v);
                    return;
                }
                if (this.rawTypeMeta.canCreateNewInstance(m.getBean(false))) {
                    b = this.rawTypeMeta.newInstance();
                    BeanMap<Object> bm = session.toBeanMap(b);
                    bm.put(key, v);
                }
                if (this.setter != null) {
                    this.setter.invoke(bean, b);
                    break block22;
                }
                if (this.field != null) {
                    this.field.set(bean, b);
                    break block22;
                }
                throw new BeanRuntimeException(this.beanMeta.c, "Attempt to initialize bean property ''{0}'', but no setter or field defined.", this.name);
            }
            catch (BeanRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BeanRuntimeException(e);
            }
        }
    }

    public <A extends Annotation> List<A> findAnnotations(Class<A> a) {
        LinkedList l = new LinkedList();
        if (this.field != null) {
            CollectionUtils.addIfNotNull(l, this.field.getAnnotation(a));
            ReflectionUtils.appendAnnotations(a, this.field.getType(), l);
        }
        if (this.getter != null) {
            CollectionUtils.addIfNotNull(l, this.getter.getAnnotation(a));
            ReflectionUtils.appendAnnotations(a, this.getter.getReturnType(), l);
        }
        if (this.setter != null) {
            CollectionUtils.addIfNotNull(l, this.setter.getAnnotation(a));
            ReflectionUtils.appendAnnotations(a, this.setter.getReturnType(), l);
        }
        ReflectionUtils.appendAnnotations(a, this.getBeanMeta().getClassMeta().getInnerClass(), l);
        return l;
    }

    private Object transform(BeanSession session, Object o) throws SerializeException {
        PojoSwap<?, ?> f;
        if (this.swap != null) {
            return this.swap.swap(session, o);
        }
        if (o == null) {
            return null;
        }
        if (this.rawTypeMeta.hasChildPojoSwaps() && (f = this.rawTypeMeta.getChildPojoSwapForSwap(o.getClass())) != null) {
            return f.swap(session, o);
        }
        return o;
    }

    private Object unswap(BeanSession session, Object o) throws ParseException {
        PojoSwap<?, ?> f;
        if (this.swap != null) {
            return this.swap.unswap(session, o, this.rawTypeMeta);
        }
        if (o == null) {
            return null;
        }
        if (this.rawTypeMeta.hasChildPojoSwaps() && (f = this.rawTypeMeta.getChildPojoSwapForUnswap(o.getClass())) != null) {
            return f.unswap(session, o, this.rawTypeMeta);
        }
        return o;
    }

    private Object applyChildPropertiesFilter(BeanSession session, ClassMeta cm, Object o) {
        if (o == null) {
            return null;
        }
        if (cm.isBean()) {
            return new BeanMap<Object>(session, o, new BeanMetaFiltered(cm.getBeanMeta(), this.properties));
        }
        if (cm.isMap()) {
            return new FilteredMap(cm, (Map)o, this.properties);
        }
        if (cm.isObject()) {
            if (o instanceof Map) {
                return new FilteredMap(cm, (Map)o, this.properties);
            }
            BeanMeta<?> bm = this.beanContext.getBeanMeta(o.getClass());
            if (bm != null) {
                return new BeanMap<Object>(session, o, new BeanMetaFiltered(cm.getBeanMeta(), this.properties));
            }
        }
        return o;
    }

    private static String findClassName(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Class) {
            return ((Class)o).getName();
        }
        return o.getClass().getName();
    }

    public String toString() {
        return this.name + ": " + this.rawTypeMeta.getInnerClass().getName() + ", field=[" + this.field + "], getter=[" + this.getter + "], setter=[" + this.setter + "]";
    }

    public static class Builder {
        private BeanMeta<?> beanMeta;
        private BeanContext beanContext;
        String name;
        Field field;
        Method getter;
        Method setter;
        private boolean isConstructorArg;
        private boolean isUri;
        private ClassMeta<?> rawTypeMeta;
        private ClassMeta<?> typeMeta;
        private String[] properties;
        private PojoSwap swap;
        private BeanRegistry beanRegistry;
        private Object overrideValue;
        private BeanPropertyMeta delegateFor;

        Builder(BeanMeta<?> beanMeta, String name) {
            this.beanMeta = beanMeta;
            this.beanContext = beanMeta.ctx;
            this.name = name;
        }

        Builder(BeanMeta<?> beanMeta, String name, ClassMeta<?> rawTypeMeta, BeanRegistry beanRegistry) {
            this(beanMeta, name);
            this.rawTypeMeta = rawTypeMeta;
            if (rawTypeMeta == null) {
                throw new RuntimeException("xxx");
            }
            this.typeMeta = rawTypeMeta;
            this.beanRegistry = beanRegistry;
        }

        public Builder(BeanMeta<?> beanMeta, String name, Object overrideValue, BeanPropertyMeta delegateFor) {
            this(beanMeta, name);
            this.delegateFor = delegateFor;
            this.overrideValue = overrideValue;
        }

        boolean validate(BeanContext f, BeanRegistry parentBeanRegistry, Map<Class<?>, Class<?>[]> typeVarImpls) throws Exception {
            BeanProperty p;
            ArrayList bdClasses = new ArrayList();
            if (this.field == null && this.getter == null) {
                return false;
            }
            if (this.field == null && this.setter == null && f.beansRequireSettersForGetters && !this.isConstructorArg) {
                return false;
            }
            if (this.field != null) {
                p = this.field.getAnnotation(BeanProperty.class);
                this.rawTypeMeta = f.resolveClassMeta(p, this.field.getGenericType(), typeVarImpls);
                this.isUri |= this.rawTypeMeta.isUri() || this.field.isAnnotationPresent(URI.class);
                if (p != null) {
                    this.swap = this.getPropertyPojoSwap(p);
                    if (!p.properties().isEmpty()) {
                        this.properties = StringUtils.split(p.properties(), ',');
                    }
                    bdClasses.addAll(Arrays.asList(p.beanDictionary()));
                }
            }
            if (this.getter != null) {
                p = this.getter.getAnnotation(BeanProperty.class);
                if (this.rawTypeMeta == null) {
                    this.rawTypeMeta = f.resolveClassMeta(p, this.getter.getGenericReturnType(), typeVarImpls);
                }
                this.isUri |= this.rawTypeMeta.isUri() || this.getter.isAnnotationPresent(URI.class);
                if (p != null) {
                    if (this.swap == null) {
                        this.swap = this.getPropertyPojoSwap(p);
                    }
                    if (this.properties != null && !p.properties().isEmpty()) {
                        this.properties = StringUtils.split(p.properties(), ',');
                    }
                    bdClasses.addAll(Arrays.asList(p.beanDictionary()));
                }
            }
            if (this.setter != null) {
                p = this.setter.getAnnotation(BeanProperty.class);
                if (this.rawTypeMeta == null) {
                    this.rawTypeMeta = f.resolveClassMeta(p, this.setter.getGenericParameterTypes()[0], typeVarImpls);
                }
                this.isUri |= this.rawTypeMeta.isUri() || this.setter.isAnnotationPresent(URI.class);
                if (p != null) {
                    if (this.swap == null) {
                        this.swap = this.getPropertyPojoSwap(p);
                    }
                    if (this.properties != null && !p.properties().isEmpty()) {
                        this.properties = StringUtils.split(p.properties(), ',');
                    }
                    bdClasses.addAll(Arrays.asList(p.beanDictionary()));
                }
            }
            if (this.rawTypeMeta == null) {
                return false;
            }
            this.beanRegistry = new BeanRegistry(this.beanContext, parentBeanRegistry, bdClasses.toArray(new Class[0]));
            Class<?> c = this.rawTypeMeta.getInnerClass();
            if (this.getter != null && !ClassUtils.isParentClass(this.getter.getReturnType(), c)) {
                return false;
            }
            if (this.setter != null && !ClassUtils.isParentClass(this.setter.getParameterTypes()[0], c)) {
                return false;
            }
            if (this.field != null && !ClassUtils.isParentClass(this.field.getType(), c)) {
                return false;
            }
            if (this.typeMeta == null) {
                ClassMeta<Object> classMeta = this.swap != null ? this.swap.getSwapClassMeta(this.beanContext) : (this.typeMeta = this.rawTypeMeta == null ? this.beanContext.object() : this.rawTypeMeta.getSerializedClassMeta());
            }
            if (this.typeMeta == null) {
                this.typeMeta = this.rawTypeMeta;
            }
            return true;
        }

        public BeanPropertyMeta build() {
            return new BeanPropertyMeta(this);
        }

        private PojoSwap getPropertyPojoSwap(BeanProperty p) throws Exception {
            Class<?> c = p.swap();
            if (c == Null.class) {
                return null;
            }
            try {
                if (ClassUtils.isParentClass(PojoSwap.class, c)) {
                    return (PojoSwap)c.newInstance();
                }
                throw new RuntimeException("TODO - Surrogate swaps not yet supported.");
            }
            catch (Exception e) {
                throw new BeanRuntimeException(this.beanMeta.c, "Could not instantiate PojoSwap ''{0}'' for bean property ''{1}''", c.getName(), this.name).initCause(e);
            }
        }

        Builder setGetter(Method getter) {
            Visibility.setAccessible(getter);
            this.getter = getter;
            return this;
        }

        Builder setSetter(Method setter) {
            Visibility.setAccessible(setter);
            this.setter = setter;
            return this;
        }

        Builder setField(Field field) {
            Visibility.setAccessible(field);
            this.field = field;
            return this;
        }

        Builder setAsConstructorArg() {
            this.isConstructorArg = true;
            return this;
        }
    }
}

