/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Delegate;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlBeanMeta;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlClassMeta;
import org.apache.juneau.xml.XmlSchemaSerializer;
import org.apache.juneau.xml.XmlSerializerBuilder;
import org.apache.juneau.xml.XmlSerializerContext;
import org.apache.juneau.xml.XmlSerializerSession;
import org.apache.juneau.xml.XmlWriter;
import org.apache.juneau.xml.annotation.XmlFormat;

@Produces(value="text/xml")
public class XmlSerializer
extends WriterSerializer {
    public static final XmlSerializer DEFAULT = new XmlSerializer(PropertyStore.create());
    public static final XmlSerializer DEFAULT_SQ = new Sq(PropertyStore.create());
    public static final XmlSerializer DEFAULT_SQ_READABLE = new SqReadable(PropertyStore.create());
    public static final XmlSerializer DEFAULT_NS = new Ns(PropertyStore.create());
    public static final XmlSerializer DEFAULT_NS_SQ = new NsSq(PropertyStore.create());
    public static final XmlSerializer DEFAULT_NS_SQ_READABLE = new NsSqReadable(PropertyStore.create());
    private final XmlSerializerContext ctx = this.createContext(XmlSerializerContext.class);
    private volatile XmlSchemaSerializer schemaSerializer;

    public XmlSerializer(PropertyStore propertyStore) {
        super(propertyStore);
    }

    @Override
    public XmlSerializerBuilder builder() {
        return new XmlSerializerBuilder(this.propertyStore);
    }

    protected void findNsfMappings(XmlSerializerSession session, Object o) throws SerializeException {
        Namespace ns;
        ClassMeta<?> aType = null;
        aType = session.push(null, o, null);
        if (aType != null && (ns = aType.getExtendedMeta(XmlClassMeta.class).getNamespace()) != null) {
            if (ns.uri != null) {
                session.addNamespace(ns);
            } else {
                ns = null;
            }
        }
        if (aType != null && !aType.isPrimitive()) {
            BeanMap<Object> bm = null;
            if (aType.isBeanMap()) {
                bm = (BeanMap<Object>)o;
            } else if (aType.isBean()) {
                bm = session.toBeanMap(o);
            } else if (aType.isDelegate()) {
                ClassMeta innerType = ((Delegate)o).getClassMeta();
                Namespace ns2 = innerType.getExtendedMeta(XmlClassMeta.class).getNamespace();
                if (ns2 != null) {
                    if (ns2.uri != null) {
                        session.addNamespace(ns2);
                    } else {
                        ns2 = null;
                    }
                }
                if (innerType.isBean()) {
                    for (BeanPropertyMeta bpm : innerType.getBeanMeta().getPropertyMetas()) {
                        ns2 = bpm.getExtendedMeta(XmlBeanPropertyMeta.class).getNamespace();
                        if (ns2 == null || ns2.uri == null) continue;
                        session.addNamespace(ns2);
                    }
                } else if (innerType.isMap()) {
                    for (Object o2 : ((Map)o).values()) {
                        this.findNsfMappings(session, o2);
                    }
                } else if (innerType.isCollection()) {
                    for (Object o2 : (Collection)o) {
                        this.findNsfMappings(session, o2);
                    }
                }
            } else if (aType.isMap()) {
                for (BeanPropertyValue o2 : ((Map)o).values()) {
                    this.findNsfMappings(session, o2);
                }
            } else if (aType.isCollection()) {
                for (BeanPropertyValue o2 : (Collection)o) {
                    this.findNsfMappings(session, o2);
                }
            } else if (aType.isArray() && !aType.getElementType().isPrimitive()) {
                for (Object o2 : (Object[])o) {
                    this.findNsfMappings(session, o2);
                }
            }
            if (bm != null) {
                for (BeanPropertyValue p : bm.getValues(session.isTrimNulls(), new BeanPropertyValue[0])) {
                    Namespace ns3 = p.getMeta().getExtendedMeta(XmlBeanPropertyMeta.class).getNamespace();
                    if (ns3 != null && ns3.uri != null) {
                        session.addNamespace(ns3);
                    }
                    try {
                        this.findNsfMappings(session, p.getValue());
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        session.pop();
    }

    protected XmlWriter serializeAnything(XmlSerializerSession session, XmlWriter out, Object o, ClassMeta eType, String elementName, Namespace elementNamespace, boolean addNamespaceUris, XmlFormat format, boolean isMixed, boolean preserveWhitespace, BeanPropertyMeta pMeta) throws Exception {
        JsonType type = null;
        int indent = isMixed ? 0 : session.indent;
        ClassMeta<Object> aType = null;
        ClassMeta<Object> wType = null;
        ClassMeta<Object> sType = this.object();
        aType = session.push(elementName, o, eType);
        if (eType == null) {
            eType = this.object();
        }
        if (aType == null) {
            o = null;
            aType = this.object();
        }
        if (o != null) {
            if (aType.isDelegate()) {
                wType = aType;
                aType = ((Delegate)o).getClassMeta();
                eType = aType;
            }
            sType = aType.getSerializedClassMeta();
            PojoSwap<Object, ?> swap = aType.getPojoSwap();
            if (swap != null) {
                o = swap.swap(session, o);
                if (sType.isObject()) {
                    sType = session.getClassMetaForObject(o);
                }
            }
        } else {
            sType = eType.getSerializedClassMeta();
        }
        boolean isExpectedType = true;
        if (o == null || !eType.same(aType)) {
            isExpectedType = eType.isNumber() ? aType.isNumber() : (eType.isMap() ? aType.isMap() : (eType.isCollectionOrArray() ? aType.isCollectionOrArray() : false));
        }
        String resolvedDictionaryName = isExpectedType ? null : aType.getDictionaryName();
        String dictionaryName = aType.getDictionaryName();
        if (dictionaryName == null) {
            dictionaryName = sType.getDictionaryName();
        }
        if (o != null && sType.isChar() && ((Character)o).charValue() == '\u0000') {
            o = null;
        }
        boolean isCollapsed = false;
        if (o == null) {
            type = JsonType.NULL;
        } else if (sType.isCharSequence() || sType.isChar()) {
            type = JsonType.STRING;
        } else if (sType.isNumber()) {
            type = JsonType.NUMBER;
        } else if (sType.isBoolean()) {
            type = JsonType.BOOLEAN;
        } else if (sType.isMapOrBean()) {
            isCollapsed = sType.getExtendedMeta(XmlClassMeta.class).getFormat() == XmlFormat.COLLAPSED;
            type = JsonType.OBJECT;
        } else if (sType.isCollectionOrArray()) {
            isCollapsed = format == XmlFormat.COLLAPSED && !addNamespaceUris;
            type = JsonType.ARRAY;
        } else {
            type = JsonType.STRING;
        }
        if (format.isOneOf(XmlFormat.MIXED, XmlFormat.MIXED_PWS, XmlFormat.TEXT, XmlFormat.TEXT_PWS, XmlFormat.XMLTEXT) && type.isOneOf(JsonType.NULL, JsonType.STRING, JsonType.NUMBER, JsonType.BOOLEAN)) {
            isCollapsed = true;
        }
        if (elementName == null && dictionaryName != null) {
            elementName = dictionaryName;
            isExpectedType = true;
        }
        if (session.isEnableNamespaces()) {
            if (elementNamespace == null) {
                elementNamespace = sType.getExtendedMeta(XmlClassMeta.class).getNamespace();
            }
            if (elementNamespace == null) {
                elementNamespace = aType.getExtendedMeta(XmlClassMeta.class).getNamespace();
            }
            if (elementNamespace != null && elementNamespace.uri == null) {
                elementNamespace = null;
            }
            if (elementNamespace == null) {
                elementNamespace = session.getDefaultNamespace();
            }
        } else {
            elementNamespace = null;
        }
        boolean cr = o != null && (sType.isMapOrBean() || sType.isCollectionOrArray()) && !isMixed;
        String en = elementName;
        if (en == null) {
            en = type.toString();
            type = null;
        }
        boolean encodeEn = elementName != null;
        String ns = elementNamespace == null ? null : elementNamespace.name;
        String dns = null;
        String elementNs = null;
        if (session.isEnableNamespaces()) {
            dns = elementName == null && session.getDefaultNamespace() != null ? session.getDefaultNamespace().name : null;
            String string = elementNs = elementName == null ? dns : ns;
            if (elementName == null) {
                elementNamespace = null;
            }
        }
        if (!isCollapsed) {
            out.oTag(indent, elementNs, en, encodeEn);
            if (addNamespaceUris) {
                out.attr((String)null, "xmlns", (Object)session.getDefaultNamespace().getUri());
                for (Namespace n : session.getNamespaces()) {
                    out.attr("xmlns", n.getName(), (Object)n.getUri());
                }
            }
            if (!isExpectedType) {
                if (resolvedDictionaryName != null) {
                    out.attr(dns, session.getBeanTypePropertyName(eType), (Object)resolvedDictionaryName);
                } else if (type != null && type != JsonType.STRING) {
                    out.attr(dns, session.getBeanTypePropertyName(eType), (Object)type);
                }
            }
            if (o == null && (sType.isBoolean() || sType.isNumber()) && !sType.isNullable()) {
                o = sType.getPrimitiveDefault();
            }
            if (o != null && !sType.isMapOrBean()) {
                out.append('>');
            }
            if (cr && !sType.isMapOrBean()) {
                out.nl();
            }
        }
        ContentResult rc = ContentResult.CR_ELEMENTS;
        if (o != null) {
            if (sType.isUri() || pMeta != null && pMeta.isUri()) {
                out.appendUri(o);
            } else if (sType.isCharSequence() || sType.isChar()) {
                if (format == XmlFormat.XMLTEXT) {
                    out.append(o);
                } else {
                    out.text(o, preserveWhitespace);
                }
            } else if (sType.isNumber() || sType.isBoolean()) {
                out.append(o);
            } else if (sType.isMap() || wType != null && wType.isMap()) {
                rc = o instanceof BeanMap ? this.serializeBeanMap(session, out, (BeanMap)o, elementNamespace, isCollapsed, isMixed) : this.serializeMap(session, out, (Map)o, sType, eType.getKeyType(), eType.getValueType(), isMixed);
            } else if (sType.isBean()) {
                rc = this.serializeBeanMap(session, out, session.toBeanMap(o), elementNamespace, isCollapsed, isMixed);
            } else if (sType.isCollection() || wType != null && wType.isCollection()) {
                if (isCollapsed) {
                    --session.indent;
                }
                this.serializeCollection(session, out, o, sType, eType, pMeta, isMixed);
                if (isCollapsed) {
                    ++session.indent;
                }
            } else if (sType.isArray()) {
                if (isCollapsed) {
                    --session.indent;
                }
                this.serializeCollection(session, out, o, sType, eType, pMeta, isMixed);
                if (isCollapsed) {
                    ++session.indent;
                }
            } else if (format == XmlFormat.XMLTEXT) {
                out.append(session.toString(o));
            } else {
                out.text(session.toString(o));
            }
        }
        session.pop();
        if (!isCollapsed) {
            if (rc == ContentResult.CR_EMPTY) {
                if (session.isHtmlMode()) {
                    out.append('>').eTag(elementNs, en, encodeEn);
                } else {
                    out.append('/').append('>');
                }
            } else if (rc == ContentResult.CR_VOID || o == null) {
                out.append('/').append('>');
            } else {
                out.i(cr && rc != ContentResult.CR_MIXED ? indent : 0).eTag(elementNs, en, encodeEn);
            }
            if (!isMixed) {
                out.nl();
            }
        }
        return out;
    }

    private ContentResult serializeMap(XmlSerializerSession session, XmlWriter out, Map m, ClassMeta<?> sType, ClassMeta<?> eKeyType, ClassMeta<?> eValueType, boolean isMixed) throws Exception {
        m = session.sort(m);
        ClassMeta<?> keyType = eKeyType == null ? sType.getKeyType() : eKeyType;
        ClassMeta<?> valueType = eValueType == null ? sType.getValueType() : eValueType;
        boolean hasChildren = false;
        for (Map.Entry e : m.entrySet()) {
            Object k = e.getKey();
            if (k == null) {
                k = "\u0000";
            } else {
                k = session.generalize(k, keyType);
                if (session.isTrimStrings() && k instanceof String) {
                    k = k.toString().trim();
                }
            }
            Object value = e.getValue();
            if (!hasChildren) {
                hasChildren = true;
                out.append('>').nlIf(!isMixed);
            }
            this.serializeAnything(session, out, value, valueType, session.toString(k), null, false, XmlFormat.DEFAULT, isMixed, false, null);
        }
        return hasChildren ? ContentResult.CR_ELEMENTS : ContentResult.CR_EMPTY;
    }

    private ContentResult serializeBeanMap(XmlSerializerSession session, XmlWriter out, BeanMap<?> m, Namespace elementNs, boolean isCollapsed, boolean isMixed) throws Exception {
        boolean hasChildren = false;
        BeanMeta<?> bm = m.getMeta();
        List<BeanPropertyValue> lp = m.getValues(session.isTrimNulls(), new BeanPropertyValue[0]);
        XmlBeanMeta xbm = bm.getExtendedMeta(XmlBeanMeta.class);
        Set<String> attrs = xbm.getAttrPropertyNames();
        Set<String> elements = xbm.getElementPropertyNames();
        Set<String> collapsedElements = xbm.getCollapsedPropertyNames();
        String attrsProperty = xbm.getAttrsPropertyName();
        String contentProperty = xbm.getContentPropertyName();
        XmlFormat cf = null;
        Object content = null;
        ClassMeta<?> contentType = null;
        for (BeanPropertyValue p : lp) {
            Namespace ns;
            String n = p.getName();
            if (!attrs.contains(n) && !n.equals(attrsProperty)) continue;
            BeanPropertyMeta pMeta = p.getMeta();
            ClassMeta<?> cMeta = p.getClassMeta();
            String string = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                session.addBeanGetterWarning(pMeta, t);
            }
            if (session.canIgnoreValue(cMeta, string, value)) continue;
            Namespace namespace = ns = session.isEnableNamespaces() && pMeta.getExtendedMeta(XmlBeanPropertyMeta.class).getNamespace() != elementNs ? pMeta.getExtendedMeta(XmlBeanPropertyMeta.class).getNamespace() : null;
            if (pMeta.isUri()) {
                out.attrUri(ns, string, value);
                continue;
            }
            if (n.equals(attrsProperty)) {
                if (value instanceof BeanMap) {
                    BeanMap bm2 = (BeanMap)value;
                    for (BeanPropertyValue beanPropertyValue : bm2.getValues(true, new BeanPropertyValue[0])) {
                        String key2 = beanPropertyValue.getName();
                        Object value2 = beanPropertyValue.getValue();
                        Throwable t2 = beanPropertyValue.getThrown();
                        if (t2 != null) {
                            session.addBeanGetterWarning(pMeta, t);
                        }
                        out.attr(ns, key2, value2);
                    }
                    continue;
                }
                Map m2 = (Map)value;
                for (Map.Entry entry : m2.entrySet()) {
                    out.attr(ns, session.toString(entry.getKey()), entry.getValue());
                }
                continue;
            }
            out.attr(ns, string, value);
        }
        boolean hasContent = false;
        boolean preserveWhitespace = false;
        boolean isVoidElement = xbm.getContentFormat() == XmlFormat.VOID;
        for (BeanPropertyValue p : lp) {
            BeanPropertyMeta beanPropertyMeta = p.getMeta();
            ClassMeta<?> cMeta = p.getClassMeta();
            String n = p.getName();
            if (n.equals(contentProperty)) {
                content = p.getValue();
                contentType = p.getClassMeta();
                hasContent = true;
                cf = xbm.getContentFormat();
                if (cf.isOneOf(XmlFormat.MIXED, XmlFormat.MIXED_PWS, XmlFormat.TEXT, XmlFormat.TEXT_PWS, XmlFormat.XMLTEXT)) {
                    isMixed = true;
                }
                if (cf.isOneOf(XmlFormat.MIXED_PWS, XmlFormat.TEXT_PWS)) {
                    preserveWhitespace = true;
                }
                if (contentType.isCollection() && ((Collection)content).isEmpty()) {
                    hasContent = false;
                    continue;
                }
                if (!contentType.isArray() || Array.getLength(content) != 0) continue;
                hasContent = false;
                continue;
            }
            if (!elements.contains(n) && !collapsedElements.contains(n)) continue;
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                session.addBeanGetterWarning(beanPropertyMeta, t);
            }
            if (session.canIgnoreValue(cMeta, key, value)) continue;
            if (!hasChildren) {
                hasChildren = true;
                out.appendIf(!isCollapsed, '>').nlIf(!isMixed);
            }
            XmlBeanPropertyMeta xmlBeanPropertyMeta = beanPropertyMeta.getExtendedMeta(XmlBeanPropertyMeta.class);
            this.serializeAnything(session, out, value, cMeta, key, xmlBeanPropertyMeta.getNamespace(), false, xmlBeanPropertyMeta.getXmlFormat(), isMixed, false, beanPropertyMeta);
        }
        if (!hasContent) {
            return hasChildren ? ContentResult.CR_ELEMENTS : (isVoidElement ? ContentResult.CR_VOID : ContentResult.CR_EMPTY);
        }
        out.append('>').nlIf(!isMixed);
        if (content != null) {
            if (contentType != null) {
                List<Object> c;
                if (contentType.isCollection()) {
                    c = (List<Object>)content;
                    for (Object e : c) {
                        this.serializeAnything(session, out, e, contentType.getElementType(), null, null, false, cf, isMixed, preserveWhitespace, null);
                    }
                } else if (contentType.isArray()) {
                    c = XmlSerializer.toList(Object[].class, content);
                    for (Object e : c) {
                        this.serializeAnything(session, out, e, contentType.getElementType(), null, null, false, cf, isMixed, preserveWhitespace, null);
                    }
                } else {
                    this.serializeAnything(session, out, content, contentType, null, null, false, cf, isMixed, preserveWhitespace, null);
                }
            }
        } else if (!session.isTrimNulls()) {
            if (!isMixed) {
                out.i(session.indent);
            }
            out.text(content);
            if (!isMixed) {
                out.nl();
            }
        }
        return isMixed ? ContentResult.CR_MIXED : ContentResult.CR_ELEMENTS;
    }

    private XmlWriter serializeCollection(XmlSerializerSession session, XmlWriter out, Object in, ClassMeta<?> sType, ClassMeta<?> eType, BeanPropertyMeta ppMeta, boolean isMixed) throws Exception {
        ClassMeta<Object> seType = sType.getElementType();
        if (seType == null) {
            seType = session.object();
        }
        ClassMeta<?> eeType = eType.getElementType();
        Collection<Object> c = sType.isCollection() ? (List<Object>)in : XmlSerializer.toList(sType.getInnerClass(), in);
        c = session.sort(c);
        String type2 = null;
        if (sType != eType) {
            type2 = sType.getDictionaryName();
        }
        String eName = type2;
        Namespace eNs = null;
        if (ppMeta != null) {
            XmlBeanPropertyMeta xbpm = ppMeta.getExtendedMeta(XmlBeanPropertyMeta.class);
            eName = xbpm.getChildName();
            eNs = xbpm.getNamespace();
        }
        for (Object value : c) {
            this.serializeAnything(session, out, value, eeType, eName, eNs, false, XmlFormat.DEFAULT, isMixed, false, null);
        }
        return out;
    }

    public XmlSerializer getSchemaSerializer() {
        if (this.schemaSerializer == null) {
            this.schemaSerializer = new XmlSchemaSerializer(this.propertyStore, this.getOverrideProperties());
        }
        return this.schemaSerializer;
    }

    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        XmlSerializerSession s = (XmlSerializerSession)session;
        if (s.isEnableNamespaces() && s.isAutoDetectNamespaces()) {
            this.findNsfMappings(s, o);
        }
        this.serializeAnything(s, s.getWriter(), o, s.getExpectedRootType(o), null, null, s.isEnableNamespaces() && s.isAddNamespaceUrlsToRoot(), XmlFormat.DEFAULT, false, false, null);
    }

    @Override
    public XmlSerializerSession createSession(Object output, ObjectMap op, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType) {
        return new XmlSerializerSession(this.ctx, op, output, javaMethod, locale, timeZone, mediaType);
    }

    static enum ContentResult {
        CR_VOID,
        CR_EMPTY,
        CR_MIXED,
        CR_ELEMENTS;

    }

    static enum JsonType {
        STRING("string"),
        BOOLEAN("boolean"),
        NUMBER("number"),
        ARRAY("array"),
        OBJECT("object"),
        NULL("null");

        private final String value;

        private JsonType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        boolean isOneOf(JsonType ... types) {
            for (JsonType type : types) {
                if (type != this) continue;
                return true;
            }
            return false;
        }
    }

    public static class NsSqReadable
    extends XmlSerializer {
        public NsSqReadable(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("XmlSerializer.enableNamespaces", true).append("Serializer.quoteChar", Character.valueOf('\'')).append("Serializer.useWhitespace", true);
        }
    }

    public static class NsSq
    extends XmlSerializer {
        public NsSq(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("XmlSerializer.enableNamespaces", true).append("Serializer.quoteChar", Character.valueOf('\''));
        }
    }

    @Produces(value="text/xml+simple", contentType="text/xml")
    public static class Ns
    extends XmlSerializer {
        public Ns(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("XmlSerializer.enableNamespaces", true);
        }
    }

    public static class SqReadable
    extends XmlSerializer {
        public SqReadable(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("Serializer.quoteChar", Character.valueOf('\'')).append("Serializer.useWhitespace", true);
        }
    }

    public static class Sq
    extends XmlSerializer {
        public Sq(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("Serializer.quoteChar", Character.valueOf('\''));
        }
    }
}

