/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.Consumes;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.xml.XmlBeanMeta;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlClassMeta;
import org.apache.juneau.xml.XmlParserBuilder;
import org.apache.juneau.xml.XmlParserContext;
import org.apache.juneau.xml.XmlParserSession;
import org.apache.juneau.xml.XmlUtils;
import org.apache.juneau.xml.annotation.XmlFormat;

@Consumes(value="text/xml,application/xml")
public class XmlParser
extends ReaderParser {
    public static final XmlParser DEFAULT = new XmlParser(PropertyStore.create());
    private static final int UNKNOWN = 0;
    private static final int OBJECT = 1;
    private static final int ARRAY = 2;
    private static final int STRING = 3;
    private static final int NUMBER = 4;
    private static final int BOOLEAN = 5;
    private static final int NULL = 6;
    private final XmlParserContext ctx = this.createContext(XmlParserContext.class);

    public XmlParser(PropertyStore propertyStore) {
        super(propertyStore);
    }

    @Override
    public XmlParserBuilder builder() {
        return new XmlParserBuilder(this.propertyStore);
    }

    protected <T> T parseAnything(XmlParserSession session, ClassMeta<T> eType, String currAttr, XMLStreamReader r, Object outer, boolean isRoot, BeanPropertyMeta pMeta) throws Exception {
        ClassMeta<?> tcm;
        if (eType == null) {
            eType = this.object();
        }
        PojoSwap<T, T> transform = eType.getPojoSwap();
        ClassMeta<?> sType = eType.getSerializedClassMeta();
        session.setCurrentClass(sType);
        String wrapperAttr = isRoot && session.isPreserveRootElement() ? r.getName().getLocalPart() : null;
        String typeAttr = r.getAttributeValue(null, session.getBeanTypePropertyName(eType));
        int jsonType = XmlParser.getJsonType(typeAttr);
        String elementName = session.getElementName(r);
        if (jsonType == 0) {
            if (elementName == null || elementName.equals(currAttr)) {
                jsonType = 0;
            } else {
                typeAttr = elementName;
                jsonType = XmlParser.getJsonType(elementName);
            }
        }
        if ((tcm = session.getClassMeta(typeAttr, pMeta, eType)) == null && elementName != null && !elementName.equals(currAttr)) {
            tcm = session.getClassMeta(elementName, pMeta, eType);
        }
        if (tcm != null) {
            eType = tcm;
            sType = eType;
        }
        Object o = null;
        if (jsonType == 6) {
            r.nextTag();
            return null;
        }
        if (sType.isObject()) {
            if (jsonType == 1) {
                ObjectMap m = new ObjectMap(session);
                this.parseIntoMap(session, r, m, this.string(), this.object(), pMeta);
                if (wrapperAttr != null) {
                    m = new ObjectMap(session).append(wrapperAttr, m);
                }
                o = session.cast(m, pMeta, eType);
            } else if (jsonType == 2) {
                o = this.parseIntoCollection(session, r, new ObjectList(session), null, pMeta);
            } else if (jsonType == 3) {
                o = session.getElementText(r);
                if (sType.isChar()) {
                    o = Character.valueOf(o.toString().charAt(0));
                }
            } else if (jsonType == 4) {
                o = StringUtils.parseNumber(session.getElementText(r), null);
            } else if (jsonType == 5) {
                o = Boolean.parseBoolean(session.getElementText(r));
            } else if (jsonType == 0) {
                o = this.getUnknown(session, r);
            }
        } else if (sType.isBoolean()) {
            o = Boolean.parseBoolean(session.getElementText(r));
        } else if (sType.isCharSequence()) {
            o = session.getElementText(r);
        } else if (sType.isChar()) {
            String s = session.getElementText(r);
            o = Character.valueOf(s.length() == 0 ? (char)'\u0000' : s.charAt(0));
        } else if (sType.isMap()) {
            Map<String, Object> m = sType.canCreateNewInstance(outer) ? (Map)sType.newInstance(outer) : new ObjectMap(session);
            o = this.parseIntoMap(session, r, m, sType.getKeyType(), sType.getValueType(), pMeta);
            if (wrapperAttr != null) {
                o = new ObjectMap(session).append(wrapperAttr, m);
            }
        } else if (sType.isCollection()) {
            Collection<Object> l = sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance(outer) : new ObjectList(session);
            o = this.parseIntoCollection(session, r, l, sType, pMeta);
        } else if (sType.isNumber()) {
            o = StringUtils.parseNumber(session.getElementText(r), sType.getInnerClass());
        } else if (sType.canCreateNewBean(outer)) {
            if (sType.getExtendedMeta(XmlClassMeta.class).getFormat() == XmlFormat.COLLAPSED) {
                String fieldName = r.getLocalName();
                BeanMap<?> m = session.newBeanMap(outer, sType.getInnerClass());
                BeanPropertyMeta bpm = m.getMeta().getExtendedMeta(XmlBeanMeta.class).getPropertyMeta(fieldName);
                ClassMeta<?> cm = m.getMeta().getClassMeta();
                Object value = this.parseAnything(session, cm, currAttr, r, m.getBean(false), false, null);
                this.setName(cm, value, currAttr);
                bpm.set(m, value);
                o = m.getBean();
            } else {
                BeanMap<?> m = session.newBeanMap(outer, sType.getInnerClass());
                o = this.parseIntoBean(session, r, m).getBean();
            }
        } else if (sType.isArray() || sType.isArgs()) {
            ArrayList l = (ArrayList)this.parseIntoCollection(session, r, new ArrayList(), sType, pMeta);
            o = session.toArray(sType, l);
        } else if (sType.canCreateNewInstanceFromString(outer)) {
            o = sType.newInstanceFromString(outer, session.getElementText(r));
        } else if (sType.canCreateNewInstanceFromNumber(outer)) {
            o = sType.newInstanceFromNumber(session, outer, StringUtils.parseNumber(session.getElementText(r), sType.getNewInstanceFromNumberClass()));
        } else {
            throw new ParseException(session, "Class ''{0}'' could not be instantiated.  Reason: ''{1}'', property: ''{2}''", sType.getInnerClass().getName(), sType.getNotABeanReason(), pMeta == null ? null : pMeta.getName());
        }
        if (transform != null && o != null) {
            o = transform.unswap(session, o, eType);
        }
        if (outer != null) {
            this.setParent(eType, o, outer);
        }
        return (T)o;
    }

    private <K, V> Map<K, V> parseIntoMap(XmlParserSession session, XMLStreamReader r, Map<K, V> m, ClassMeta<K> keyType, ClassMeta<V> valueType, BeanPropertyMeta pMeta) throws Exception {
        V value;
        K key;
        int depth = 0;
        for (int i = 0; i < r.getAttributeCount(); ++i) {
            String a = r.getAttributeLocalName(i);
            if (a.equals(session.getBeanTypePropertyName(null))) continue;
            key = session.trim(this.convertAttrToType(session, m, a, keyType));
            value = session.trim(this.convertAttrToType(session, m, r.getAttributeValue(i), valueType));
            this.setName(valueType, value, key);
            m.put(key, (ObjectList)value);
        }
        do {
            int event;
            if ((event = r.nextTag()) == 1) {
                ++depth;
                String currAttr = session.getElementName(r);
                key = this.convertAttrToType(session, m, currAttr, keyType);
                value = this.parseAnything(session, valueType, currAttr, r, m, false, pMeta);
                this.setName(valueType, value, currAttr);
                if (valueType.isObject() && m.containsKey(key)) {
                    V o = m.get(key);
                    if (o instanceof List) {
                        ((List)o).add(value);
                        continue;
                    }
                    m.put(key, new ObjectList(o, value).setBeanSession(session));
                    continue;
                }
                m.put(key, (ObjectList)value);
                continue;
            }
            if (event != 2) continue;
            --depth;
            return m;
        } while (depth > 0);
        return m;
    }

    private <E> Collection<E> parseIntoCollection(XmlParserSession session, XMLStreamReader r, Collection<E> l, ClassMeta<?> type, BeanPropertyMeta pMeta) throws Exception {
        int depth = 0;
        int argIndex = 0;
        do {
            int event;
            if ((event = r.nextTag()) == 1) {
                ++depth;
                ClassMeta<Object> elementType = type == null ? this.object() : (type.isArgs() ? type.getArg(argIndex++) : type.getElementType());
                Object value = this.parseAnything(session, elementType, null, r, l, false, pMeta);
                l.add(value);
                continue;
            }
            if (event != 2) continue;
            --depth;
            return l;
        } while (depth > 0);
        return l;
    }

    private static int getJsonType(String s) {
        if (s == null) {
            return 0;
        }
        char c = s.charAt(0);
        switch (c) {
            case 'o': {
                return s.equals("object") ? 1 : 0;
            }
            case 'a': {
                return s.equals("array") ? 2 : 0;
            }
            case 's': {
                return s.equals("string") ? 3 : 0;
            }
            case 'b': {
                return s.equals("boolean") ? 5 : 0;
            }
            case 'n': {
                c = s.charAt(2);
                switch (c) {
                    case 'm': {
                        return s.equals("number") ? 4 : 0;
                    }
                    case 'l': {
                        return s.equals("null") ? 6 : 0;
                    }
                }
            }
        }
        return 0;
    }

    private <T> BeanMap<T> parseIntoBean(XmlParserSession session, XMLStreamReader r, BeanMap<T> m) throws Exception {
        BeanMeta<T> bMeta = m.getMeta();
        XmlBeanMeta xmlMeta = bMeta.getExtendedMeta(XmlBeanMeta.class);
        for (int i = 0; i < r.getAttributeCount(); ++i) {
            String key = session.getAttributeName(r, i);
            String val = r.getAttributeValue(i);
            BeanPropertyMeta bpm = xmlMeta.getPropertyMeta(key);
            if (bpm == null) {
                if (xmlMeta.getAttrsProperty() != null) {
                    xmlMeta.getAttrsProperty().add(m, key, val);
                    continue;
                }
                Location l = r.getLocation();
                this.onUnknownProperty(session, key, m, l.getLineNumber(), l.getColumnNumber());
                continue;
            }
            bpm.set(m, val);
        }
        BeanPropertyMeta cp = xmlMeta.getContentProperty();
        XmlFormat cpf = xmlMeta.getContentFormat();
        boolean trim = cp == null || !cpf.isOneOf(XmlFormat.MIXED_PWS, XmlFormat.TEXT_PWS);
        ClassMeta<Object> cpcm = cp == null ? session.object() : cp.getClassMeta();
        StringBuilder sb = null;
        BeanRegistry breg = cp == null ? null : cp.getBeanRegistry();
        LinkedList<String> l = null;
        int depth = 0;
        do {
            String s;
            int event;
            if ((event = r.next()) == 4) {
                if (cp != null && cpf.isOneOf(XmlFormat.MIXED, XmlFormat.MIXED_PWS)) {
                    if (cpcm.isCollectionOrArray()) {
                        if (l == null) {
                            l = new LinkedList<String>();
                        }
                        l.add(session.getText(r, false));
                        continue;
                    }
                    cp.set(m, session.getText(r, trim));
                    continue;
                }
                if (cpf == XmlFormat.ELEMENTS || (s = session.getText(r, trim)) == null) continue;
                if (sb == null) {
                    sb = session.getStringBuilder();
                }
                sb.append(s);
                continue;
            }
            if (event == 1) {
                Object value;
                if (cp != null && cpf.isOneOf(XmlFormat.TEXT, XmlFormat.TEXT_PWS)) {
                    s = session.parseText(r);
                    if (s != null) {
                        if (sb == null) {
                            sb = session.getStringBuilder();
                        }
                        sb.append(s);
                    }
                    --depth;
                    continue;
                }
                if (cpf == XmlFormat.XMLTEXT) {
                    if (sb == null) {
                        sb = session.getStringBuilder();
                    }
                    sb.append(session.getElementAsString(r));
                    ++depth;
                    continue;
                }
                if (cp != null && cpf.isOneOf(XmlFormat.MIXED, XmlFormat.MIXED_PWS)) {
                    if (session.isWhitespaceElement(r) && (breg == null || !breg.hasName(r.getLocalName()))) {
                        if (cpcm.isCollectionOrArray()) {
                            if (l == null) {
                                l = new LinkedList();
                            }
                            l.add(session.parseWhitespaceElement(r));
                            continue;
                        }
                        cp.set(m, session.parseWhitespaceElement(r));
                        continue;
                    }
                    if (cpcm.isCollectionOrArray()) {
                        if (l == null) {
                            l = new LinkedList();
                        }
                        l.add((String)this.parseAnything(session, cpcm.getElementType(), cp.getName(), r, m.getBean(false), false, cp));
                        continue;
                    }
                    cp.set(m, this.parseAnything(session, cpcm, cp.getName(), r, m.getBean(false), false, cp));
                    continue;
                }
                if (cp != null && cpf == XmlFormat.ELEMENTS) {
                    cp.add(m, this.parseAnything(session, cpcm.getElementType(), cp.getName(), r, m.getBean(false), false, cp));
                    continue;
                }
                String currAttr = session.getElementName(r);
                BeanPropertyMeta pMeta = xmlMeta.getPropertyMeta(currAttr);
                if (pMeta == null) {
                    Location loc = r.getLocation();
                    this.onUnknownProperty(session, currAttr, m, loc.getLineNumber(), loc.getColumnNumber());
                    XmlParser.skipCurrentTag(r);
                    continue;
                }
                session.setCurrentProperty(pMeta);
                XmlFormat xf = pMeta.getExtendedMeta(XmlBeanPropertyMeta.class).getXmlFormat();
                if (xf == XmlFormat.COLLAPSED) {
                    ClassMeta<?> et = pMeta.getClassMeta().getElementType();
                    value = this.parseAnything(session, et, currAttr, r, m.getBean(false), false, pMeta);
                    this.setName(et, value, currAttr);
                    pMeta.add(m, value);
                } else if (xf == XmlFormat.ATTR) {
                    pMeta.set(m, session.getAttributeValue(r, 0));
                    r.nextTag();
                } else {
                    ClassMeta<?> cm = pMeta.getClassMeta();
                    value = this.parseAnything(session, cm, currAttr, r, m.getBean(false), false, pMeta);
                    this.setName(cm, value, currAttr);
                    pMeta.set(m, value);
                }
                session.setCurrentProperty(null);
                continue;
            }
            if (event == 2) {
                if (depth > 0) {
                    if (cpf == XmlFormat.XMLTEXT) {
                        if (sb == null) {
                            sb = session.getStringBuilder();
                        }
                        sb.append(session.getElementAsString(r));
                    } else {
                        throw new ParseException("End element found where one was not expected.  {0}", XmlUtils.toReadableEvent(r));
                    }
                }
                --depth;
                continue;
            }
            throw new ParseException("Unexpected event type: {0}", XmlUtils.toReadableEvent(r));
        } while (depth >= 0);
        if (sb != null && cp != null) {
            cp.set(m, sb.toString());
        } else if (l != null && cp != null) {
            cp.set(m, XmlUtils.collapseTextNodes(l));
        }
        session.returnStringBuilder(sb);
        return m;
    }

    private static void skipCurrentTag(XMLStreamReader r) throws XMLStreamException {
        int depth = 1;
        do {
            int event;
            if ((event = r.next()) == 1) {
                ++depth;
                continue;
            }
            if (event != 2) continue;
            --depth;
        } while (depth > 0);
    }

    private Object getUnknown(XmlParserSession session, XMLStreamReader r) throws Exception {
        if (r.getEventType() != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", r.getLocation());
        }
        ObjectMap m = null;
        if (r.getAttributeCount() > 0) {
            m = new ObjectMap(session);
            for (int i = 0; i < r.getAttributeCount(); ++i) {
                String key = session.getAttributeName(r, i);
                String val = r.getAttributeValue(i);
                if (key.equals(session.getBeanTypePropertyName(null))) continue;
                m.put(key, val);
            }
        }
        int eventType = r.next();
        StringBuilder sb = session.getStringBuilder();
        block1: while (eventType != 2) {
            if (eventType == 4 || eventType == 12 || eventType == 6 || eventType == 9) {
                sb.append(r.getText());
            } else if (eventType != 3 && eventType != 5) {
                if (eventType == 8) {
                    throw new XMLStreamException("Unexpected end of document when reading element text content", r.getLocation());
                }
                if (eventType == 1) {
                    if (m == null) {
                        m = new ObjectMap(session);
                    }
                    int depth = 0;
                    do {
                        int event;
                        int n = event = eventType == -1 ? r.nextTag() : eventType;
                        if (event == 1) {
                            ++depth;
                            String currAttr = session.getElementName(r);
                            String key = this.convertAttrToType(session, null, currAttr, this.string());
                            Object value = this.parseAnything(session, this.object(), currAttr, r, null, false, null);
                            if (m.containsKey(key)) {
                                Object o = m.get(key);
                                if (o instanceof ObjectList) {
                                    ((ObjectList)o).add(value);
                                } else {
                                    m.put(key, new ObjectList(o, value).setBeanSession(session));
                                }
                            } else {
                                m.put(key, value);
                            }
                        } else if (event == 2) {
                            --depth;
                            break block1;
                        }
                        eventType = -1;
                    } while (depth > 0);
                    break;
                }
                throw new XMLStreamException("Unexpected event type " + eventType, r.getLocation());
            }
            eventType = r.next();
        }
        String s = sb.toString();
        session.returnStringBuilder(sb);
        s = session.decodeString(s);
        if (m != null) {
            if (!s.isEmpty()) {
                m.put("contents", s);
            }
            return m;
        }
        return s;
    }

    @Override
    public XmlParserSession createSession(Object input, ObjectMap op, Method javaMethod, Object outer, Locale locale, TimeZone timeZone, MediaType mediaType) {
        return new XmlParserSession(this.ctx, op, input, javaMethod, outer, locale, timeZone, mediaType);
    }

    @Override
    protected <T> T doParse(ParserSession session, ClassMeta<T> type) throws Exception {
        XmlParserSession s = (XmlParserSession)session;
        return this.parseAnything(s, type, null, s.getXmlStreamReader(), s.getOuter(), true, null);
    }

    @Override
    protected <K, V> Map<K, V> doParseIntoMap(ParserSession session, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        XmlParserSession s = (XmlParserSession)session;
        ClassMeta cm = session.getClassMeta(m.getClass(), keyType, valueType);
        return this.parseIntoMap(s, m, cm.getKeyType(), cm.getValueType());
    }

    @Override
    protected <E> Collection<E> doParseIntoCollection(ParserSession session, Collection<E> c, Type elementType) throws Exception {
        XmlParserSession s = (XmlParserSession)session;
        ClassMeta cm = session.getClassMeta(c.getClass(), elementType);
        return this.parseIntoCollection(s, c, cm.getElementType());
    }
}

