/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanMetaExtended;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;

public class XmlBeanMeta
extends BeanMetaExtended {
    private final Map<String, BeanPropertyMeta> attrs;
    private final Map<String, BeanPropertyMeta> elements;
    private final BeanPropertyMeta attrsProperty;
    private final Map<String, BeanPropertyMeta> collapsedProperties;
    private final BeanPropertyMeta contentProperty;
    private final XmlFormat contentFormat;

    public XmlBeanMeta(BeanMeta<?> beanMeta) {
        super(beanMeta);
        Class<?> c = beanMeta.getClassMeta().getInnerClass();
        XmlBeanMetaBuilder b = new XmlBeanMetaBuilder(beanMeta);
        this.attrs = Collections.unmodifiableMap(b.attrs);
        this.elements = Collections.unmodifiableMap(b.elements);
        this.attrsProperty = b.attrsProperty;
        this.collapsedProperties = Collections.unmodifiableMap(b.collapsedProperties);
        this.contentProperty = b.contentProperty;
        this.contentFormat = b.contentFormat;
        if (this.contentProperty != null || this.contentFormat == XmlFormat.VOID) {
            if (!this.elements.isEmpty()) {
                throw new BeanRuntimeException(c, "{0} and ELEMENT properties found on the same bean.  These cannot be mixed.", new Object[]{this.contentFormat});
            }
            if (!this.collapsedProperties.isEmpty()) {
                throw new BeanRuntimeException(c, "{0} and COLLAPSED properties found on the same bean.  These cannot be mixed.", new Object[]{this.contentFormat});
            }
        }
        if (!this.collapsedProperties.isEmpty() && !Collections.disjoint(this.elements.keySet(), this.collapsedProperties.keySet())) {
            throw new BeanRuntimeException(c, "Child element name conflicts found with another property.", new Object[0]);
        }
    }

    protected Map<String, BeanPropertyMeta> getAttrProperties() {
        return this.attrs;
    }

    protected Set<String> getAttrPropertyNames() {
        return this.attrs.keySet();
    }

    protected Map<String, BeanPropertyMeta> getElementProperties() {
        return this.elements;
    }

    protected Set<String> getElementPropertyNames() {
        return this.elements.keySet();
    }

    protected Map<String, BeanPropertyMeta> getCollapsedProperties() {
        return this.collapsedProperties;
    }

    protected Set<String> getCollapsedPropertyNames() {
        return this.collapsedProperties.keySet();
    }

    protected BeanPropertyMeta getAttrsProperty() {
        return this.attrsProperty;
    }

    protected String getAttrsPropertyName() {
        return this.attrsProperty == null ? null : this.attrsProperty.getName();
    }

    protected BeanPropertyMeta getContentProperty() {
        return this.contentProperty;
    }

    protected String getContentPropertyName() {
        return this.contentProperty == null ? null : this.contentProperty.getName();
    }

    protected XmlFormat getContentFormat() {
        return this.contentFormat;
    }

    protected BeanPropertyMeta getPropertyMeta(String fieldName) {
        BeanPropertyMeta bpm;
        if (this.collapsedProperties != null && (bpm = this.collapsedProperties.get(fieldName)) != null) {
            return bpm;
        }
        return this.getBeanMeta().getPropertyMeta(fieldName);
    }

    private static class XmlBeanMetaBuilder {
        Map<String, BeanPropertyMeta> attrs = new LinkedHashMap<String, BeanPropertyMeta>();
        Map<String, BeanPropertyMeta> elements = new LinkedHashMap<String, BeanPropertyMeta>();
        Map<String, BeanPropertyMeta> collapsedProperties = new LinkedHashMap<String, BeanPropertyMeta>();
        BeanPropertyMeta attrsProperty;
        BeanPropertyMeta contentProperty;
        XmlFormat contentFormat = XmlFormat.DEFAULT;

        XmlBeanMetaBuilder(BeanMeta<?> beanMeta) {
            Class<?> c = beanMeta.getClassMeta().getInnerClass();
            Xml xml = c.getAnnotation(Xml.class);
            XmlFormat defaultFormat = null;
            if (xml != null) {
                XmlFormat xf = xml.format();
                if (xf == XmlFormat.ATTRS) {
                    defaultFormat = XmlFormat.ATTR;
                } else if (xf.isOneOf(XmlFormat.ELEMENTS, XmlFormat.DEFAULT)) {
                    defaultFormat = XmlFormat.ELEMENT;
                } else if (xf == XmlFormat.VOID) {
                    this.contentFormat = XmlFormat.VOID;
                    defaultFormat = XmlFormat.VOID;
                } else {
                    throw new BeanRuntimeException(c, "Invalid format specified in @Xml annotation on bean: {0}.  Must be one of the following: DEFAULT,ATTRS,ELEMENTS,VOID", new Object[]{xml.format()});
                }
            }
            for (BeanPropertyMeta p : beanMeta.getPropertyMetas()) {
                String n;
                XmlFormat xf = p.getExtendedMeta(XmlBeanPropertyMeta.class).getXmlFormat();
                ClassMeta<?> pcm = p.getClassMeta();
                if (xf == XmlFormat.ATTR) {
                    this.attrs.put(p.getName(), p);
                } else if (xf == XmlFormat.ELEMENT) {
                    this.elements.put(p.getName(), p);
                } else if (xf == XmlFormat.COLLAPSED) {
                    this.collapsedProperties.put(p.getName(), p);
                } else if (xf == XmlFormat.DEFAULT) {
                    if (defaultFormat == XmlFormat.ATTR) {
                        this.attrs.put(p.getName(), p);
                    } else {
                        this.elements.put(p.getName(), p);
                    }
                } else if (xf == XmlFormat.ATTRS) {
                    if (this.attrsProperty != null) {
                        throw new BeanRuntimeException(c, "Multiple instances of ATTRS properties defined on class.  Only one property can be designated as such.", new Object[0]);
                    }
                    if (!pcm.isMapOrBean()) {
                        throw new BeanRuntimeException(c, "Invalid type for ATTRS property.  Only properties of type Map and bean can be used.", new Object[0]);
                    }
                    this.attrsProperty = p;
                } else if (xf.isOneOf(XmlFormat.ELEMENTS, XmlFormat.MIXED, XmlFormat.MIXED_PWS, XmlFormat.TEXT, XmlFormat.TEXT_PWS, XmlFormat.XMLTEXT)) {
                    if (xf.isOneOf(XmlFormat.ELEMENTS, XmlFormat.MIXED, XmlFormat.MIXED_PWS) && !pcm.isCollectionOrArray()) {
                        throw new BeanRuntimeException(c, "Invalid type for {0} property.  Only properties of type Collection and array can be used.", new Object[]{xf});
                    }
                    if (this.contentProperty != null) {
                        if (xf == this.contentFormat) {
                            throw new BeanRuntimeException(c, "Multiple instances of {0} properties defined on class.  Only one property can be designated as such.", new Object[]{xf});
                        }
                        throw new BeanRuntimeException(c, "{0} and {1} properties found on the same bean.  Only one property can be designated as such.", new Object[]{this.contentFormat, xf});
                    }
                    this.contentProperty = p;
                    this.contentFormat = xf;
                }
                if ((n = p.getExtendedMeta(XmlBeanPropertyMeta.class).getChildName()) == null) continue;
                if (this.collapsedProperties.containsKey(n) && this.collapsedProperties.get(n) != p) {
                    throw new BeanRuntimeException(c, "Multiple properties found with the child name ''{0}''.", n);
                }
                this.collapsedProperties.put(n, p);
            }
        }
    }
}

