/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.Consumes;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserReader;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.uon.UonParserSession;
import org.apache.juneau.uon.UonReader;
import org.apache.juneau.urlencoding.UrlEncodingParserBuilder;
import org.apache.juneau.urlencoding.UrlEncodingParserContext;
import org.apache.juneau.urlencoding.UrlEncodingParserSession;

@Consumes(value="application/x-www-form-urlencoded")
public class UrlEncodingParser
extends UonParser {
    public static final UrlEncodingParser DEFAULT = new UrlEncodingParser(PropertyStore.create());
    private final UrlEncodingParserContext ctx = this.createContext(UrlEncodingParserContext.class);

    public UrlEncodingParser(PropertyStore propertyStore) {
        super(propertyStore);
    }

    @Override
    public ObjectMap getOverrideProperties() {
        return super.getOverrideProperties().append("UonParser.decodeChars", true);
    }

    @Override
    public UrlEncodingParserBuilder builder() {
        return new UrlEncodingParserBuilder(this.propertyStore);
    }

    private <T> T parseAnything(UrlEncodingParserSession session, ClassMeta<T> eType, ParserReader r, Object outer) throws Exception {
        Object o;
        if (eType == null) {
            eType = this.object();
        }
        PojoSwap<T, Object> transform = eType.getPojoSwap();
        ClassMeta<?> sType = eType.getSerializedClassMeta();
        int c = r.peekSkipWs();
        if (c == 63) {
            r.read();
        }
        if (sType.isObject()) {
            ObjectMap m = new ObjectMap(session);
            this.parseIntoMap(session, r, m, session.getClassMeta((Type)((Object)Map.class), new Type[]{String.class, Object.class}), outer);
            o = m.containsKey("_value") ? m.get("_value") : session.cast(m, null, eType);
        } else if (sType.isMap()) {
            Map<String, Object> m = sType.canCreateNewInstance() ? (Map)sType.newInstance() : new ObjectMap(session);
            o = this.parseIntoMap(session, r, m, sType, m);
        } else if (sType.canCreateNewBean(outer)) {
            BeanMap<?> m = session.newBeanMap(outer, sType.getInnerClass());
            o = (m = this.parseIntoBeanMap(session, r, m)) == null ? null : m.getBean();
        } else if (sType.isCollection() || sType.isArray() || sType.isArgs()) {
            ObjectList c2 = sType.isArray() || sType.isArgs() || !sType.canCreateNewInstance(outer) ? new ObjectList(session) : (Collection)sType.newInstance();
            TreeMap m = new TreeMap();
            this.parseIntoMap(session, r, m, sType, c2);
            c2.addAll(m.values());
            o = sType.isArray() ? ArrayUtils.toArray(c2, sType.getElementType().getInnerClass()) : (sType.isArgs() ? c2.toArray(new Object[c2.size()]) : c2);
        } else {
            ObjectMap m = new ObjectMap(session);
            this.parseIntoMap(session, r, m, session.getClassMeta((Type)((Object)Map.class), new Type[]{String.class, Object.class}), outer);
            if (m.containsKey(session.getBeanTypePropertyName(eType))) {
                o = session.cast(m, null, eType);
            } else if (m.containsKey("_value")) {
                o = session.convertToType(m.get("_value"), sType);
            } else {
                if (sType.getNotABeanReason() != null) {
                    throw new ParseException(session, "Class ''{0}'' could not be instantiated as application/x-www-form-urlencoded.  Reason: ''{1}''", sType, sType.getNotABeanReason());
                }
                throw new ParseException(session, "Malformed application/x-www-form-urlencoded input for class ''{0}''.", sType);
            }
        }
        if (transform != null && o != null) {
            o = transform.unswap(session, o, eType);
        }
        if (outer != null) {
            this.setParent(eType, o, outer);
        }
        return (T)o;
    }

    private <K, V> Map<K, V> parseIntoMap(UonParserSession session, ParserReader r, Map<K, V> m, ClassMeta<?> type, Object outer) throws Exception {
        ClassMeta<Integer> keyType = type.isArgs() || type.isCollectionOrArray() ? session.getClassMeta(Integer.class) : type.getKeyType();
        int c = r.peekSkipWs();
        if (c == -1) {
            return m;
        }
        boolean S1 = true;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        boolean isInEscape = false;
        int state = 1;
        int argIndex = 0;
        Integer currAttr = null;
        while (c != -1) {
            c = r.read();
            if (!isInEscape) {
                if (state == 1) {
                    if (c == -1) {
                        return m;
                    }
                    r.unread();
                    Object attr = UrlEncodingParser.parseAttr(session, r, true);
                    currAttr = attr == null ? null : this.convertAttrToType(session, m, session.trim(attr.toString()), keyType);
                    state = 2;
                    c = 0;
                } else if (state == 2) {
                    if (c == 2) {
                        state = 3;
                    } else if (c == -1 || c == 1) {
                        m.put(currAttr, null);
                        if (c == -1) {
                            return m;
                        }
                        state = 1;
                    }
                } else if (state == 3) {
                    Object value;
                    ClassMeta<?> valueType;
                    if (c == -1 || c == 1) {
                        valueType = type.isArgs() ? type.getArg(argIndex++) : (type.isCollectionOrArray() ? type.getElementType() : type.getValueType());
                        value = this.convertAttrToType(session, m, "", valueType);
                        m.put(currAttr, value);
                        if (c == -1) {
                            return m;
                        }
                        state = 1;
                    } else {
                        valueType = type.isArgs() ? type.getArg(argIndex++) : (type.isCollectionOrArray() ? type.getElementType() : type.getValueType());
                        String string = value = valueType.isString() ? UonParser.parseString(session, r.unread(), true) : super.parseAnything(session, valueType, r.unread(), outer, true, null);
                        if (m.containsKey(currAttr) && valueType.isObject()) {
                            Object v2 = m.get(currAttr);
                            if (!(v2 instanceof ObjectList)) {
                                v2 = new ObjectList(v2).setBeanSession(session);
                                m.put(currAttr, v2);
                            }
                            ((ObjectList)v2).add(value);
                        } else {
                            m.put(currAttr, value);
                        }
                        state = 4;
                        c = 0;
                    }
                } else if (state == 4) {
                    if (c == 1) {
                        state = 1;
                    } else if (c == -1) {
                        return m;
                    }
                }
            }
            isInEscape = c == 92 && !isInEscape;
        }
        if (state == 1) {
            throw new ParseException(session, "Could not find attribute name on object.", new Object[0]);
        }
        if (state == 2) {
            throw new ParseException(session, "Could not find '=' following attribute name on object.", new Object[0]);
        }
        if (state == 3) {
            throw new ParseException(session, "Dangling '=' found in object entry", new Object[0]);
        }
        if (state == 4) {
            throw new ParseException(session, "Could not find end of object.", new Object[0]);
        }
        return null;
    }

    private <T> BeanMap<T> parseIntoBeanMap(UrlEncodingParserSession session, ParserReader r, BeanMap<T> m) throws Exception {
        int c = r.peekSkipWs();
        if (c == -1) {
            return m;
        }
        boolean S1 = true;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        boolean isInEscape = false;
        int state = 1;
        String currAttr = "";
        int currAttrLine = -1;
        int currAttrCol = -1;
        while (c != -1) {
            c = r.read();
            if (!isInEscape) {
                if (state == 1) {
                    if (c == -1) {
                        return m;
                    }
                    r.unread();
                    currAttrLine = r.getLine();
                    currAttrCol = r.getColumn();
                    currAttr = UrlEncodingParser.parseAttrName(session, r, true);
                    if (currAttr == null) {
                        return null;
                    }
                    state = 2;
                } else if (state == 2) {
                    if (c == 2) {
                        state = 3;
                    } else if (c == -1 || c == 1) {
                        m.put(currAttr, (Object)null);
                        if (c == -1) {
                            return m;
                        }
                        state = 1;
                    }
                } else if (state == 3) {
                    ClassMeta<?> cm;
                    BeanPropertyMeta pMeta;
                    if (c == -1 || c == 1) {
                        if (!currAttr.equals(session.getBeanTypePropertyName(m.getClassMeta()))) {
                            pMeta = m.getPropertyMeta(currAttr);
                            if (pMeta == null) {
                                this.onUnknownProperty(session, currAttr, m, currAttrLine, currAttrCol);
                            } else {
                                session.setCurrentProperty(pMeta);
                                cm = pMeta.getClassMeta();
                                if (cm.canCreateNewInstance()) {
                                    pMeta.set(m, cm.newInstance());
                                }
                                session.setCurrentProperty(null);
                            }
                        }
                        if (c == -1) {
                            return m;
                        }
                        state = 1;
                    } else {
                        if (!currAttr.equals(session.getBeanTypePropertyName(m.getClassMeta()))) {
                            pMeta = m.getPropertyMeta(currAttr);
                            if (pMeta == null) {
                                this.onUnknownProperty(session, currAttr, m, currAttrLine, currAttrCol);
                                this.parseAnything(session, this.object(), r.unread(), m.getBean(false), true, null);
                            } else {
                                Object value;
                                session.setCurrentProperty(pMeta);
                                if (session.shouldUseExpandedParams(pMeta)) {
                                    ClassMeta<?> et = pMeta.getClassMeta().getElementType();
                                    value = this.parseAnything(session, et, r.unread(), m.getBean(false), true, pMeta);
                                    this.setName(et, value, currAttr);
                                    pMeta.add(m, value);
                                } else {
                                    cm = pMeta.getClassMeta();
                                    value = this.parseAnything(session, cm, r.unread(), m.getBean(false), true, pMeta);
                                    this.setName(cm, value, currAttr);
                                    pMeta.set(m, value);
                                }
                                session.setCurrentProperty(null);
                            }
                        }
                        state = 4;
                    }
                } else if (state == 4) {
                    if (c == 1) {
                        state = 1;
                    } else if (c == -1) {
                        return m;
                    }
                }
            }
            isInEscape = c == 92 && !isInEscape;
        }
        if (state == 1) {
            throw new ParseException(session, "Could not find attribute name on object.", new Object[0]);
        }
        if (state == 2) {
            throw new ParseException(session, "Could not find '=' following attribute name on object.", new Object[0]);
        }
        if (state == 3) {
            throw new ParseException(session, "Could not find value following '=' on object.", new Object[0]);
        }
        if (state == 4) {
            throw new ParseException(session, "Could not find end of object.", new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String[]> parseIntoSimpleMap(String qs) throws Exception {
        TreeMap<String, String[]> m = new TreeMap<String, String[]>();
        if (StringUtils.isEmpty(qs)) {
            return m;
        }
        UonReader r = new UonReader(qs, true);
        boolean S1 = true;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        try {
            int c = r.peekSkipWs();
            if (c == 63) {
                r.read();
            }
            int state = 1;
            String currAttr = null;
            while (c != -1) {
                c = r.read();
                if (state == 1) {
                    if (c == -1) continue;
                    r.unread();
                    r.mark();
                    state = 2;
                    continue;
                }
                if (state == 2) {
                    if (c == -1) {
                        UrlEncodingParser.add(m, r.getMarked(), null);
                        continue;
                    }
                    if (c == 1) {
                        m.put(r.getMarked(0, -1), null);
                        state = 1;
                        continue;
                    }
                    if (c != 2) continue;
                    currAttr = r.getMarked(0, -1);
                    state = 3;
                    continue;
                }
                if (state == 3) {
                    if (c == -1 || c == 1) {
                        UrlEncodingParser.add(m, currAttr, "");
                        continue;
                    }
                    if (c == 2) {
                        r.replace('=');
                    }
                    r.unread();
                    r.mark();
                    state = 4;
                    continue;
                }
                if (state != 4) continue;
                if (c == -1) {
                    UrlEncodingParser.add(m, currAttr, r.getMarked());
                    continue;
                }
                if (c == 1) {
                    UrlEncodingParser.add(m, currAttr, r.getMarked(0, -1));
                    state = 1;
                    continue;
                }
                if (c != 2) continue;
                r.replace('=');
            }
        }
        finally {
            r.close();
        }
        return m;
    }

    private static void add(Map<String, String[]> m, String key, String val) {
        boolean b = m.containsKey(key);
        if (val == null) {
            if (!b) {
                m.put(key, null);
            }
        } else if (b && m.get(key) != null) {
            m.put(key, ArrayUtils.append((Object[])m.get(key), val));
        } else {
            m.put(key, new String[]{val});
        }
    }

    public <T> T parsePart(String in, Type type, Type ... args) throws ParseException {
        if (in == null) {
            return null;
        }
        return this.parsePart(in, this.getBeanContext().getClassMeta(type, args));
    }

    public <T> T parsePart(String in, Class<T> type) throws ParseException {
        if (in == null) {
            return null;
        }
        return this.parsePart(in, this.getBeanContext().getClassMeta(type));
    }

    public <T> T parsePart(String in, ClassMeta<T> type) throws ParseException {
        if (in == null) {
            return null;
        }
        if (type.isString() && in.length() > 0) {
            char x = StringUtils.firstNonWhitespaceChar(in);
            if (x != '\'' && x != 'n' && in.indexOf(126) == -1) {
                return (T)in;
            }
            if (x == 'n' && "null".equals(in)) {
                return null;
            }
        }
        UonParserSession session = this.createParameterSession(in);
        try {
            UonReader r = session.getReader();
            T t = super.parseAnything(session, type, r, null, true, null);
            return t;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(session, e);
        }
        finally {
            session.close();
        }
    }

    @Override
    public UrlEncodingParserSession createSession(Object input, ObjectMap op, Method javaMethod, Object outer, Locale locale, TimeZone timeZone, MediaType mediaType) {
        return new UrlEncodingParserSession(this.ctx, op, input, javaMethod, outer, locale, timeZone, mediaType);
    }

    @Override
    protected <T> T doParse(ParserSession session, ClassMeta<T> type) throws Exception {
        UrlEncodingParserSession s = (UrlEncodingParserSession)session;
        UonReader r = s.getReader();
        T o = this.parseAnything(s, type, r, s.getOuter());
        return o;
    }

    @Override
    protected <K, V> Map<K, V> doParseIntoMap(ParserSession session, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        UrlEncodingParserSession s = (UrlEncodingParserSession)session;
        UonReader r = s.getReader();
        if (r.peekSkipWs() == 63) {
            r.read();
        }
        m = this.parseIntoMap(s, r, m, session.getClassMeta((Type)((Object)Map.class), keyType, valueType), null);
        return m;
    }
}

