/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.msgpack;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.msgpack.MsgPackOutputStream;
import org.apache.juneau.msgpack.MsgPackSerializerBuilder;
import org.apache.juneau.msgpack.MsgPackSerializerContext;
import org.apache.juneau.msgpack.MsgPackSerializerSession;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.transform.PojoSwap;

@Produces(value="octal/msgpack")
public class MsgPackSerializer
extends OutputStreamSerializer {
    public static final MsgPackSerializer DEFAULT = new MsgPackSerializer(PropertyStore.create());
    private final MsgPackSerializerContext ctx = this.createContext(MsgPackSerializerContext.class);

    public MsgPackSerializer(PropertyStore propertyStore) {
        super(propertyStore);
    }

    @Override
    public MsgPackSerializerBuilder builder() {
        return new MsgPackSerializerBuilder(this.propertyStore);
    }

    MsgPackOutputStream serializeAnything(MsgPackSerializerSession session, MsgPackOutputStream out, Object o, ClassMeta<?> eType, String attrName, BeanPropertyMeta pMeta) throws Exception {
        ClassMeta<Object> aType;
        boolean isRecursion;
        if (o == null) {
            return out.appendNull();
        }
        if (eType == null) {
            eType = this.object();
        }
        boolean bl = isRecursion = (aType = session.push(attrName, o, eType)) == null;
        if (aType == null) {
            o = null;
            aType = this.object();
        }
        ClassMeta<Object> sType = aType.getSerializedClassMeta();
        String typeName = session.getBeanTypeName(eType, aType, pMeta);
        PojoSwap<Object, ?> swap = aType.getPojoSwap();
        if (swap != null) {
            o = swap.swap(session, o);
            if (sType.isObject()) {
                sType = session.getClassMetaForObject(o);
            }
        }
        if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
            out.appendNull();
        } else if (sType.isBoolean()) {
            out.appendBoolean((Boolean)o);
        } else if (sType.isNumber()) {
            out.appendNumber((Number)o);
        } else if (sType.isBean()) {
            this.serializeBeanMap(session, out, session.toBeanMap(o), typeName);
        } else if (sType.isUri() || pMeta != null && pMeta.isUri()) {
            out.appendString(session.resolveUri(o.toString()));
        } else if (sType.isMap()) {
            if (o instanceof BeanMap) {
                this.serializeBeanMap(session, out, (BeanMap)o, typeName);
            } else {
                this.serializeMap(session, out, (Map)o, eType);
            }
        } else if (sType.isCollection()) {
            this.serializeCollection(session, out, (Collection)o, eType);
        } else if (sType.isArray()) {
            this.serializeCollection(session, out, MsgPackSerializer.toList(sType.getInnerClass(), o), eType);
        } else {
            out.appendString(session.toString(o));
        }
        if (!isRecursion) {
            session.pop();
        }
        return out;
    }

    private void serializeMap(MsgPackSerializerSession session, MsgPackOutputStream out, Map m, ClassMeta<?> type) throws Exception {
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        m = session.sort(m);
        ArrayList<SimpleMapEntry> entries = new ArrayList<SimpleMapEntry>(m.size());
        for (Map.Entry entry : m.entrySet()) {
            entries.add(new SimpleMapEntry(entry.getKey(), entry.getValue()));
        }
        out.startMap(entries.size());
        for (SimpleMapEntry simpleMapEntry : entries) {
            Object value = simpleMapEntry.value;
            Object key = session.generalize(simpleMapEntry.key, keyType);
            this.serializeAnything(session, out, key, keyType, null, null);
            this.serializeAnything(session, out, value, valueType, null, null);
        }
    }

    private void serializeBeanMap(MsgPackSerializerSession session, MsgPackOutputStream out, BeanMap<?> m, String typeName) throws Exception {
        List<BeanPropertyValue> values = m.getValues(session.isTrimNulls(), typeName != null ? session.createBeanTypeNameProperty(m, typeName) : null);
        int size = values.size();
        for (BeanPropertyValue p : values) {
            if (p.getThrown() == null) continue;
            --size;
        }
        out.startMap(size);
        for (BeanPropertyValue p : values) {
            BeanPropertyMeta pMeta = p.getMeta();
            ClassMeta<?> cMeta = p.getClassMeta();
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                session.addBeanGetterWarning(pMeta, t);
                continue;
            }
            this.serializeAnything(session, out, key, null, null, null);
            this.serializeAnything(session, out, value, cMeta, key, pMeta);
        }
    }

    private void serializeCollection(MsgPackSerializerSession session, MsgPackOutputStream out, Collection c, ClassMeta<?> type) throws Exception {
        ClassMeta<?> elementType = type.getElementType();
        ArrayList l = new ArrayList(c.size());
        c = session.sort(c);
        l.addAll(c);
        out.startArray(l.size());
        for (Object o : l) {
            this.serializeAnything(session, out, o, elementType, "<iterator>", null);
        }
    }

    @Override
    public MsgPackSerializerSession createSession(Object output, ObjectMap op, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType) {
        return new MsgPackSerializerSession(this.ctx, op, output, javaMethod, locale, timeZone, mediaType);
    }

    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        MsgPackSerializerSession s = (MsgPackSerializerSession)session;
        this.serializeAnything(s, s.getOutputStream(), o, s.getExpectedRootType(o), "root", null);
    }

    private static class SimpleMapEntry {
        final Object key;
        final Object value;

        private SimpleMapEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

