/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.msgpack;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.Consumes;
import org.apache.juneau.msgpack.DataType;
import org.apache.juneau.msgpack.MsgPackInputStream;
import org.apache.juneau.msgpack.MsgPackParserBuilder;
import org.apache.juneau.msgpack.MsgPackParserContext;
import org.apache.juneau.msgpack.MsgPackParserSession;
import org.apache.juneau.parser.InputStreamParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.transform.PojoSwap;

@Consumes(value="octal/msgpack")
public class MsgPackParser
extends InputStreamParser {
    public static final MsgPackParser DEFAULT = new MsgPackParser(PropertyStore.create());
    private final MsgPackParserContext ctx = this.createContext(MsgPackParserContext.class);

    public MsgPackParser(PropertyStore propertyStore) {
        super(propertyStore);
    }

    @Override
    public MsgPackParserBuilder builder() {
        return new MsgPackParserBuilder(this.propertyStore);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T parseAnything(MsgPackParserSession session, ClassMeta<T> eType, MsgPackInputStream is, Object outer, BeanPropertyMeta pMeta) throws Exception {
        if (eType == null) {
            eType = this.object();
        }
        PojoSwap<Object, Object> transform = eType.getPojoSwap();
        ClassMeta<?> sType = eType.getSerializedClassMeta();
        session.setCurrentClass(sType);
        Object o = null;
        DataType dt = is.readDataType();
        int length = (int)is.readLength();
        if (dt != DataType.NULL) {
            int i;
            if (dt == DataType.BOOLEAN) {
                o = is.readBoolean();
            } else if (dt == DataType.INT) {
                o = is.readInt();
            } else if (dt == DataType.LONG) {
                o = is.readLong();
            } else if (dt == DataType.FLOAT) {
                o = Float.valueOf(is.readFloat());
            } else if (dt == DataType.DOUBLE) {
                o = is.readDouble();
            } else if (dt == DataType.STRING) {
                o = session.trim(is.readString());
            } else if (dt == DataType.BIN) {
                o = is.readBinary();
            } else if (dt == DataType.ARRAY && sType.isObject()) {
                ObjectList ol = new ObjectList(session);
                for (i = 0; i < length; ++i) {
                    ol.add(this.parseAnything(session, this.object(), is, outer, pMeta));
                }
                o = ol;
            } else if (dt == DataType.MAP && sType.isObject()) {
                ObjectMap om = new ObjectMap(session);
                for (i = 0; i < length; ++i) {
                    om.put(this.parseAnything(session, this.string(), is, outer, pMeta), this.parseAnything(session, this.object(), is, om, pMeta));
                }
                o = session.cast(om, pMeta, eType);
            }
            if (!sType.isObject()) {
                Collection<Object> l;
                Map<String, Object> m;
                if (sType.isBoolean() || sType.isCharSequence() || sType.isChar() || sType.isNumber()) {
                    o = session.convertToType(o, sType);
                } else if (sType.isMap()) {
                    if (dt != DataType.MAP) throw new ParseException(session, "Invalid data type {0} encountered for parse type {1}", new Object[]{dt, sType});
                    m = sType.canCreateNewInstance(outer) ? (Map)sType.newInstance(outer) : new ObjectMap(session);
                    for (i = 0; i < length; ++i) {
                        Object key = this.parseAnything(session, sType.getKeyType(), is, outer, pMeta);
                        ClassMeta<?> vt = sType.getValueType();
                        Object value = this.parseAnything(session, vt, is, m, pMeta);
                        this.setName(vt, value, key);
                        m.put((String)key, value);
                    }
                    o = m;
                } else if (sType.canCreateNewBean(outer)) {
                    if (dt != DataType.MAP) throw new ParseException(session, "Invalid data type {0} encountered for parse type {1}", new Object[]{dt, sType});
                    m = session.newBeanMap(outer, sType.getInnerClass());
                    for (i = 0; i < length; ++i) {
                        String pName = this.parseAnything(session, this.string(), is, ((BeanMap)m).getBean(false), null);
                        BeanPropertyMeta bpm = ((BeanMap)m).getPropertyMeta(pName);
                        if (bpm == null) {
                            if (pName.equals(session.getBeanTypePropertyName(eType))) {
                                this.parseAnything(session, session.string(), is, null, null);
                                continue;
                            }
                            this.onUnknownProperty(session, pName, m, 0, is.getPosition());
                            continue;
                        }
                        ClassMeta<?> cm = bpm.getClassMeta();
                        Object value = this.parseAnything(session, cm, is, ((BeanMap)m).getBean(false), bpm);
                        this.setName(cm, value, pName);
                        bpm.set((BeanMap<?>)m, value);
                    }
                    o = ((BeanMap)m).getBean();
                } else if (sType.canCreateNewInstanceFromString(outer) && dt == DataType.STRING) {
                    o = sType.newInstanceFromString(outer, o == null ? "" : o.toString());
                } else if (sType.canCreateNewInstanceFromNumber(outer) && dt.isOneOf(DataType.INT, DataType.LONG, DataType.FLOAT, DataType.DOUBLE)) {
                    o = sType.newInstanceFromNumber(session, outer, (Number)o);
                } else if (sType.isCollection()) {
                    if (dt == DataType.MAP) {
                        m = new ObjectMap(session);
                        for (i = 0; i < length; ++i) {
                            ((HashMap)m).put(this.parseAnything(session, this.string(), is, outer, pMeta), this.parseAnything(session, this.object(), is, m, pMeta));
                        }
                        o = session.cast((ObjectMap)m, pMeta, eType);
                    } else {
                        if (dt != DataType.ARRAY) throw new ParseException(session, "Invalid data type {0} encountered for parse type {1}", new Object[]{dt, sType});
                        l = sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance() : new ObjectList(session);
                        for (i = 0; i < length; ++i) {
                            l.add(this.parseAnything(session, sType.getElementType(), is, l, pMeta));
                        }
                        o = l;
                    }
                } else if (sType.isArray() || sType.isArgs()) {
                    if (dt == DataType.MAP) {
                        m = new ObjectMap(session);
                        for (i = 0; i < length; ++i) {
                            ((HashMap)m).put(this.parseAnything(session, this.string(), is, outer, pMeta), this.parseAnything(session, this.object(), is, m, pMeta));
                        }
                        o = session.cast((ObjectMap)m, pMeta, eType);
                    } else {
                        if (dt != DataType.ARRAY) throw new ParseException(session, "Invalid data type {0} encountered for parse type {1}", new Object[]{dt, sType});
                        l = sType.isCollection() && sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance() : new ObjectList(session);
                        for (i = 0; i < length; ++i) {
                            l.add(this.parseAnything(session, sType.isArgs() ? sType.getArg(i) : sType.getElementType(), is, l, pMeta));
                        }
                        o = session.toArray(sType, l);
                    }
                } else {
                    if (dt != DataType.MAP) throw new ParseException(session, "Invalid data type {0} encountered for parse type {1}", new Object[]{dt, sType});
                    m = new ObjectMap(session);
                    for (i = 0; i < length; ++i) {
                        ((HashMap)m).put(this.parseAnything(session, this.string(), is, outer, pMeta), this.parseAnything(session, this.object(), is, m, pMeta));
                    }
                    if (!((ObjectMap)m).containsKey(session.getBeanTypePropertyName(eType))) throw new ParseException(session, "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", sType.getInnerClass().getName(), sType.getNotABeanReason());
                    o = session.cast((ObjectMap)m, pMeta, eType);
                }
            }
        }
        if (transform != null && o != null) {
            o = transform.unswap(session, o, eType);
        }
        if (outer == null) return (T)o;
        this.setParent(eType, o, outer);
        return (T)o;
    }

    @Override
    public MsgPackParserSession createSession(Object input, ObjectMap op, Method javaMethod, Object outer, Locale locale, TimeZone timeZone, MediaType mediaType) {
        return new MsgPackParserSession(this.ctx, op, input, javaMethod, outer, locale, timeZone, mediaType);
    }

    @Override
    protected <T> T doParse(ParserSession session, ClassMeta<T> type) throws Exception {
        MsgPackParserSession s = (MsgPackParserSession)session;
        MsgPackInputStream is = s.getInputStream();
        T o = this.parseAnything(s, type, is, s.getOuter(), null);
        return o;
    }
}

