/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.Consumes;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonClassMeta;
import org.apache.juneau.json.JsonParserBuilder;
import org.apache.juneau.json.JsonParserContext;
import org.apache.juneau.json.JsonParserSession;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserReader;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.transform.PojoSwap;

@Consumes(value="application/json,text/json")
public class JsonParser
extends ReaderParser {
    public static final JsonParser DEFAULT = new JsonParser(PropertyStore.create());
    public static final JsonParser DEFAULT_STRICT = new Strict(PropertyStore.create());
    private static final AsciiSet decChars = new AsciiSet("0123456789");
    private final JsonParserContext ctx = this.createContext(JsonParserContext.class);

    public JsonParser(PropertyStore propertyStore) {
        super(propertyStore);
    }

    @Override
    public JsonParserBuilder builder() {
        return new JsonParserBuilder(this.propertyStore);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T parseAnything(JsonParserSession session, ClassMeta<T> eType, ParserReader r, Object outer, BeanPropertyMeta pMeta) throws Exception {
        int c;
        if (eType == null) {
            eType = this.object();
        }
        PojoSwap<Object, Object> transform = eType.getPojoSwap();
        ClassMeta<?> sType = eType.getSerializedClassMeta();
        session.setCurrentClass(sType);
        String wrapperAttr = sType.getExtendedMeta(JsonClassMeta.class).getWrapperAttr();
        Object o = null;
        JsonParser.skipCommentsAndSpace(session, r);
        if (wrapperAttr != null) {
            this.skipWrapperAttrStart(session, r, wrapperAttr);
        }
        if ((c = r.peek()) == -1) {
            if (session.isStrict()) {
                throw new ParseException(session, "Empty input.", new Object[0]);
            }
        } else if (c == 44 || c == 125 || c == 93) {
            if (session.isStrict()) {
                throw new ParseException(session, "Missing value detected.", new Object[0]);
            }
        } else if (c == 110) {
            JsonParser.parseKeyword(session, "null", r);
        } else if (sType.isObject()) {
            if (c == 123) {
                ObjectMap objectMap = new ObjectMap(session);
                this.parseIntoMap2(session, r, objectMap, this.string(), this.object(), pMeta);
                o = session.cast(objectMap, pMeta, eType);
            } else if (c == 91) {
                o = this.parseIntoCollection2(session, r, new ObjectList(session), this.object(), pMeta);
            } else if (c == 39 || c == 34) {
                o = this.parseString(session, r);
                if (sType.isChar()) {
                    o = Character.valueOf(o.toString().charAt(0));
                }
            } else if (c >= 48 && c <= 57 || c == 45 || c == 46) {
                o = this.parseNumber(session, r, null);
            } else if (c == 116) {
                JsonParser.parseKeyword(session, "true", r);
                o = Boolean.TRUE;
            } else {
                JsonParser.parseKeyword(session, "false", r);
                o = Boolean.FALSE;
            }
        } else if (sType.isBoolean()) {
            o = this.parseBoolean(session, r);
        } else if (sType.isCharSequence()) {
            o = this.parseString(session, r);
        } else if (sType.isChar()) {
            o = Character.valueOf(this.parseString(session, r).charAt(0));
        } else if (sType.isNumber()) {
            o = this.parseNumber(session, r, sType.getInnerClass());
        } else if (sType.isMap()) {
            Map<String, Object> map = sType.canCreateNewInstance(outer) ? (Map)sType.newInstance(outer) : new ObjectMap(session);
            o = this.parseIntoMap2(session, r, map, sType.getKeyType(), sType.getValueType(), pMeta);
        } else if (sType.isCollection()) {
            if (c == 123) {
                ObjectMap objectMap = new ObjectMap(session);
                this.parseIntoMap2(session, r, objectMap, this.string(), this.object(), pMeta);
                o = session.cast(objectMap, pMeta, eType);
            } else {
                Collection<Object> collection = sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance() : new ObjectList(session);
                o = this.parseIntoCollection2(session, r, collection, sType, pMeta);
            }
        } else if (sType.canCreateNewBean(outer)) {
            BeanMap<?> beanMap = session.newBeanMap(outer, sType.getInnerClass());
            o = this.parseIntoBeanMap2(session, r, beanMap).getBean();
        } else if (sType.canCreateNewInstanceFromString(outer) && (c == 39 || c == 34)) {
            o = sType.newInstanceFromString(outer, this.parseString(session, r));
        } else if (sType.canCreateNewInstanceFromNumber(outer) && StringUtils.isFirstNumberChar((char)c)) {
            o = sType.newInstanceFromNumber(session, outer, this.parseNumber(session, r, sType.getNewInstanceFromNumberClass()));
        } else if (sType.isArray() || sType.isArgs()) {
            if (c == 123) {
                ObjectMap objectMap = new ObjectMap(session);
                this.parseIntoMap2(session, r, objectMap, this.string(), this.object(), pMeta);
                o = session.cast(objectMap, pMeta, eType);
            } else {
                ArrayList arrayList = (ArrayList)this.parseIntoCollection2(session, r, new ArrayList(), sType, pMeta);
                o = session.toArray(sType, arrayList);
            }
        } else if (c == 123) {
            ObjectMap objectMap = new ObjectMap(session);
            this.parseIntoMap2(session, r, objectMap, sType.getKeyType(), sType.getValueType(), pMeta);
            if (!objectMap.containsKey(session.getBeanTypePropertyName(eType))) throw new ParseException(session, "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", sType.getInnerClass().getName(), sType.getNotABeanReason());
            o = session.cast(objectMap, pMeta, eType);
        } else {
            if (!sType.canCreateNewInstanceFromString(outer) || session.isStrict()) throw new ParseException(session, "Unrecognized syntax for class type ''{0}'', starting character ''{1}''", sType, Character.valueOf((char)c));
            o = sType.newInstanceFromString(outer, this.parseString(session, r));
        }
        if (wrapperAttr != null) {
            JsonParser.skipWrapperAttrEnd(session, r);
        }
        if (transform != null && o != null) {
            o = transform.unswap(session, o, eType);
        }
        if (outer == null) return (T)o;
        this.setParent(eType, o, outer);
        return (T)o;
    }

    private Number parseNumber(JsonParserSession session, ParserReader r, Class<? extends Number> type) throws Exception {
        int c = r.peek();
        if (c == 39 || c == 34) {
            return JsonParser.parseNumber(session, this.parseString(session, r), type);
        }
        return JsonParser.parseNumber(session, StringUtils.parseNumberString(r), type);
    }

    private static Number parseNumber(JsonParserSession session, String s, Class<? extends Number> type) throws Exception {
        if (session.isStrict()) {
            char c2;
            if (s.length() == 0) {
                throw new ParseException(session, "Invalid JSON number: '" + s + "'", new Object[0]);
            }
            boolean isNegative = false;
            int c = s.charAt(0);
            if (c == 45) {
                isNegative = true;
                int n = c = s.length() == 1 ? 120 : (int)s.charAt(1);
            }
            if (c == 46) {
                throw new ParseException(session, "Invalid JSON number: '" + s + "'", new Object[0]);
            }
            if (c == 48 && s.length() > (isNegative ? 2 : 1) && (c2 = s.charAt(isNegative ? 2 : 1)) != '.' && c2 != 'e' && c2 != 'E') {
                throw new ParseException(session, "Invalid JSON number: '" + s + "'", new Object[0]);
            }
            int i = s.indexOf(46);
            if (!(i == -1 || s.length() != i + 1 && decChars.contains(s.charAt(i + 1)))) {
                throw new ParseException(session, "Invalid JSON number: '" + s + "'", new Object[0]);
            }
        }
        return StringUtils.parseNumber(s, type);
    }

    private Boolean parseBoolean(JsonParserSession session, ParserReader r) throws Exception {
        int c = r.peek();
        if (c == 39 || c == 34) {
            return Boolean.valueOf(this.parseString(session, r));
        }
        if (c == 116) {
            JsonParser.parseKeyword(session, "true", r);
            return Boolean.TRUE;
        }
        JsonParser.parseKeyword(session, "false", r);
        return Boolean.FALSE;
    }

    private <K, V> Map<K, V> parseIntoMap2(JsonParserSession session, ParserReader r, Map<K, V> m, ClassMeta<K> keyType, ClassMeta<V> valueType, BeanPropertyMeta pMeta) throws Exception {
        if (keyType == null) {
            keyType = this.string();
        }
        int S0 = 0;
        int S1 = 1;
        int S3 = 3;
        int S4 = 4;
        int S5 = 5;
        int S6 = 6;
        int state = S0;
        String currAttr = null;
        int c = 0;
        while (c != -1) {
            c = r.read();
            if (state == S0) {
                if (c != 123) continue;
                state = S1;
                continue;
            }
            if (state == S1) {
                if (c == 125) {
                    return m;
                }
                if (session.isCommentOrWhitespace(c)) {
                    JsonParser.skipCommentsAndSpace(session, r.unread());
                    continue;
                }
                currAttr = this.parseFieldName(session, r.unread());
                state = S3;
                continue;
            }
            if (state == S3) {
                if (c != 58) continue;
                state = S4;
                continue;
            }
            if (state == S4) {
                if (session.isCommentOrWhitespace(c)) {
                    JsonParser.skipCommentsAndSpace(session, r.unread());
                    continue;
                }
                K key = this.convertAttrToType(session, m, currAttr, keyType);
                V value = this.parseAnything(session, valueType, r.unread(), m, pMeta);
                this.setName(valueType, value, key);
                m.put(key, value);
                state = S5;
                continue;
            }
            if (state == S5) {
                if (c == 44) {
                    state = S6;
                    continue;
                }
                if (session.isCommentOrWhitespace(c)) {
                    JsonParser.skipCommentsAndSpace(session, r.unread());
                    continue;
                }
                if (c != 125) break;
                return m;
            }
            if (state != S6) continue;
            if (c == 125) break;
            if (session.isCommentOrWhitespace(c)) {
                JsonParser.skipCommentsAndSpace(session, r.unread());
                continue;
            }
            currAttr = this.parseFieldName(session, r.unread());
            state = S3;
        }
        if (state == S0) {
            throw new ParseException(session, "Expected '{' at beginning of JSON object.", new Object[0]);
        }
        if (state == S1) {
            throw new ParseException(session, "Could not find attribute name on JSON object.", new Object[0]);
        }
        if (state == S3) {
            throw new ParseException(session, "Could not find ':' following attribute name on JSON object.", new Object[0]);
        }
        if (state == S4) {
            throw new ParseException(session, "Expected one of the following characters: {,[,',\",LITERAL.", new Object[0]);
        }
        if (state == S5) {
            throw new ParseException(session, "Could not find '}' marking end of JSON object.", new Object[0]);
        }
        if (state == S6) {
            throw new ParseException(session, "Unexpected '}' found in JSON object.", new Object[0]);
        }
        return null;
    }

    private String parseFieldName(JsonParserSession session, ParserReader r) throws Exception {
        int c = r.peek();
        if (c == 39 || c == 34) {
            return this.parseString(session, r);
        }
        if (session.isStrict()) {
            throw new ParseException(session, "Unquoted attribute detected.", new Object[0]);
        }
        r.mark();
        while (c != -1) {
            c = r.read();
            if (c != 58 && !session.isWhitespace(c) && c != 47) continue;
            r.unread();
            String s = r.getMarked().intern();
            return s.equals("null") ? null : s;
        }
        throw new ParseException(session, "Could not find the end of the field name.", new Object[0]);
    }

    private <E> Collection<E> parseIntoCollection2(JsonParserSession session, ParserReader r, Collection<E> l, ClassMeta<?> type, BeanPropertyMeta pMeta) throws Exception {
        int S0 = 0;
        int S1 = 1;
        int S2 = 2;
        int S3 = 3;
        int argIndex = 0;
        int state = S0;
        int c = 0;
        while (c != -1) {
            c = r.read();
            if (state == S0) {
                if (c != 91) continue;
                state = S1;
                continue;
            }
            if (state == S1) {
                if (c == 93) {
                    return l;
                }
                if (session.isCommentOrWhitespace(c)) {
                    JsonParser.skipCommentsAndSpace(session, r.unread());
                    continue;
                }
                if (c == -1) continue;
                l.add(this.parseAnything(session, type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), r.unread(), l, pMeta));
                state = S2;
                continue;
            }
            if (state == S2) {
                if (c == 44) {
                    state = S3;
                    continue;
                }
                if (session.isCommentOrWhitespace(c)) {
                    JsonParser.skipCommentsAndSpace(session, r.unread());
                    continue;
                }
                if (c != 93) break;
                return l;
            }
            if (state != S3) continue;
            if (session.isCommentOrWhitespace(c)) {
                JsonParser.skipCommentsAndSpace(session, r.unread());
                continue;
            }
            if (c == 93) break;
            if (c == -1) continue;
            l.add(this.parseAnything(session, type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), r.unread(), l, pMeta));
            state = S2;
        }
        if (state == S0) {
            throw new ParseException(session, "Expected '[' at beginning of JSON array.", new Object[0]);
        }
        if (state == S1) {
            throw new ParseException(session, "Expected one of the following characters: {,[,',\",LITERAL.", new Object[0]);
        }
        if (state == S2) {
            throw new ParseException(session, "Expected ',' or ']'.", new Object[0]);
        }
        if (state == S3) {
            throw new ParseException(session, "Unexpected trailing comma in array.", new Object[0]);
        }
        return null;
    }

    private <T> BeanMap<T> parseIntoBeanMap2(JsonParserSession session, ParserReader r, BeanMap<T> m) throws Exception {
        int S0 = 0;
        int S1 = 1;
        int S3 = 3;
        int S4 = 4;
        int S5 = 5;
        int state = S0;
        String currAttr = "";
        int c = 0;
        int currAttrLine = -1;
        int currAttrCol = -1;
        while (c != -1) {
            c = r.read();
            if (state == S0) {
                if (c != 123) continue;
                state = S1;
                continue;
            }
            if (state == S1) {
                if (c == 125) {
                    return m;
                }
                if (session.isCommentOrWhitespace(c)) {
                    JsonParser.skipCommentsAndSpace(session, r.unread());
                    continue;
                }
                r.unread();
                currAttrLine = r.getLine();
                currAttrCol = r.getColumn();
                currAttr = this.parseFieldName(session, r);
                state = S3;
                continue;
            }
            if (state == S3) {
                if (c != 58) continue;
                state = S4;
                continue;
            }
            if (state == S4) {
                if (session.isCommentOrWhitespace(c)) {
                    JsonParser.skipCommentsAndSpace(session, r.unread());
                    continue;
                }
                if (!currAttr.equals(session.getBeanTypePropertyName(m.getClassMeta()))) {
                    BeanPropertyMeta pMeta = m.getPropertyMeta(currAttr);
                    session.setCurrentProperty(pMeta);
                    if (pMeta == null) {
                        this.onUnknownProperty(session, currAttr, m, currAttrLine, currAttrCol);
                        this.parseAnything(session, this.object(), r.unread(), m.getBean(false), null);
                    } else {
                        ClassMeta<?> cm = pMeta.getClassMeta();
                        Object value = this.parseAnything(session, cm, r.unread(), m.getBean(false), pMeta);
                        this.setName(cm, value, currAttr);
                        pMeta.set(m, value);
                    }
                    session.setCurrentProperty(null);
                }
                state = S5;
                continue;
            }
            if (state != S5) continue;
            if (c == 44) {
                state = S1;
                continue;
            }
            if (session.isCommentOrWhitespace(c)) {
                JsonParser.skipCommentsAndSpace(session, r.unread());
                continue;
            }
            if (c != 125) continue;
            return m;
        }
        if (state == S0) {
            throw new ParseException(session, "Expected '{' at beginning of JSON object.", new Object[0]);
        }
        if (state == S1) {
            throw new ParseException(session, "Could not find attribute name on JSON object.", new Object[0]);
        }
        if (state == S3) {
            throw new ParseException(session, "Could not find ':' following attribute name on JSON object.", new Object[0]);
        }
        if (state == S4) {
            throw new ParseException(session, "Expected one of the following characters: {,[,',\",LITERAL.", new Object[0]);
        }
        if (state == S5) {
            throw new ParseException(session, "Could not find '}' marking end of JSON object.", new Object[0]);
        }
        return null;
    }

    private String parseString(JsonParserSession session, ParserReader r) throws Exception {
        r.mark();
        int qc = r.read();
        if (qc != 34 && session.isStrict()) {
            String msg = qc == 39 ? "Invalid quote character \"{0}\" being used." : "Did not find quote character marking beginning of string.  Character=\"{0}\"";
            throw new ParseException(session, msg, Character.valueOf((char)qc));
        }
        boolean isQuoted = qc == 39 || qc == 34;
        String s = null;
        boolean isInEscape = false;
        int c = 0;
        while (c != -1) {
            c = r.read();
            if (session.isStrict() && c <= 31) {
                throw new ParseException("Unescaped control character encountered: ''0x{0}''", String.format("%04X", c));
            }
            if (isInEscape) {
                switch (c) {
                    case 110: {
                        r.replace('\n');
                        break;
                    }
                    case 114: {
                        r.replace('\r');
                        break;
                    }
                    case 116: {
                        r.replace('\t');
                        break;
                    }
                    case 102: {
                        r.replace('\f');
                        break;
                    }
                    case 98: {
                        r.replace('\b');
                        break;
                    }
                    case 92: {
                        r.replace('\\');
                        break;
                    }
                    case 47: {
                        r.replace('/');
                        break;
                    }
                    case 39: {
                        r.replace('\'');
                        break;
                    }
                    case 34: {
                        r.replace('\"');
                        break;
                    }
                    case 117: {
                        String n = r.read(4);
                        try {
                            r.replace(Integer.parseInt(n, 16), 6);
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new ParseException(session, "Invalid Unicode escape sequence in string.", new Object[0]);
                        }
                    }
                    default: {
                        throw new ParseException(session, "Invalid escape sequence in string.", new Object[0]);
                    }
                }
                isInEscape = false;
                continue;
            }
            if (c == 92) {
                isInEscape = true;
                r.delete();
                continue;
            }
            if (isQuoted) {
                if (c != qc) continue;
                s = r.getMarked(1, -1);
                break;
            }
            if (c == 44 || c == 125 || session.isWhitespace(c)) {
                s = r.getMarked(0, -1);
                r.unread();
                break;
            }
            if (c != -1) continue;
            s = r.getMarked(0, 0);
            break;
        }
        if (s == null) {
            throw new ParseException(session, "Could not find expected end character ''{0}''.", Character.valueOf((char)qc));
        }
        JsonParser.skipCommentsAndSpace(session, r);
        if (r.peek() == 43) {
            if (session.isStrict()) {
                throw new ParseException(session, "String concatenation detected.", new Object[0]);
            }
            r.read();
            JsonParser.skipCommentsAndSpace(session, r);
            s = s + this.parseString(session, r);
        }
        return session.trim(s);
    }

    private static void parseKeyword(JsonParserSession session, String keyword, ParserReader r) throws Exception {
        try {
            String s = r.read(keyword.length());
            if (s.equals(keyword)) {
                return;
            }
            throw new ParseException(session, "Unrecognized syntax.", new Object[0]);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParseException(session, "Unrecognized syntax.", new Object[0]);
        }
    }

    private static void skipCommentsAndSpace(JsonParserSession session, ParserReader r) throws Exception {
        int c = 0;
        while ((c = r.read()) != -1) {
            if (session.isWhitespace(c)) continue;
            if (c == 47) {
                if (session.isStrict()) {
                    throw new ParseException(session, "Javascript comment detected.", new Object[0]);
                }
                JsonParser.skipComments(session, r);
                continue;
            }
            r.unread();
            return;
        }
    }

    private void skipWrapperAttrStart(JsonParserSession session, ParserReader r, String wrapperAttr) throws Exception {
        int S0 = 0;
        int S1 = 1;
        int S3 = 3;
        int S4 = 4;
        int state = S0;
        String currAttr = null;
        int c = 0;
        while (c != -1) {
            c = r.read();
            if (state == S0) {
                if (c != 123) continue;
                state = S1;
                continue;
            }
            if (state == S1) {
                if (session.isCommentOrWhitespace(c)) {
                    JsonParser.skipCommentsAndSpace(session, r.unread());
                    continue;
                }
                currAttr = this.parseFieldName(session, r.unread());
                if (!currAttr.equals(wrapperAttr)) {
                    throw new ParseException(session, "Expected to find wrapper attribute ''{0}'' but found attribute ''{1}''", wrapperAttr, currAttr);
                }
                state = S3;
                continue;
            }
            if (state == S3) {
                if (c != 58) continue;
                state = S4;
                continue;
            }
            if (state != S4) continue;
            if (session.isCommentOrWhitespace(c)) {
                JsonParser.skipCommentsAndSpace(session, r.unread());
                continue;
            }
            r.unread();
            return;
        }
        if (state == S0) {
            throw new ParseException(session, "Expected '{' at beginning of JSON object.", new Object[0]);
        }
        if (state == S1) {
            throw new ParseException(session, "Could not find attribute name on JSON object.", new Object[0]);
        }
        if (state == S3) {
            throw new ParseException(session, "Could not find ':' following attribute name on JSON object.", new Object[0]);
        }
        if (state == S4) {
            throw new ParseException(session, "Expected one of the following characters: {,[,',\",LITERAL.", new Object[0]);
        }
    }

    private static void skipWrapperAttrEnd(JsonParserSession session, ParserReader r) throws ParseException, IOException {
        int c = 0;
        while ((c = r.read()) != -1) {
            if (session.isWhitespace(c)) continue;
            if (c == 47) {
                if (session.isStrict()) {
                    throw new ParseException(session, "Javascript comment detected.", new Object[0]);
                }
                JsonParser.skipComments(session, r);
                continue;
            }
            if (c == 125) {
                return;
            }
            throw new ParseException(session, "Could not find '}' at the end of JSON wrapper object.", new Object[0]);
        }
    }

    private static void skipComments(JsonParserSession session, ParserReader r) throws ParseException, IOException {
        block3: {
            int c;
            block2: {
                c = r.read();
                if (c != 42) break block2;
                while (c != -1) {
                    c = r.read();
                    if (c != 42 || (c = r.read()) != 47) continue;
                    return;
                }
                break block3;
            }
            if (c != 47) break block3;
            while (c != -1) {
                c = r.read();
                if (c != -1 && c != 10) continue;
                return;
            }
        }
        throw new ParseException(session, "Open ended comment.", new Object[0]);
    }

    private static void validateEnd(JsonParserSession session, ParserReader r) throws Exception {
        JsonParser.skipCommentsAndSpace(session, r);
        int c = r.read();
        if (c != -1 && c != 59) {
            throw new ParseException(session, "Remainder after parse: ''{0}''.", Character.valueOf((char)c));
        }
    }

    @Override
    public JsonParserSession createSession(Object input, ObjectMap op, Method javaMethod, Object outer, Locale locale, TimeZone timeZone, MediaType mediaType) {
        return new JsonParserSession(this.ctx, op, input, javaMethod, outer, locale, timeZone, mediaType);
    }

    @Override
    protected <T> T doParse(ParserSession session, ClassMeta<T> type) throws Exception {
        JsonParserSession s = (JsonParserSession)session;
        ParserReader r = s.getReader();
        if (r == null) {
            return null;
        }
        T o = this.parseAnything(s, type, r, s.getOuter(), null);
        JsonParser.validateEnd(s, r);
        return o;
    }

    @Override
    protected <K, V> Map<K, V> doParseIntoMap(ParserSession session, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        JsonParserSession s = (JsonParserSession)session;
        ParserReader r = s.getReader();
        m = this.parseIntoMap2(s, r, m, s.getClassMeta(keyType, new Type[0]), s.getClassMeta(valueType, new Type[0]), null);
        JsonParser.validateEnd(s, r);
        return m;
    }

    @Override
    protected <E> Collection<E> doParseIntoCollection(ParserSession session, Collection<E> c, Type elementType) throws Exception {
        JsonParserSession s = (JsonParserSession)session;
        ParserReader r = s.getReader();
        c = this.parseIntoCollection2(s, r, c, s.getClassMeta(elementType, new Type[0]), null);
        JsonParser.validateEnd(s, r);
        return c;
    }

    public static class Strict
    extends JsonParser {
        public Strict(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("Parser.strict", true);
        }
    }
}

