/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.text.MessageFormat;

public class ThrowableUtils {
    public static void assertNotNull(Object o, String msg, Object ... args) throws IllegalArgumentException {
        if (o == null) {
            throw new IllegalArgumentException(MessageFormat.format(msg, args));
        }
    }

    public static void assertFieldNotNull(Object fieldValue, String fieldName) throws IllegalArgumentException {
        if (fieldValue == null) {
            throw new IllegalArgumentException("Field '" + fieldName + "' cannot be null.");
        }
    }

    public static void assertFieldPositive(int fieldValue, String fieldName) throws IllegalArgumentException {
        if (fieldValue <= 0) {
            throw new IllegalArgumentException("Field '" + fieldName + "' must be a positive integer.");
        }
    }

    public static void illegalArg(String msg, Object ... args) throws IllegalArgumentException {
        throw new IllegalArgumentException(MessageFormat.format(msg, args));
    }

    public static void assertSameThread(long threadId, String msg, Object ... args) throws IllegalStateException {
        if (Thread.currentThread().getId() != threadId) {
            throw new IllegalArgumentException(MessageFormat.format(msg, args));
        }
    }
}

