/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ThrowableUtils;

public final class SimpleMap
extends AbstractMap<String, Object> {
    private final String[] keys;
    private final Object[] values;
    private final Map.Entry<String, Object>[] entries;

    public SimpleMap(String[] keys, Object[] values) {
        ThrowableUtils.assertFieldNotNull(keys, "keys");
        ThrowableUtils.assertFieldNotNull(values, "values");
        if (keys.length != values.length) {
            ThrowableUtils.illegalArg("keys ''{0}'' and values ''{1}'' array lengths differ", keys.length, values.length);
        }
        this.keys = keys;
        this.values = values;
        this.entries = new SimpleMapEntry[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) {
                ThrowableUtils.illegalArg("Keys array cannot contain a null value.", new Object[0]);
            }
            this.entries[i] = new SimpleMapEntry(i);
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return ArrayUtils.asSet(this.entries);
    }

    @Override
    public Object get(Object key) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(key)) continue;
            return this.values[i];
        }
        return null;
    }

    @Override
    public Set<String> keySet() {
        return ArrayUtils.asSet(this.keys);
    }

    @Override
    public Object put(String key, Object value) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(key)) continue;
            Object v = this.values[i];
            this.values[i] = value;
            return v;
        }
        throw new IllegalArgumentException(MessageFormat.format("No key ''{0}'' defined in map", key));
    }

    private class SimpleMapEntry
    implements Map.Entry<String, Object> {
        private int index;

        private SimpleMapEntry(int index) {
            this.index = index;
        }

        @Override
        public String getKey() {
            return SimpleMap.this.keys[this.index];
        }

        @Override
        public Object getValue() {
            return SimpleMap.this.values[this.index];
        }

        @Override
        public Object setValue(Object val) {
            Object v = SimpleMap.this.values[this.index];
            ((SimpleMap)SimpleMap.this).values[this.index] = val;
            return v;
        }
    }
}

