/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMapEntry;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanMetaFiltered;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ObjectMap;

public class DelegateBeanMap<T>
extends BeanMap<T> {
    private Set<String> keys = Collections.newSetFromMap(new LinkedHashMap());
    private ObjectMap overrideValues = new ObjectMap();

    public DelegateBeanMap(T bean, BeanSession session) {
        super(session, bean, session.getBeanMeta(bean.getClass()));
    }

    public void addKey(String key) {
        this.keys.add(key);
    }

    @Override
    public Object put(String key, Object val) {
        this.overrideValues.put(key, val);
        this.keys.add(key);
        return null;
    }

    @Override
    public Object get(Object key) {
        if (this.overrideValues.containsKey(key)) {
            return this.overrideValues.get(key);
        }
        return super.get(key);
    }

    @Override
    public Set<String> keySet() {
        return this.keys;
    }

    public void filterKeys(List<String> keys) {
        this.keys.clear();
        this.keys.addAll(keys);
    }

    @Override
    public Object remove(Object key) {
        this.keys.remove(key);
        return null;
    }

    @Override
    public BeanMeta<T> getMeta() {
        return new BeanMetaFiltered(super.getMeta(), this.keys);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        Set<Map.Entry<String, Object>> s = Collections.newSetFromMap(new LinkedHashMap());
        for (String key : this.keys) {
            BeanMapEntry bme = this.overrideValues.containsKey(key) ? new BeanMapEntryOverride(this, this.getPropertyMeta(key), this.overrideValues.get(key)) : this.getProperty(key);
            if (bme == null) {
                throw new BeanRuntimeException(super.getClassMeta().getInnerClass(), "Property ''{0}'' not found on class.", key);
            }
            s.add(bme);
        }
        return s;
    }

    @Override
    public Collection<BeanPropertyMeta> getProperties() {
        ArrayList<BeanPropertyMeta> l = new ArrayList<BeanPropertyMeta>(this.keys.size());
        for (String key : this.keys) {
            BeanPropertyMeta p = this.getPropertyMeta(key);
            if (this.overrideValues.containsKey(key)) {
                p = new BeanPropertyMeta.Builder(this.meta, key, this.overrideValues.get(key), p).build();
            }
            if (p == null) {
                throw new BeanRuntimeException(super.getClassMeta().getInnerClass(), "Property ''{0}'' not found on class.", key);
            }
            l.add(p);
        }
        return l;
    }

    private class BeanMapEntryOverride
    extends BeanMapEntry {
        Object value;

        private BeanMapEntryOverride(BeanMap<?> bm, BeanPropertyMeta bpm, Object value) {
            super(bm, bpm);
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }
}

