/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.html.HtmlParserContext;
import org.apache.juneau.html.HtmlTag;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.xml.XmlParserSession;

public final class HtmlParserSession
extends XmlParserSession {
    private static final Set<String> whitespaceElements = new HashSet<String>(Arrays.asList("br", "bs", "sp", "ff"));

    public HtmlParserSession(HtmlParserContext ctx, ObjectMap op, Object input, Method javaMethod, Object outer, Locale locale, TimeZone timeZone, MediaType mediaType) {
        super(ctx, op, input, javaMethod, outer, locale, timeZone, mediaType);
    }

    @Override
    public String parseText(XMLStreamReader r) throws XMLStreamException {
        StringBuilder sb = this.getStringBuilder();
        int et = r.getEventType();
        if (et == 2) {
            return "";
        }
        int depth = 0;
        String characters = null;
        while (true) {
            if (et == 1) {
                HtmlTag tag;
                if (characters != null) {
                    if (sb.length() == 0) {
                        characters = StringUtils.trimStart(characters);
                    }
                    sb.append(characters);
                    characters = null;
                }
                if ((tag = HtmlTag.forEvent(r)) == HtmlTag.BR) {
                    sb.append('\n');
                    r.nextTag();
                } else if (tag == HtmlTag.BS) {
                    sb.append('\b');
                    r.nextTag();
                } else if (tag == HtmlTag.SP) {
                    et = r.next();
                    if (et == 4) {
                        String s = r.getText();
                        if (s.length() > 0) {
                            char c = r.getText().charAt(0);
                            if (c == '\u2003') {
                                c = '\t';
                            }
                            sb.append(c);
                        }
                        r.nextTag();
                    }
                } else if (tag == HtmlTag.FF) {
                    sb.append('\f');
                    r.nextTag();
                } else if (tag.isOneOf(HtmlTag.STRING, HtmlTag.NUMBER, HtmlTag.BOOLEAN)) {
                    et = r.next();
                    if (et == 4) {
                        sb.append(r.getText());
                        r.nextTag();
                    }
                } else {
                    sb.append('<').append(r.getLocalName());
                    for (int i = 0; i < r.getAttributeCount(); ++i) {
                        sb.append(' ').append(r.getAttributeName(i)).append('=').append('\'').append(r.getAttributeValue(i)).append('\'');
                    }
                    sb.append('>');
                    ++depth;
                }
            } else if (et == 2) {
                if (characters != null) {
                    if (sb.length() == 0) {
                        characters = StringUtils.trimStart(characters);
                    }
                    if (depth == 0) {
                        characters = StringUtils.trimEnd(characters);
                    }
                    sb.append(characters);
                    characters = null;
                }
                if (depth == 0) break;
                sb.append('<').append(r.getLocalName()).append('>');
                --depth;
            } else if (et == 4) {
                characters = r.getText();
            }
            et = r.next();
        }
        String s = this.trim(sb.toString());
        this.returnStringBuilder(sb);
        return s;
    }

    @Override
    public String getElementText(XMLStreamReader r) throws XMLStreamException {
        r.next();
        return this.parseText(r);
    }

    @Override
    public boolean isWhitespaceElement(XMLStreamReader r) {
        String s = r.getLocalName();
        return whitespaceElements.contains(s);
    }

    @Override
    public String parseWhitespaceElement(XMLStreamReader r) throws XMLStreamException {
        HtmlTag tag = HtmlTag.forEvent(r);
        int et = r.next();
        if (tag == HtmlTag.BR) {
            return "\n";
        }
        if (tag == HtmlTag.BS) {
            return "\b";
        }
        if (tag == HtmlTag.FF) {
            return "\f";
        }
        if (tag == HtmlTag.SP) {
            if (et == 4) {
                String s = r.getText();
                if (s.charAt(0) == '\u2003') {
                    s = "\t";
                }
                r.next();
                return this.decodeString(s);
            }
            return "";
        }
        throw new XMLStreamException("Invalid tag found in parseWhitespaceElement(): " + (Object)((Object)tag));
    }
}

