/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.encoders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderGroup;

public class EncoderGroupBuilder {
    private final List<Encoder> encoders;

    public EncoderGroupBuilder() {
        this.encoders = new ArrayList<Encoder>();
    }

    public EncoderGroupBuilder(EncoderGroup copyFrom) {
        this.encoders = new ArrayList<Encoder>(Arrays.asList(copyFrom.encoders));
    }

    public EncoderGroupBuilder append(Class<?> ... e) {
        for (Class<?> ee : e) {
            try {
                this.encoders.add((Encoder)ee.newInstance());
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
        return this;
    }

    public EncoderGroupBuilder append(Encoder ... e) {
        this.encoders.addAll(Arrays.asList(e));
        return this;
    }

    public EncoderGroupBuilder append(Collection<Encoder> e) {
        this.encoders.addAll(e);
        return this;
    }

    public EncoderGroupBuilder append(EncoderGroup eg) {
        this.append(eg.encoders);
        return this;
    }

    public EncoderGroup build() {
        try {
            ArrayList<Encoder> l = new ArrayList<Encoder>();
            for (Encoder e : this.encoders) {
                l.add(e instanceof Class ? (Encoder)((Class)((Object)e)).getConstructor(new Class[0]).newInstance(new Object[0]) : e);
            }
            Collections.reverse(l);
            return new EncoderGroup(l.toArray(new Encoder[l.size()]));
        }
        catch (Exception x) {
            throw new RuntimeException("Could not instantiate encoder.", x);
        }
    }
}

