/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.swagger.HeaderInfo;
import org.apache.juneau.dto.swagger.SchemaInfo;
import org.apache.juneau.dto.swagger.SwaggerElement;

@Bean(properties="description,schema,headers,examples")
public class ResponseInfo
extends SwaggerElement {
    private String description;
    private SchemaInfo schema;
    private Map<String, HeaderInfo> headers;
    private Map<String, Object> examples;

    public String getDescription() {
        return this.description;
    }

    public ResponseInfo setDescription(String description) {
        this.description = description;
        return this;
    }

    public ResponseInfo description(String description) {
        return this.setDescription(description);
    }

    public SchemaInfo getSchema() {
        return this.schema;
    }

    public ResponseInfo setSchema(SchemaInfo schema) {
        this.schema = schema;
        return this;
    }

    public ResponseInfo schema(SchemaInfo schema) {
        return this.setSchema(schema);
    }

    public Map<String, HeaderInfo> getHeaders() {
        return this.headers;
    }

    public ResponseInfo setHeaders(Map<String, HeaderInfo> headers) {
        this.headers = headers;
        return this;
    }

    public ResponseInfo addHeader(String name, HeaderInfo header) {
        if (this.headers == null) {
            this.headers = new TreeMap<String, HeaderInfo>();
        }
        this.headers.put(name, header);
        return this;
    }

    public ResponseInfo header(String name, HeaderInfo header) {
        return this.addHeader(name, header);
    }

    public Map<String, Object> getExamples() {
        return this.examples;
    }

    public ResponseInfo setExamples(Map<String, Object> examples) {
        this.examples = examples;
        return this;
    }

    public ResponseInfo addExample(String mimeType, Object example) {
        if (this.examples == null) {
            this.examples = new TreeMap<String, Object>();
        }
        this.examples.put(mimeType, example);
        return this;
    }

    public ResponseInfo example(String mimeType, Object example) {
        return this.addExample(mimeType, example);
    }

    public ResponseInfo examples(Map<String, Object> examples) {
        return this.setExamples(examples);
    }
}

