/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.MediaType;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.ParameterInfo;
import org.apache.juneau.dto.swagger.ResponseInfo;
import org.apache.juneau.dto.swagger.SwaggerElement;

@Bean(properties="operationId,summary,description,tags,externalDocs,consumes,produces,parameters,responses,schemes,deprecated,security")
public class Operation
extends SwaggerElement {
    private List<String> tags;
    private String summary;
    private String description;
    private ExternalDocumentation externalDocs;
    private String operationId;
    private List<MediaType> consumes;
    private List<MediaType> produces;
    private List<ParameterInfo> parameters;
    private Map<Integer, ResponseInfo> responses;
    private List<String> schemes;
    private Boolean deprecated;
    private List<Map<String, List<String>>> security;

    public List<String> getTags() {
        return this.tags;
    }

    public Operation setTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Operation addTags(String ... tags) {
        return this.addTags(Arrays.asList(tags));
    }

    public Operation addTags(Collection<String> tags) {
        if (tags != null) {
            if (this.tags == null) {
                this.tags = new LinkedList<String>();
            }
            this.tags.addAll(tags);
        }
        return this;
    }

    public Operation tags(String ... tags) {
        return this.addTags(tags);
    }

    public Operation tags(Collection<String> tags) {
        return this.addTags(tags);
    }

    public String getSummary() {
        return this.summary;
    }

    public Operation setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public Operation summary(String summary) {
        return this.setSummary(summary);
    }

    public String getDescription() {
        return this.description;
    }

    public Operation setDescription(String description) {
        this.description = description;
        return this;
    }

    public Operation description(String description) {
        return this.setDescription(description);
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public Operation setExternalDocs(ExternalDocumentation externalDocs) {
        this.externalDocs = externalDocs;
        return this;
    }

    public Operation externalDocs(ExternalDocumentation externalDocs) {
        return this.setExternalDocs(externalDocs);
    }

    public String getOperationId() {
        return this.operationId;
    }

    public Operation setOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public Operation operationId(String operationId) {
        return this.setOperationId(operationId);
    }

    public List<MediaType> getConsumes() {
        return this.consumes;
    }

    public Operation setConsumes(List<MediaType> consumes) {
        this.consumes = consumes;
        return this;
    }

    public Operation addConsumes(MediaType ... consumes) {
        return this.addConsumes(Arrays.asList(consumes));
    }

    public Operation addConsumes(Collection<MediaType> consumes) {
        if (consumes != null) {
            if (this.consumes == null) {
                this.consumes = new LinkedList<MediaType>();
            }
            this.consumes.addAll(consumes);
        }
        return this;
    }

    public Operation consumes(MediaType ... consumes) {
        return this.addConsumes(consumes);
    }

    public Operation consumes(Collection<MediaType> consumes) {
        return this.addConsumes(consumes);
    }

    public List<MediaType> getProduces() {
        return this.produces;
    }

    public Operation setProduces(List<MediaType> produces) {
        this.produces = produces;
        return this;
    }

    public Operation addProduces(MediaType ... produces) {
        if (produces != null) {
            if (this.produces == null) {
                this.produces = new LinkedList<MediaType>();
            }
            this.produces.addAll(Arrays.asList(produces));
        }
        return this;
    }

    public Operation addProduces(Collection<MediaType> produces) {
        if (produces != null) {
            if (this.produces == null) {
                this.produces = new LinkedList<MediaType>();
            }
            this.produces.addAll(produces);
        }
        return this;
    }

    public Operation produces(MediaType ... produces) {
        return this.addProduces(produces);
    }

    public Operation produces(Collection<MediaType> produces) {
        return this.addProduces(produces);
    }

    public List<ParameterInfo> getParameters() {
        return this.parameters;
    }

    public Operation setParameters(List<ParameterInfo> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Operation addParameters(ParameterInfo ... parameters) {
        if (this.parameters == null) {
            this.parameters = new LinkedList<ParameterInfo>();
        }
        this.parameters.addAll(Arrays.asList(parameters));
        return this;
    }

    public Operation parameters(ParameterInfo ... parameters) {
        return this.addParameters(parameters);
    }

    public Operation parameters(List<ParameterInfo> parameters) {
        return this.setParameters(parameters);
    }

    public Map<Integer, ResponseInfo> getResponses() {
        return this.responses;
    }

    public Operation setResponses(Map<Integer, ResponseInfo> responses) {
        this.responses = responses;
        return this;
    }

    public Operation addResponse(Integer statusCode, ResponseInfo response) {
        if (this.responses == null) {
            this.responses = new TreeMap<Integer, ResponseInfo>();
        }
        this.responses.put(statusCode, response);
        return this;
    }

    public Operation response(Integer statusCode, ResponseInfo response) {
        return this.addResponse(statusCode, response);
    }

    public Operation responses(Map<Integer, ResponseInfo> responses) {
        return this.setResponses(responses);
    }

    public List<String> getSchemes() {
        return this.schemes;
    }

    public Operation setSchemes(List<String> schemes) {
        this.schemes = schemes;
        return this;
    }

    public Operation addSchemes(String ... schemes) {
        return this.addSchemes(Arrays.asList(schemes));
    }

    public Operation addSchemes(Collection<String> schemes) {
        if (this.schemes == null) {
            this.schemes = new LinkedList<String>();
        }
        this.schemes.addAll(schemes);
        return this;
    }

    public Operation schemes(String ... schemes) {
        return this.addSchemes(schemes);
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public Operation setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public Operation deprecated(Boolean deprecated) {
        return this.setDeprecated(deprecated);
    }

    public List<Map<String, List<String>>> getSecurity() {
        return this.security;
    }

    public Operation setSecurity(List<Map<String, List<String>>> security) {
        this.security = security;
        return this;
    }

    public Operation addSecurity(Map<String, List<String>> security) {
        if (this.security == null) {
            this.security = new LinkedList<Map<String, List<String>>>();
        }
        this.security.add(security);
        return this;
    }

    public Operation security(String scheme, String ... alternatives) {
        LinkedHashMap<String, List<String>> m = new LinkedHashMap<String, List<String>>();
        m.put(scheme, Arrays.asList(alternatives));
        return this.addSecurity(m);
    }
}

