/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.csv;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.csv.CsvSerializerBuilder;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.WriterSerializer;

@Produces(value="text/csv")
public final class CsvSerializer
extends WriterSerializer {
    public static final CsvSerializer DEFAULT = new CsvSerializer(PropertyStore.create());

    public CsvSerializer(PropertyStore propertyStore) {
        super(propertyStore);
    }

    @Override
    public CsvSerializerBuilder builder() {
        return new CsvSerializerBuilder(this.propertyStore);
    }

    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        ClassMeta entryType;
        Writer out = session.getWriter();
        ClassMeta<Object> cm = session.getClassMetaForObject(o);
        List<Object> l = null;
        l = cm.isArray() ? Arrays.asList((Object[])o) : (List<Object>)o;
        if (l.size() > 0 && (entryType = session.getClassMetaForObject(l.iterator().next())).isBean()) {
            BeanMeta bm = entryType.getBeanMeta();
            int i = 0;
            for (BeanPropertyMeta beanPropertyMeta : bm.getPropertyMetas()) {
                if (i++ > 0) {
                    out.append(',');
                }
                CsvSerializer.append(out, beanPropertyMeta.getName());
            }
            out.append('\n');
            for (BeanPropertyMeta beanPropertyMeta : l) {
                i = 0;
                BeanMap<BeanPropertyMeta> bean = session.toBeanMap(beanPropertyMeta);
                for (BeanPropertyMeta pm : bm.getPropertyMetas()) {
                    if (i++ > 0) {
                        out.append(',');
                    }
                    CsvSerializer.append(out, pm.get(bean));
                }
                out.append('\n');
            }
        }
    }

    private static void append(Writer w, Object o) throws IOException {
        if (o == null) {
            w.append("null");
        } else {
            String s = o.toString();
            boolean mustQuote = false;
            for (int i = 0; i < s.length() && !mustQuote; ++i) {
                char c = s.charAt(i);
                if (!Character.isWhitespace(c) && c != ',') continue;
                mustQuote = true;
            }
            if (mustQuote) {
                w.append('\"').append(s).append('\"');
            } else {
                w.append(s);
            }
        }
    }
}

