/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.juneau.MediaType;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.internal.StringUtils;

@BeanIgnore
public final class MediaRange
implements Comparable<MediaRange> {
    private static final MediaRange[] DEFAULT = new MediaRange[]{new MediaRange("*/*")};
    private final MediaType mediaType;
    private final Float qValue;
    private final Map<String, Set<String>> parameters;
    private final Map<String, Set<String>> extensions;

    private MediaRange(String mediaRangeFragment) {
        String r = mediaRangeFragment;
        Float _qValue = Float.valueOf(1.0f);
        MediaType _mediaType = null;
        Map _parameters = null;
        Map _extensions = null;
        r = r.trim();
        int i = r.indexOf(59);
        if (i == -1) {
            _mediaType = MediaType.forString(r);
        } else {
            _mediaType = MediaType.forString(r.substring(0, i));
            String[] tokens = r.substring(i + 1).split(";");
            if (tokens.length > 0) {
                boolean isInExtensions = false;
                for (int j = 0; j < tokens.length; ++j) {
                    String[] parm = tokens[j].split("=");
                    if (parm.length != 2) continue;
                    String k = parm[0];
                    String v = parm[1];
                    if (isInExtensions) {
                        if (_extensions == null) {
                            _extensions = new TreeMap();
                        }
                        if (!_extensions.containsKey(parm[0])) {
                            _extensions.put(parm[0], new TreeSet());
                        }
                        ((Set)_extensions.get(parm[0])).add(parm[1]);
                        continue;
                    }
                    if (k.equals("q")) {
                        _qValue = new Float(v);
                        isInExtensions = true;
                        continue;
                    }
                    if (_parameters == null) {
                        _parameters = new TreeMap();
                    }
                    if (!_parameters.containsKey(parm[0])) {
                        _parameters.put(parm[0], new TreeSet());
                    }
                    ((Set)_parameters.get(parm[0])).add(parm[1]);
                }
            }
        }
        if (_parameters == null) {
            _parameters = Collections.emptyMap();
        }
        if (_extensions == null) {
            _extensions = Collections.emptyMap();
        }
        this.mediaType = _mediaType;
        this.parameters = _parameters;
        this.qValue = _qValue;
        this.extensions = _extensions;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public Float getQValue() {
        return this.qValue;
    }

    public Map<String, Set<String>> getParameters() {
        return this.parameters;
    }

    public Map<String, Set<String>> getExtensions() {
        return this.extensions;
    }

    public String toString() {
        StringBuffer sb;
        block7: {
            String k;
            block6: {
                sb = new StringBuffer().append(this.mediaType);
                for (Map.Entry<String, Set<String>> e : this.parameters.entrySet()) {
                    k = e.getKey();
                    for (String v : e.getValue()) {
                        sb.append(';').append(k).append('=').append(v);
                    }
                }
                if ((double)this.qValue.floatValue() != 1.0) break block6;
                if (this.extensions.isEmpty()) break block7;
                sb.append(";q=").append(this.qValue);
                for (Map.Entry<String, Set<String>> e : this.extensions.entrySet()) {
                    k = e.getKey();
                    for (String v : e.getValue()) {
                        sb.append(';').append(k).append('=').append(v);
                    }
                }
                break block7;
            }
            sb.append(";q=").append(this.qValue);
            for (Map.Entry<String, Set<String>> e : this.extensions.entrySet()) {
                k = e.getKey();
                for (String v : e.getValue()) {
                    sb.append(';').append(k).append('=').append(v);
                }
            }
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof MediaRange)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        MediaRange o2 = (MediaRange)o;
        return this.qValue.equals(o2.qValue) && this.mediaType.equals(o2.mediaType) && this.parameters.equals(o2.parameters) && this.extensions.equals(o2.extensions);
    }

    public int hashCode() {
        return this.mediaType.hashCode();
    }

    public static MediaRange[] parse(String value) {
        if (value == null || value.length() == 0) {
            return DEFAULT;
        }
        if ((value = value.toLowerCase(Locale.ENGLISH)).indexOf(44) == -1) {
            return new MediaRange[]{new MediaRange(value)};
        }
        TreeSet<MediaRange> ranges = new TreeSet<MediaRange>();
        for (String r : StringUtils.split(value, ',')) {
            if ((r = r.trim()).isEmpty()) continue;
            ranges.add(new MediaRange(r));
        }
        return ranges.toArray(new MediaRange[ranges.size()]);
    }

    @Override
    public int compareTo(MediaRange o) {
        int qCompare = Float.compare(o.qValue.floatValue(), this.qValue.floatValue());
        if (qCompare != 0) {
            return qCompare;
        }
        int i = o.mediaType.toString().compareTo(this.mediaType.toString());
        return i;
    }

    public float matches(MediaType o) {
        if (this.mediaType == o || this.mediaType.matches(o)) {
            return this.qValue.floatValue();
        }
        return 0.0f;
    }
}

