/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.BackoffManager;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.InputStreamFactory;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.juneau.CoreObjectBuilder;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.Visibility;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.rest.client.AllowAllRedirects;
import org.apache.juneau.rest.client.RestCallInterceptor;
import org.apache.juneau.rest.client.RestCallLogger;
import org.apache.juneau.rest.client.RestClient;
import org.apache.juneau.rest.client.RetryOn;
import org.apache.juneau.rest.client.SSLOpts;
import org.apache.juneau.rest.client.SimpleX509TrustManager;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;

public class RestClientBuilder
extends CoreObjectBuilder {
    private HttpClientConnectionManager httpClientConnectionManager;
    private HttpClientBuilder httpClientBuilder = this.createHttpClientBuilder();
    private CloseableHttpClient httpClient;
    private boolean keepHttpClientOpen;
    private Class<? extends Serializer> serializerClass = JsonSerializer.class;
    private Class<? extends Parser> parserClass = JsonParser.class;
    private Serializer serializer;
    private Parser parser;
    private Map<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private List<RestCallInterceptor> interceptors = new ArrayList<RestCallInterceptor>();
    private String rootUrl;
    private SSLOpts sslOpts;
    private boolean pooled;
    private int retries = 1;
    private long retryInterval = -1L;
    private RetryOn retryOn = RetryOn.DEFAULT;
    private boolean debug;
    private boolean executorServiceShutdownOnClose;
    private ExecutorService executorService;

    public RestClientBuilder() {
    }

    public RestClientBuilder(Serializer s, Parser p) {
        this.serializer(s);
        this.parser(p);
    }

    public RestClientBuilder(Class<? extends Serializer> s, Class<? extends Parser> p) {
        this.serializer(s);
        this.parser(p);
    }

    public RestClientBuilder(PropertyStore propertyStore) {
        super(propertyStore);
    }

    public RestClient build() {
        try {
            CloseableHttpClient httpClient = this.httpClient;
            if (httpClient == null) {
                httpClient = this.createHttpClient();
            }
            Serializer s = this.serializer != null ? this.serializer.builder().apply(this.propertyStore).build() : (Serializer)new SerializerBuilder(this.propertyStore).build(this.serializerClass);
            Parser p = this.parser != null ? this.parser.builder().apply(this.propertyStore).build() : (Parser)new ParserBuilder(this.propertyStore).build(this.parserClass);
            UrlEncodingSerializer us = (UrlEncodingSerializer)new SerializerBuilder(this.propertyStore).build(UrlEncodingSerializer.class);
            return new RestClient(this.propertyStore, httpClient, this.keepHttpClientOpen, s, p, us, this.headers, this.interceptors, this.rootUrl, this.retryOn, this.retries, this.retryInterval, this.debug, this.executorService, this.executorServiceShutdownOnClose);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected CloseableHttpClient createHttpClient() throws Exception {
        if (this.httpClientConnectionManager == null) {
            this.httpClientBuilder.setConnectionManager(this.createConnectionManager());
        }
        return this.httpClientBuilder.build();
    }

    protected HttpClientBuilder createHttpClientBuilder() {
        HttpClientBuilder b = HttpClientBuilder.create();
        b.setRedirectStrategy((RedirectStrategy)new AllowAllRedirects());
        return b;
    }

    protected HttpClientConnectionManager createConnectionManager() {
        if (this.sslOpts != null) {
            NoopHostnameVerifier hv = null;
            switch (this.sslOpts.getHostVerify()) {
                case LAX: {
                    hv = new NoopHostnameVerifier();
                    break;
                }
                case DEFAULT: {
                    hv = new DefaultHostnameVerifier();
                    break;
                }
                default: {
                    throw new RuntimeException("Programmer error");
                }
            }
            for (String p : StringUtils.split((String)this.sslOpts.getProtocols(), (char)',')) {
                try {
                    SimpleX509TrustManager tm = new SimpleX509TrustManager(this.sslOpts.getCertValidate() == SSLOpts.CertValidate.LAX);
                    SSLContext ctx = SSLContext.getInstance(p);
                    ctx.init(null, new TrustManager[]{tm}, null);
                    ctx.getSocketFactory().createSocket().close();
                    SSLConnectionSocketFactory sf = new SSLConnectionSocketFactory(ctx, (HostnameVerifier)hv);
                    this.setSSLSocketFactory((LayeredConnectionSocketFactory)sf);
                    Registry r = RegistryBuilder.create().register("https", (Object)sf).build();
                    return (HttpClientConnectionManager)(this.pooled ? new PoolingHttpClientConnectionManager(r) : new BasicHttpClientConnectionManager((Lookup)r));
                }
                catch (Throwable throwable) {
                }
            }
        }
        return (HttpClientConnectionManager)(this.pooled ? new PoolingHttpClientConnectionManager() : new BasicHttpClientConnectionManager());
    }

    public RestClientBuilder rootUrl(Object rootUrl) {
        String s = rootUrl.toString();
        if (s.endsWith("/")) {
            s = s.replaceAll("\\/$", "");
        }
        this.rootUrl = s;
        return this;
    }

    public RestClientBuilder enableSSL(SSLOpts opts) throws KeyStoreException, NoSuchAlgorithmException {
        this.sslOpts = opts;
        return this;
    }

    public RestClientBuilder enableLaxSSL() throws KeyStoreException, NoSuchAlgorithmException {
        return this.enableSSL(SSLOpts.LAX);
    }

    public RestClientBuilder clientVersion(String version) {
        return this.header("X-Client-Version", version);
    }

    public RestClientBuilder interceptor(RestCallInterceptor interceptor) {
        this.interceptors.add(interceptor);
        return this;
    }

    public RestClientBuilder logTo(Level level, Logger log) {
        this.interceptor(new RestCallLogger(level, log));
        return this;
    }

    public RestClientBuilder retryable(int retries, long interval, RetryOn retryOn) {
        this.retries = retries;
        this.retryInterval = interval;
        this.retryOn = retryOn;
        return this;
    }

    public RestClientBuilder pooled() {
        this.pooled = true;
        return this;
    }

    public RestClientBuilder serializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public RestClientBuilder serializer(Class<? extends Serializer> serializerClass) {
        this.serializerClass = serializerClass;
        return this;
    }

    public RestClientBuilder parser(Parser parser) {
        this.parser = parser;
        return this;
    }

    public RestClientBuilder parser(Class<? extends Parser> parserClass) {
        this.parserClass = parserClass;
        return this;
    }

    public RestClientBuilder basicAuth(String host, int port, String user, String pw) {
        AuthScope scope = new AuthScope(host, port);
        UsernamePasswordCredentials up = new UsernamePasswordCredentials(user, pw);
        BasicCredentialsProvider p = new BasicCredentialsProvider();
        p.setCredentials(scope, (Credentials)up);
        this.setDefaultCredentialsProvider((CredentialsProvider)p);
        return this;
    }

    public RestClientBuilder httpClient(CloseableHttpClient httpClient, boolean keepHttpClientOpen) {
        this.httpClient = httpClient;
        this.keepHttpClientOpen = keepHttpClientOpen;
        return this;
    }

    public RestClientBuilder executorService(ExecutorService executorService, boolean shutdownOnClose) {
        this.executorService = executorService;
        this.executorServiceShutdownOnClose = shutdownOnClose;
        return this;
    }

    public RestClientBuilder header(String name, Object value) {
        this.headers.put(name, value == null ? null : value.toString());
        return this;
    }

    public RestClientBuilder accept(Object value) {
        return this.header("Accept", value);
    }

    public RestClientBuilder acceptCharset(Object value) {
        return this.header("Accept-Charset", value);
    }

    public RestClientBuilder acceptEncoding(Object value) {
        return this.header("Accept-Encoding", value);
    }

    public RestClientBuilder acceptLanguage(Object value) {
        return this.header("Accept-Language", value);
    }

    public RestClientBuilder authorization(Object value) {
        return this.header("Authorization", value);
    }

    public RestClientBuilder cacheControl(Object value) {
        return this.header("Cache-Control", value);
    }

    public RestClientBuilder connection(Object value) {
        return this.header("Connection", value);
    }

    public RestClientBuilder contentLength(Object value) {
        return this.header("Content-Length", value);
    }

    public RestClientBuilder contentType(Object value) {
        return this.header("Content-Type", value);
    }

    public RestClientBuilder date(Object value) {
        return this.header("Date", value);
    }

    public RestClientBuilder expect(Object value) {
        return this.header("Expect", value);
    }

    public RestClientBuilder forwarded(Object value) {
        return this.header("Forwarded", value);
    }

    public RestClientBuilder from(Object value) {
        return this.header("From", value);
    }

    public RestClientBuilder host(Object value) {
        return this.header("Host", value);
    }

    public RestClientBuilder ifMatch(Object value) {
        return this.header("If-Match", value);
    }

    public RestClientBuilder ifModifiedSince(Object value) {
        return this.header("If-Modified-Since", value);
    }

    public RestClientBuilder ifNoneMatch(Object value) {
        return this.header("If-None-Match", value);
    }

    public RestClientBuilder ifRange(Object value) {
        return this.header("If-Range", value);
    }

    public RestClientBuilder ifUnmodifiedSince(Object value) {
        return this.header("If-Unmodified-Since", value);
    }

    public RestClientBuilder maxForwards(Object value) {
        return this.header("If-Unmodified-Since", value);
    }

    public RestClientBuilder origin(Object value) {
        return this.header("If-Unmodified-Since", value);
    }

    public RestClientBuilder pragma(Object value) {
        return this.header("Pragma", value);
    }

    public RestClientBuilder proxyAuthorization(Object value) {
        return this.header("Proxy-Authorization", value);
    }

    public RestClientBuilder range(Object value) {
        return this.header("Range", value);
    }

    public RestClientBuilder referer(Object value) {
        return this.header("Referer", value);
    }

    public RestClientBuilder te(Object value) {
        return this.header("TE", value);
    }

    public RestClientBuilder userAgent(Object value) {
        return this.header("User-Agent", value);
    }

    public RestClientBuilder upgrade(Object value) {
        return this.header("Upgrade", value);
    }

    public RestClientBuilder via(Object value) {
        return this.header("Via", value);
    }

    public RestClientBuilder warning(Object value) {
        return this.header("Warning", value);
    }

    public RestClientBuilder maxDepth(int value) {
        return this.property("Serializer.maxDepth", value);
    }

    public RestClientBuilder initialDepth(int value) {
        return this.property("Serializer.initialDepth", value);
    }

    public RestClientBuilder detectRecursions(boolean value) {
        return this.property("Serializer.detectRecursions", value);
    }

    public RestClientBuilder ignoreRecursions(boolean value) {
        return this.property("Serializer.ignoreRecursions", value);
    }

    public RestClientBuilder useWhitespace(boolean value) {
        return this.property("Serializer.useWhitespace", value);
    }

    public RestClientBuilder addBeanTypeProperties(boolean value) {
        return this.property("Serializer.addBeanTypeProperties", value);
    }

    public RestClientBuilder quoteChar(char value) {
        return this.property("Serializer.quoteChar", Character.valueOf(value));
    }

    public RestClientBuilder trimNullProperties(boolean value) {
        return this.property("Serializer.trimNullProperties", value);
    }

    public RestClientBuilder trimEmptyCollections(boolean value) {
        return this.property("Serializer.trimEmptyLists", value);
    }

    public RestClientBuilder trimEmptyMaps(boolean value) {
        return this.property("Serializer.trimEmptyMaps", value);
    }

    public RestClientBuilder trimStringsS(boolean value) {
        return this.property("Serializer.trimStrings", value);
    }

    public RestClientBuilder relativeUriBase(String value) {
        return this.property("Serializer.relativeUriBase", value);
    }

    public RestClientBuilder absolutePathUriBase(String value) {
        return this.property("Serializer.absolutePathUriBase", value);
    }

    public RestClientBuilder sortCollections(boolean value) {
        return this.property("Serializer.sortCollections", value);
    }

    public RestClientBuilder sortMaps(boolean value) {
        return this.property("Serializer.sortMaps", value);
    }

    public RestClientBuilder abridged(boolean value) {
        return this.property("Serializer.abridged", value);
    }

    public RestClientBuilder trimStringsP(boolean value) {
        return this.property("Parser.trimStrings", value);
    }

    public RestClientBuilder strict(boolean value) {
        return this.property("Parser.strict", value);
    }

    public RestClientBuilder inputStreamCharset(String value) {
        return this.property("Parser.inputStreamCharset", value);
    }

    public RestClientBuilder fileCharset(String value) {
        return this.property("Parser.fileCharset", value);
    }

    public RestClientBuilder noTrace() {
        return this.header("No-Trace", true);
    }

    public RestClientBuilder paramFormat(String value) {
        super.property("UrlEncodingSerializer.paramFormat", (Object)value);
        return this;
    }

    public RestClientBuilder plainTextParams() {
        super.property("UrlEncodingSerializer.paramFormat", (Object)"PLAINTEXT");
        return this;
    }

    public RestClientBuilder beansRequireDefaultConstructor(boolean value) {
        super.beansRequireDefaultConstructor(value);
        return this;
    }

    public RestClientBuilder beansRequireSerializable(boolean value) {
        super.beansRequireSerializable(value);
        return this;
    }

    public RestClientBuilder beansRequireSettersForGetters(boolean value) {
        super.beansRequireSettersForGetters(value);
        return this;
    }

    public RestClientBuilder beansRequireSomeProperties(boolean value) {
        super.beansRequireSomeProperties(value);
        return this;
    }

    public RestClientBuilder beanMapPutReturnsOldValue(boolean value) {
        super.beanMapPutReturnsOldValue(value);
        return this;
    }

    public RestClientBuilder beanConstructorVisibility(Visibility value) {
        super.beanConstructorVisibility(value);
        return this;
    }

    public RestClientBuilder beanClassVisibility(Visibility value) {
        super.beanClassVisibility(value);
        return this;
    }

    public RestClientBuilder beanFieldVisibility(Visibility value) {
        super.beanFieldVisibility(value);
        return this;
    }

    public RestClientBuilder methodVisibility(Visibility value) {
        super.methodVisibility(value);
        return this;
    }

    public RestClientBuilder useJavaBeanIntrospector(boolean value) {
        super.useJavaBeanIntrospector(value);
        return this;
    }

    public RestClientBuilder useInterfaceProxies(boolean value) {
        super.useInterfaceProxies(value);
        return this;
    }

    public RestClientBuilder ignoreUnknownBeanProperties(boolean value) {
        super.ignoreUnknownBeanProperties(value);
        return this;
    }

    public RestClientBuilder ignoreUnknownNullBeanProperties(boolean value) {
        super.ignoreUnknownNullBeanProperties(value);
        return this;
    }

    public RestClientBuilder ignorePropertiesWithoutSetters(boolean value) {
        super.ignorePropertiesWithoutSetters(value);
        return this;
    }

    public RestClientBuilder ignoreInvocationExceptionsOnGetters(boolean value) {
        super.ignoreInvocationExceptionsOnGetters(value);
        return this;
    }

    public RestClientBuilder ignoreInvocationExceptionsOnSetters(boolean value) {
        super.ignoreInvocationExceptionsOnSetters(value);
        return this;
    }

    public RestClientBuilder sortProperties(boolean value) {
        super.sortProperties(value);
        return this;
    }

    public RestClientBuilder notBeanPackages(String ... values) {
        super.notBeanPackages(values);
        return this;
    }

    public RestClientBuilder notBeanPackages(Collection<String> values) {
        super.notBeanPackages(values);
        return this;
    }

    public RestClientBuilder setNotBeanPackages(String ... values) {
        super.setNotBeanPackages(values);
        return this;
    }

    public RestClientBuilder setNotBeanPackages(Collection<String> values) {
        super.setNotBeanPackages(values);
        return this;
    }

    public RestClientBuilder removeNotBeanPackages(String ... values) {
        super.removeNotBeanPackages(values);
        return this;
    }

    public RestClientBuilder removeNotBeanPackages(Collection<String> values) {
        super.removeNotBeanPackages(values);
        return this;
    }

    public RestClientBuilder notBeanClasses(Class<?> ... values) {
        super.notBeanClasses((Class[])values);
        return this;
    }

    public RestClientBuilder notBeanClasses(Collection<Class<?>> values) {
        super.notBeanClasses(values);
        return this;
    }

    public RestClientBuilder setNotBeanClasses(Class<?> ... values) {
        super.setNotBeanClasses((Class[])values);
        return this;
    }

    public RestClientBuilder setNotBeanClasses(Collection<Class<?>> values) {
        super.setNotBeanClasses(values);
        return this;
    }

    public RestClientBuilder removeNotBeanClasses(Class<?> ... values) {
        super.removeNotBeanClasses((Class[])values);
        return this;
    }

    public RestClientBuilder removeNotBeanClasses(Collection<Class<?>> values) {
        super.removeNotBeanClasses(values);
        return this;
    }

    public RestClientBuilder beanFilters(Class<?> ... values) {
        super.beanFilters((Class[])values);
        return this;
    }

    public RestClientBuilder beanFilters(Collection<Class<?>> values) {
        super.beanFilters(values);
        return this;
    }

    public RestClientBuilder setBeanFilters(Class<?> ... values) {
        super.setBeanFilters((Class[])values);
        return this;
    }

    public RestClientBuilder setBeanFilters(Collection<Class<?>> values) {
        super.setBeanFilters(values);
        return this;
    }

    public RestClientBuilder removeBeanFilters(Class<?> ... values) {
        super.removeBeanFilters((Class[])values);
        return this;
    }

    public RestClientBuilder removeBeanFilters(Collection<Class<?>> values) {
        super.removeBeanFilters(values);
        return this;
    }

    public RestClientBuilder pojoSwaps(Class<?> ... values) {
        super.pojoSwaps((Class[])values);
        return this;
    }

    public RestClientBuilder pojoSwaps(Collection<Class<?>> values) {
        super.pojoSwaps(values);
        return this;
    }

    public RestClientBuilder setPojoSwaps(Class<?> ... values) {
        super.setPojoSwaps((Class[])values);
        return this;
    }

    public RestClientBuilder setPojoSwaps(Collection<Class<?>> values) {
        super.setPojoSwaps(values);
        return this;
    }

    public RestClientBuilder removePojoSwaps(Class<?> ... values) {
        super.removePojoSwaps((Class[])values);
        return this;
    }

    public RestClientBuilder removePojoSwaps(Collection<Class<?>> values) {
        super.removePojoSwaps(values);
        return this;
    }

    public RestClientBuilder implClasses(Map<Class<?>, Class<?>> values) {
        super.implClasses(values);
        return this;
    }

    public <T> RestClientBuilder implClass(Class<T> interfaceClass, Class<? extends T> implClass) {
        super.implClass(interfaceClass, implClass);
        return this;
    }

    public RestClientBuilder beanDictionary(Class<?> ... values) {
        super.beanDictionary((Class[])values);
        return this;
    }

    public RestClientBuilder beanDictionary(Collection<Class<?>> values) {
        super.beanDictionary(values);
        return this;
    }

    public RestClientBuilder setBeanDictionary(Class<?> ... values) {
        super.setBeanDictionary((Class[])values);
        return this;
    }

    public RestClientBuilder setBeanDictionary(Collection<Class<?>> values) {
        super.setBeanDictionary(values);
        return this;
    }

    public RestClientBuilder removeFromBeanDictionary(Class<?> ... values) {
        super.removeFromBeanDictionary((Class[])values);
        return this;
    }

    public RestClientBuilder removeFromBeanDictionary(Collection<Class<?>> values) {
        super.removeFromBeanDictionary(values);
        return this;
    }

    public RestClientBuilder beanTypePropertyName(String value) {
        super.beanTypePropertyName(value);
        return this;
    }

    public RestClientBuilder defaultParser(Class<?> value) {
        super.defaultParser(value);
        return this;
    }

    public RestClientBuilder locale(Locale value) {
        super.locale(value);
        return this;
    }

    public RestClientBuilder timeZone(TimeZone value) {
        super.timeZone(value);
        return this;
    }

    public RestClientBuilder mediaType(MediaType value) {
        super.mediaType(value);
        return this;
    }

    public RestClientBuilder debug(boolean value) {
        super.debug(value);
        this.debug = value;
        this.header("Debug", value);
        return this;
    }

    public RestClientBuilder property(String name, Object value) {
        super.property(name, value);
        return this;
    }

    public RestClientBuilder properties(Map<String, Object> properties) {
        super.properties(properties);
        return this;
    }

    public RestClientBuilder addToProperty(String name, Object value) {
        super.addToProperty(name, value);
        return this;
    }

    public RestClientBuilder putToProperty(String name, Object key, Object value) {
        super.putToProperty(name, key, value);
        return this;
    }

    public RestClientBuilder putToProperty(String name, Object value) {
        super.putToProperty(name, value);
        return this;
    }

    public RestClientBuilder removeFromProperty(String name, Object value) {
        super.removeFromProperty(name, value);
        return this;
    }

    public RestClientBuilder classLoader(ClassLoader classLoader) {
        super.classLoader(classLoader);
        return this;
    }

    public RestClientBuilder apply(PropertyStore copyFrom) {
        super.apply(copyFrom);
        return this;
    }

    public RestClientBuilder setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.httpClientBuilder.setRedirectStrategy(redirectStrategy);
        return this;
    }

    public RestClientBuilder setDefaultCookieSpecRegistry(Lookup<CookieSpecProvider> cookieSpecRegistry) {
        this.httpClientBuilder.setDefaultCookieSpecRegistry(cookieSpecRegistry);
        return this;
    }

    public RestClientBuilder setRequestExecutor(HttpRequestExecutor requestExec) {
        this.httpClientBuilder.setRequestExecutor(requestExec);
        return this;
    }

    public RestClientBuilder setSSLHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.httpClientBuilder.setSSLHostnameVerifier(hostnameVerifier);
        return this;
    }

    public RestClientBuilder setPublicSuffixMatcher(PublicSuffixMatcher publicSuffixMatcher) {
        this.httpClientBuilder.setPublicSuffixMatcher(publicSuffixMatcher);
        return this;
    }

    public RestClientBuilder setSSLContext(SSLContext sslContext) {
        this.httpClientBuilder.setSSLContext(sslContext);
        return this;
    }

    public RestClientBuilder setSSLSocketFactory(LayeredConnectionSocketFactory sslSocketFactory) {
        this.httpClientBuilder.setSSLSocketFactory(sslSocketFactory);
        return this;
    }

    public RestClientBuilder setMaxConnTotal(int maxConnTotal) {
        this.httpClientBuilder.setMaxConnTotal(maxConnTotal);
        return this;
    }

    public RestClientBuilder setMaxConnPerRoute(int maxConnPerRoute) {
        this.httpClientBuilder.setMaxConnPerRoute(maxConnPerRoute);
        return this;
    }

    public RestClientBuilder setDefaultSocketConfig(SocketConfig config) {
        this.httpClientBuilder.setDefaultSocketConfig(config);
        return this;
    }

    public RestClientBuilder setDefaultConnectionConfig(ConnectionConfig config) {
        this.httpClientBuilder.setDefaultConnectionConfig(config);
        return this;
    }

    public RestClientBuilder setConnectionTimeToLive(long connTimeToLive, TimeUnit connTimeToLiveTimeUnit) {
        this.httpClientBuilder.setConnectionTimeToLive(connTimeToLive, connTimeToLiveTimeUnit);
        return this;
    }

    public RestClientBuilder setConnectionManager(HttpClientConnectionManager connManager) {
        this.httpClientConnectionManager = connManager;
        this.httpClientBuilder.setConnectionManager(connManager);
        return this;
    }

    public RestClientBuilder setConnectionManagerShared(boolean shared) {
        this.httpClientBuilder.setConnectionManagerShared(shared);
        return this;
    }

    public RestClientBuilder setConnectionReuseStrategy(ConnectionReuseStrategy reuseStrategy) {
        this.httpClientBuilder.setConnectionReuseStrategy(reuseStrategy);
        return this;
    }

    public RestClientBuilder setKeepAliveStrategy(ConnectionKeepAliveStrategy keepAliveStrategy) {
        this.httpClientBuilder.setKeepAliveStrategy(keepAliveStrategy);
        return this;
    }

    public RestClientBuilder setTargetAuthenticationStrategy(AuthenticationStrategy targetAuthStrategy) {
        this.httpClientBuilder.setTargetAuthenticationStrategy(targetAuthStrategy);
        return this;
    }

    public RestClientBuilder setProxyAuthenticationStrategy(AuthenticationStrategy proxyAuthStrategy) {
        this.httpClientBuilder.setProxyAuthenticationStrategy(proxyAuthStrategy);
        return this;
    }

    public RestClientBuilder setUserTokenHandler(UserTokenHandler userTokenHandler) {
        this.httpClientBuilder.setUserTokenHandler(userTokenHandler);
        return this;
    }

    public RestClientBuilder disableConnectionState() {
        this.httpClientBuilder.disableConnectionState();
        return this;
    }

    public RestClientBuilder setSchemePortResolver(SchemePortResolver schemePortResolver) {
        this.httpClientBuilder.setSchemePortResolver(schemePortResolver);
        return this;
    }

    public RestClientBuilder setUserAgent(String userAgent) {
        this.httpClientBuilder.setUserAgent(userAgent);
        return this;
    }

    public RestClientBuilder setDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.httpClientBuilder.setDefaultHeaders(defaultHeaders);
        return this;
    }

    public RestClientBuilder addInterceptorFirst(HttpResponseInterceptor itcp) {
        this.httpClientBuilder.addInterceptorFirst(itcp);
        return this;
    }

    public RestClientBuilder addInterceptorLast(HttpResponseInterceptor itcp) {
        this.httpClientBuilder.addInterceptorLast(itcp);
        return this;
    }

    public RestClientBuilder addInterceptorFirst(HttpRequestInterceptor itcp) {
        this.httpClientBuilder.addInterceptorFirst(itcp);
        return this;
    }

    public RestClientBuilder addInterceptorLast(HttpRequestInterceptor itcp) {
        this.httpClientBuilder.addInterceptorLast(itcp);
        return this;
    }

    public RestClientBuilder disableCookieManagement() {
        this.httpClientBuilder.disableCookieManagement();
        return this;
    }

    public RestClientBuilder disableContentCompression() {
        this.httpClientBuilder.disableContentCompression();
        return this;
    }

    public RestClientBuilder disableAuthCaching() {
        this.httpClientBuilder.disableAuthCaching();
        return this;
    }

    public RestClientBuilder setHttpProcessor(HttpProcessor httpprocessor) {
        this.httpClientBuilder.setHttpProcessor(httpprocessor);
        return this;
    }

    public RestClientBuilder setRetryHandler(HttpRequestRetryHandler retryHandler) {
        this.httpClientBuilder.setRetryHandler(retryHandler);
        return this;
    }

    public RestClientBuilder disableAutomaticRetries() {
        this.httpClientBuilder.disableAutomaticRetries();
        return this;
    }

    public RestClientBuilder setProxy(HttpHost proxy) {
        this.httpClientBuilder.setProxy(proxy);
        return this;
    }

    public RestClientBuilder setRoutePlanner(HttpRoutePlanner routePlanner) {
        this.httpClientBuilder.setRoutePlanner(routePlanner);
        return this;
    }

    public RestClientBuilder disableRedirectHandling() {
        this.httpClientBuilder.disableRedirectHandling();
        return this;
    }

    public RestClientBuilder setConnectionBackoffStrategy(ConnectionBackoffStrategy connectionBackoffStrategy) {
        this.httpClientBuilder.setConnectionBackoffStrategy(connectionBackoffStrategy);
        return this;
    }

    public RestClientBuilder setBackoffManager(BackoffManager backoffManager) {
        this.httpClientBuilder.setBackoffManager(backoffManager);
        return this;
    }

    public RestClientBuilder setServiceUnavailableRetryStrategy(ServiceUnavailableRetryStrategy serviceUnavailStrategy) {
        this.httpClientBuilder.setServiceUnavailableRetryStrategy(serviceUnavailStrategy);
        return this;
    }

    public RestClientBuilder setDefaultCookieStore(CookieStore cookieStore) {
        this.httpClientBuilder.setDefaultCookieStore(cookieStore);
        return this;
    }

    public RestClientBuilder setDefaultCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        return this;
    }

    public RestClientBuilder setDefaultAuthSchemeRegistry(Lookup<AuthSchemeProvider> authSchemeRegistry) {
        this.httpClientBuilder.setDefaultAuthSchemeRegistry(authSchemeRegistry);
        return this;
    }

    public RestClientBuilder setContentDecoderRegistry(Map<String, InputStreamFactory> contentDecoderMap) {
        this.httpClientBuilder.setContentDecoderRegistry(contentDecoderMap);
        return this;
    }

    public RestClientBuilder setDefaultRequestConfig(RequestConfig config) {
        this.httpClientBuilder.setDefaultRequestConfig(config);
        return this;
    }

    public RestClientBuilder useSystemProperties() {
        this.httpClientBuilder.useSystemProperties();
        return this;
    }

    public RestClientBuilder evictExpiredConnections() {
        this.httpClientBuilder.evictExpiredConnections();
        return this;
    }

    public RestClientBuilder evictIdleConnections(long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.httpClientBuilder.evictIdleConnections(maxIdleTime, maxIdleTimeUnit);
        return this;
    }
}

