/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.vars;

import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.svl.SimpleVar;
import org.apache.juneau.svl.VarResolverSession;

public class RequestVar
extends SimpleVar {
    public static final String SESSION_req = "req";
    public static final String NAME = "R";

    public RequestVar() {
        super(NAME);
    }

    public String resolve(VarResolverSession session, String key) {
        RestRequest req = (RestRequest)((Object)session.getSessionObject(RestRequest.class, SESSION_req));
        if (key.length() > 0) {
            Object o;
            char c;
            String k = key.toString();
            if (k.indexOf(46) != -1) {
                String prefix = k.substring(0, k.indexOf(46));
                String remainder = k.substring(k.indexOf(46) + 1);
                if ("path".equals(prefix)) {
                    return req.getPathParameter(remainder);
                }
                if ("query".equals(prefix)) {
                    return req.getQueryParameter(remainder);
                }
                if ("formData".equals(prefix)) {
                    return req.getFormDataParameter(remainder);
                }
                if ("header".equals(prefix)) {
                    return req.getHeader(remainder);
                }
                if ("attribute".equals(prefix)) {
                    return StringUtils.toString((Object)req.getAttribute(remainder));
                }
            }
            if ((c = key.charAt(0)) == 'c') {
                if (key.equals("contextPath")) {
                    return req.getContextPath();
                }
            } else if (c == 'm') {
                if (key.equals("method")) {
                    return req.getMethod();
                }
                if (key.equals("methodSummary")) {
                    return req.getMethodSummary();
                }
                if (key.equals("methodDescription")) {
                    return req.getMethodDescription();
                }
            } else if (c == 'p') {
                if (key.equals("pathInfo")) {
                    return req.getPathInfo();
                }
            } else if (c == 'r') {
                if (key.equals("requestURI")) {
                    return req.getRequestURI();
                }
                if (key.equals("relativeServletURI")) {
                    return req.getRelativeServletURI();
                }
                if (key.equals("requestParentURI")) {
                    return req.getRequestParentURI();
                }
            } else if (c == 's') {
                if (key.equals("servletPath")) {
                    return req.getServletPath();
                }
                if (key.equals("servletURI")) {
                    return req.getServletURI();
                }
                if (key.equals("servletParentURI")) {
                    return req.getServletParentURI();
                }
                if (key.equals("servletTitle")) {
                    return req.getServletTitle();
                }
                if (key.equals("servletDescription")) {
                    return req.getServletDescription();
                }
            } else if (c == 't' && key.equals("trimmedRequestURI")) {
                return req.getTrimmedRequestURI();
            }
            if ((o = req.getProperties().get((Object)key)) != null) {
                return o.toString();
            }
            return req.getPathParameter(key);
        }
        return null;
    }
}

